/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.launch;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.clustering.Ensemble;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.clustering.mst.MSTCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.clusterRun;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.dataItem;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.getClusters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.sortCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.launch.Settings;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.launch.makeDistMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.mapping.cartogram.DEC;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.mapping.som.SOM;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Run {
    private static boolean substance = true;
    private boolean fillMissing = false;
    public boolean openingFile = false;
    private static JFrame splash;
    private boolean negativeLog = false;
    private launchSplash ls;
    private TaskMonitor monitor;
    private int runCount = 0;
    private int progressCount = 0;
    private int totalProgress = 0;
    private List<clusterRun> clusterRuns = new ArrayList<clusterRun>();
    private clusterRun ensemble;
    private Thread[] threads;
    private ArrayList storeMapping = new ArrayList();
    private static boolean runGUI;

    public Run(boolean splash) {
        if (splash) {
            this.ls = new launchSplash();
            Thread t = new Thread(this.ls);
            t.start();
            try {
                t.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Run() {
    }

    public clusterRun runAutoSOMEBasic(Settings s, TaskMonitor monitor) {
        long t = System.currentTimeMillis();
        this.monitor = monitor;
        if (s.fillMissing) {
            s.input = this.addMissing(s.input, s);
        }
        if (s.distMatrix) {
            if (s.unitVar || s.scale > 0 || s.logNorm) {
                if (s.unitVar && s.logNorm) {
                    s.unitVar = false;
                    s.input = this.norm(s);
                    s.unitVar = true;
                    s.logNorm = false;
                    s.input = this.norm(s);
                    s.logNorm = true;
                } else {
                    s.input = this.norm(s);
                }
            }
            if (s.medCenter || s.medCenterCol) {
                s.input = this.medCenter(s);
            }
            if (s.sumSqrRows || s.sumSqrCol) {
                s.input = this.getSumSqr(s);
            }
            if (this.negativeLog && s.logNorm) {
                return null;
            }
            s.input = new makeDistMatrix().getDistMatrix(s);
            if (s.benchmark) {
                s.convertDMLabels();
            }
        }
        s.inputSize = s.input.length;
        if (!s.distMatrix) {
            if (s.unitVar || s.scale > 0 || s.logNorm) {
                if (s.unitVar && s.logNorm) {
                    s.unitVar = false;
                    s.input = this.norm(s);
                    s.unitVar = true;
                    s.logNorm = false;
                    s.input = this.norm(s);
                    s.logNorm = true;
                } else {
                    s.input = this.norm(s);
                }
            }
            if (s.medCenter || s.medCenterCol) {
                s.input = this.medCenter(s);
            }
            if (s.sumSqrRows || s.sumSqrCol) {
                s.input = this.getSumSqr(s);
            }
        } else if (s.unitVarAfterDM) {
            s.input = this.norm(s);
        }
        if (this.negativeLog && s.logNorm) {
            return null;
        }
        s.setInputMinMax();
        if (s.Pearson) {
            s.setCenter();
        }
        this.invokeAutoSOME(s);
        s.runTime = this.getrunTime(t);
        try {
            return this.doOutput(s, this.clusterRuns);
        }
        catch (Exception err) {
            return new clusterRun();
        }
    }

    private void invokeAutoSOME(Settings s) {
        int q;
        if (!s.batch) {
            // empty if block
        }
        if (s.doSM || s.verbose) {
            // empty if block
        }
        if (s.ensemble_runs > 1) {
            this.clusterRuns = new ArrayList<clusterRun>();
            this.monitor.setStatusMessage("Clustering " + s.input.length + " rows by " + s.input[0].getValues().length + " columns");
        }
        long maxMemory = Runtime.getRuntime().maxMemory() / 0x100000L;
        if (s.writeTemp || s.input.length < 100000 && (s.input.length < 50000 && s.input.length * s.input[0].getValues().length < 1200000 || s.ensemble_runs <= 500 || maxMemory > 1600L) || runGUI) {
            // empty if block
        }
        this.threads = new Thread[s.threads];
        for (q = 0; q < this.threads.length; ++q) {
            this.threads[q] = new Thread(new runAutoSOME(s, q * s.ensemble_runs / this.threads.length, (q + 1) * s.ensemble_runs / this.threads.length));
            this.threads[q].start();
        }
        try {
            for (q = 0; q < this.threads.length; ++q) {
                this.threads[q].join();
            }
            if (this.progressCount < 10 && !s.batch && s.ensemble_runs > 1) {
                while (this.progressCount < 10) {
                    boolean currVal = false;
                    ++this.progressCount;
                }
            }
        }
        catch (Exception err) {
            // empty catch block
        }
        if (s.ensemble_runs > 1 && !s.batch) {
            this.ensemble = new Ensemble(this.clusterRuns, true, 0, !s.doKmeans && !s.doHierarchical, s, this.monitor).run();
        }
    }

    private Object[] doMapping(Settings s) {
        ArrayList dataLabels = new ArrayList();
        float[][] coors = new float[1][1];
        if (!s.doSM) {
            SOM som = new SOM(s);
            som.run();
            s.som_gridSize = som.getGridSize();
            Object[] info = som.getDEInfo(3.0);
            dataLabels = (ArrayList)info[2];
            if (s.doCart) {
                coors = new DEC((ArrayList[])info[0], (float[])info[1], (float[])info[3], (ArrayList[])info[4], true, false, s.de_resolution, s.de_resolution).makeCartogram();
            } else {
                ArrayList[] somCoors = (ArrayList[])info[0];
                coors = new float[somCoors.length * 4][3];
                int itor = 0;
                for (int j = 0; j < somCoors.length; ++j) {
                    float[][] f = (float[][])somCoors[j].get(0);
                    for (int p = 0; p < f.length; ++p) {
                        coors[itor][0] = f[p][0];
                        coors[itor][1] = f[p][1];
                        coors[itor++][2] = f[p][2];
                    }
                }
            }
        }
        Object[] results = new Object[]{coors, dataLabels};
        return results;
    }

    public clusterRun doClustering(Settings s, float[][] coors, ArrayList dataLabels) {
        MSTCluster mst = new MSTCluster(s.ensemble_runs > 1);
        mst.run(new JProgressBar(), coors, dataLabels, s.mst_pval, s.mst_MC, true, s);
        clusterRun cr = mst.getClusterRun();
        cr.setInputFile(new String(s.inputFile));
        return cr;
    }

    public clusterRun doOutput(Settings s, List<clusterRun> clusterRuns) {
        if (clusterRuns.isEmpty()) {
            return null;
        }
        clusterRun cr = clusterRuns.get(0);
        if (clusterRuns.size() > 1) {
            cr.c = this.ensemble.c;
        }
        getClusters clust = new getClusters(cr, s);
        if (clusterRuns.size() == 1 && !s.doKmeans && !s.doHierarchical) {
            clust.findClusters(true);
            cr.c = clust.getClust();
        }
        if (s.confidence && s.ensemble_runs > 1 && clusterRuns.size() > 1) {
            sortCluster sc = new sortCluster();
            for (int i = 0; i < cr.c.length; ++i) {
                cr.c[i] = sc.sortConf(cr.c[i], s);
                for (int j = 0; j < cr.c[i].ids.size(); ++j) {
                    int id = Integer.valueOf(cr.c[i].ids.get(j).toString());
                    s.input[id].setConf(Integer.valueOf(cr.c[i].confidence.get(j).toString()));
                }
            }
        }
        if (s.ensemble_runs == 1 || clusterRuns.size() == 1) {
            s.confidence = false;
        }
        Arrays.sort(cr.c);
        return cr;
    }

    private static void printBanner() {
    }

    public String getrunTime(long t) {
        DecimalFormat Format2 = new DecimalFormat();
        Format2.setMinimumFractionDigits(0);
        DecimalFormat Format22 = new DecimalFormat("#");
        Format22.setMinimumFractionDigits(2);
        double runT = System.currentTimeMillis() - t;
        String rt = runT < 1000.0 ? String.valueOf(Format2.format(runT)).concat(" msecs") : (runT < 60000.0 ? String.valueOf(Format22.format(runT / 1000.0)).concat(" secs") : String.valueOf(Format22.format(runT / 60000.0)).concat(" mins"));
        return rt;
    }

    public dataItem[] medCenter(Settings s) {
        int j;
        float median;
        float[] sort;
        int i;
        if (s.medCenter) {
            for (i = 0; i < s.input.length; ++i) {
                sort = new float[s.input[i].getValues().length];
                for (int j2 = 0; j2 < s.input[i].getValues().length; ++j2) {
                    sort[j2] = s.input[i].getValues()[j2];
                }
                Arrays.sort(sort);
                median = sort.length % 2 != 0 ? sort[(int)Math.floor(sort.length / 2)] : (sort[sort.length / 2] + sort[(int)Math.floor(sort.length / 2)]) / 2.0f;
                j = 0;
                while (j < s.input[i].getValues().length) {
                    float[] fArray = s.input[i].getValues();
                    int n = j++;
                    fArray[n] = fArray[n] - median;
                }
            }
        }
        if (s.medCenterCol) {
            for (i = 0; i < s.input[0].getValues().length; ++i) {
                sort = new float[s.input.length];
                for (int j3 = 0; j3 < s.input.length; ++j3) {
                    sort[j3] = s.input[j3].getValues()[i];
                }
                Arrays.sort(sort);
                median = sort.length % 2 != 0 ? sort[(int)Math.floor(sort.length / 2)] : (sort[sort.length / 2] + sort[(int)Math.floor(sort.length / 2)]) / 2.0f;
                for (j = 0; j < s.input.length; ++j) {
                    float[] fArray = s.input[j].getValues();
                    int n = i;
                    fArray[n] = fArray[n] - median;
                }
            }
        }
        return s.input;
    }

    public dataItem[] getSumSqr(Settings s) {
        int j;
        double sqrRoot;
        float sumSqr;
        int i;
        if (s.sumSqrRows) {
            for (i = 0; i < s.input.length; ++i) {
                sumSqr = 0.0f;
                for (int j2 = 0; j2 < s.input[i].getValues().length; ++j2) {
                    sumSqr += s.input[i].getValues()[j2] * s.input[i].getValues()[j2];
                }
                sqrRoot = Math.sqrt(1.0 / (double)sumSqr);
                if (Double.isNaN(sqrRoot)) {
                    sqrRoot = 0.0;
                }
                j = 0;
                while (j < s.input[i].getValues().length) {
                    float[] fArray = s.input[i].getValues();
                    int n = j++;
                    fArray[n] = (float)((double)fArray[n] * sqrRoot);
                }
            }
        }
        if (s.sumSqrCol) {
            for (i = 0; i < s.input[0].getValues().length; ++i) {
                sumSqr = 0.0f;
                for (int j3 = 0; j3 < s.input.length; ++j3) {
                    sumSqr += s.input[j3].getValues()[i] * s.input[j3].getValues()[i];
                }
                sqrRoot = Math.sqrt(1.0 / (double)sumSqr);
                if (Double.isNaN(sqrRoot)) {
                    sqrRoot = 0.0;
                }
                for (j = 0; j < s.input.length; ++j) {
                    float[] fArray = s.input[j].getValues();
                    int n = i;
                    fArray[n] = (float)((double)fArray[n] * sqrRoot);
                }
            }
        }
        return s.input;
    }

    public dataItem[] norm(Settings s) {
        dataItem[] d = s.input;
        if (s.unitVar || s.scale > 0 || s.logNorm) {
            for (int i = 0; i < d[0].getValues().length; ++i) {
                float stdev;
                float sum = 0.0f;
                float max = Float.MIN_VALUE;
                float min = Float.MAX_VALUE;
                for (int j = 0; j < d.length; ++j) {
                    sum += d[j].getValues()[i];
                    if (d[j].getValues()[i] > max) {
                        max = d[j].getValues()[i];
                    }
                    if (!(d[j].getValues()[i] < min)) continue;
                    min = d[j].getValues()[i];
                }
                float ave = sum / (float)d.length;
                float x = 0.0f;
                if (s.unitVar) {
                    for (int j = 0; j < d.length; ++j) {
                        x = (float)((double)x + Math.pow(d[j].getValues()[i] - ave, 2.0));
                    }
                }
                if ((stdev = (float)Math.sqrt(x / ((float)d.length - 1.0f))) == 0.0f) {
                    stdev = 1.0f;
                }
                for (int j = 0; j < d.length; ++j) {
                    if (s.unitVar) {
                        d[j].getValues()[i] = (d[j].getValues()[i] - ave) / stdev;
                        continue;
                    }
                    if (s.logNorm) {
                        if (d[j].getValues()[i] <= 0.0f) {
                            d[j].getValues()[i] = 1.0E-8f;
                        }
                        d[j].getValues()[i] = (float)(Math.log10(d[j].getValues()[i]) / Math.log10(2.0));
                        continue;
                    }
                    d[j].getValues()[i] = (float)s.scale * (d[j].getValues()[i] - min) / (max - min);
                }
            }
        }
        return d;
    }

    private dataItem[] addMissing(dataItem[] d, Settings s) {
        if (s.mvCol) {
            for (int i = 0; i < d[0].getValues().length; ++i) {
                ArrayList<Float> notMissing = new ArrayList<Float>();
                for (int j = 0; j < d.length; ++j) {
                    if (d[j].getValues()[i] == -1.0E8f) continue;
                    notMissing.add(Float.valueOf(d[j].getValues()[i]));
                }
                float[] sort = new float[notMissing.size()];
                float sum = 0.0f;
                float median = 0.0f;
                if (sort.length > 0) {
                    for (int l = 0; l < sort.length; ++l) {
                        sort[l] = Float.valueOf(notMissing.get(l).toString()).floatValue();
                        sum += sort[l];
                    }
                    Arrays.sort(sort);
                    median = sort.length % 2 != 0 ? sort[(int)Math.floor(sort.length / 2)] : (sort[sort.length / 2] + sort[(int)Math.floor(sort.length / 2)]) / 2.0f;
                }
                for (int j = 0; j < d.length; ++j) {
                    if (d[j].getValues()[i] != -1.0E8f) continue;
                    float f = s.mvMedian ? median : (d[j].getValues()[i] = sort.length > 0 ? sum / (float)sort.length : 0.0f);
                    if (Float.isNaN(d[j].getValues()[i])) {
                        d[j].getValues()[i] = 0.0f;
                    }
                    d[j].setOriginalValue(i, d[j].getValues()[i]);
                }
            }
        } else {
            for (int i = 0; i < d.length; ++i) {
                ArrayList<Float> notMissing = new ArrayList<Float>();
                for (int j = 0; j < d[i].getValues().length; ++j) {
                    if (d[i].getValues()[j] == -1.0E8f) continue;
                    notMissing.add(Float.valueOf(d[i].getValues()[j]));
                }
                float[] sort = new float[notMissing.size()];
                float sum = 0.0f;
                float median = 0.0f;
                if (sort.length > 0) {
                    for (int l = 0; l < sort.length; ++l) {
                        sort[l] = Float.valueOf(notMissing.get(l).toString()).floatValue();
                        sum += sort[l];
                    }
                    Arrays.sort(sort);
                    median = sort.length % 2 != 0 ? sort[(int)Math.floor(sort.length / 2)] : (sort[sort.length / 2] + sort[(int)Math.floor(sort.length / 2)]) / 2.0f;
                }
                for (int j = 0; j < d[i].getValues().length; ++j) {
                    if (d[i].getValues()[j] != -1.0E8f) continue;
                    float f = s.mvMedian ? median : (d[i].getValues()[j] = sort.length > 0 ? sum / (float)sort.length : 0.0f);
                    if (Float.isNaN(d[j].getValues()[i])) {
                        d[j].getValues()[i] = 0.0f;
                    }
                    d[i].setOriginalValue(j, d[i].getValues()[j]);
                }
            }
        }
        return d;
    }

    private void writeTemp(clusterRun cr, int start, Settings s) {
        try {
            FileOutputStream fos = new FileOutputStream(s.outputDirectory + s.getFolderDivider() + s.getName() + "_temp" + s.getFolderDivider() + start);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(cr);
            oos.close();
        }
        catch (IOException err) {
            // empty catch block
        }
    }

    public void kill() {
        if (this.threads == null) {
            return;
        }
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i].stop();
        }
    }

    public ArrayList getMappingArrayList() {
        return this.storeMapping;
    }

    static {
        runGUI = false;
    }

    public class launchSplash
    implements Runnable {
        public void run() {
            splash = new JFrame();
            splash.setDefaultCloseOperation(1);
            splash.setUndecorated(true);
            JLabel jLabel1 = new JLabel();
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/imgs/autosomebanner.jpg"));
            jLabel1.setIcon(icon);
            splash.add(jLabel1);
            splash.pack();
            splash.setLocationRelativeTo(null);
            splash.setAlwaysOnTop(true);
            splash.setVisible(true);
            this.appInit();
        }

        public void appInit() {
            try {
                Thread.sleep(2200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            splash.setVisible(false);
        }
    }

    public class runAutoSOME
    implements Runnable {
        Settings s;
        int start;
        int end;

        public runAutoSOME(Settings s, int start, int end) {
            this.s = s;
            this.start = start;
            this.end = end;
        }

        public void run() {
            while (this.start < this.end) {
                try {
                    Object[] results = Run.this.doMapping(this.s);
                    Run.this.storeMapping.add(results);
                    float[][] coors = (float[][])results[0];
                    ArrayList dataLabels = (ArrayList)results[1];
                    clusterRun cr = Run.this.doClustering(this.s, coors, dataLabels);
                    if (this.start >= 10) {
                        cr.DEC = null;
                    }
                    if (!this.s.writeTemp) {
                        Run.this.clusterRuns.add(cr);
                    }
                    Run.this.totalProgress++;
                    Run.this.monitor.setProgress((double)Run.this.totalProgress / (double)this.s.ensemble_runs);
                    if (!this.s.batch && this.s.ensemble_runs > 1 && Math.floor((double)Run.this.runCount++ % ((double)this.s.ensemble_runs / 10.0)) == 0.0) {
                        Run.this.progressCount++;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++this.start;
            }
        }
    }
}

