/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.launch;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.dataItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class Settings
implements Serializable {
    public String inputFile = new String();
    public int threads = Runtime.getRuntime().availableProcessors();
    public int som_iters = 500;
    public int som_minGrid = 5;
    public int som_maxGrid = 30;
    public int som_gridSize = 0;
    public boolean som_circle = true;
    public double som_theta = 1.5;
    public double som_DEScale = 3.0;
    public int de_resolution = 32;
    public boolean doCart = true;
    public int sm_iters = 100;
    public boolean doSM = false;
    public int mst_MC = 10;
    public double mst_pval = 0.1;
    public int ensemble_runs = 50;
    public int known_clusters = 0;
    public boolean doKmeans = false;
    public boolean doHierarchical = false;
    public int hierarchical_choice = 4;
    public String outputDirectory = "C:";
    public boolean htmlOut = true;
    public boolean textOut = true;
    public boolean display3D = false;
    public boolean display2D = false;
    public boolean noMapping = false;
    public boolean verbose = false;
    public boolean batch = false;
    public boolean benchmark = false;
    public boolean unitVar = false;
    public boolean logNorm = false;
    public int scale = 0;
    public int trials = 10;
    public int inputSize;
    public boolean confidence = true;
    public int conf_Thresh = 0;
    public dataItem[] input;
    public float inputMin;
    public float inputMax;
    public List<String> discarded = new ArrayList<String>();
    public String subFile = new String();
    public int startData = 1;
    public int yStartData = 1;
    public boolean invokeViewerOnly = false;
    public String runTime = new String();
    public String[] columnHeaders;
    public String[][] metaColumnLabels;
    public boolean readColumns = false;
    public boolean trBM = false;
    public float[] center;
    public boolean Pearson = false;
    public boolean unCentered = false;
    public boolean distMatrix = false;
    public int dmDist = 1;
    public boolean medCenter = false;
    public boolean medCenterCol = false;
    public boolean unitVarAfterDM = false;
    public boolean printConsMatrix = false;
    public boolean writeTemp = false;
    public boolean sumSqrRows = false;
    public boolean sumSqrCol = false;
    public String add = new String();
    public boolean PCLformat = false;
    public boolean GEOformat = false;
    public double[] EWEIGHT;
    public boolean mvMedian = true;
    public boolean mvCol = true;
    public int[] columnClusters;
    public int[] oldOrder;
    public HashMap kept = new HashMap();
    public int printRowsCols = 0;
    public boolean fillMissing = false;
    public boolean FCNrows = false;

    public void setParams(String[] args) {
        if (args.length > 1) {
            System.out.println("===================Settings====================");
        }
        block49: for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                String setting = args[i].substring(1);
                switch (setting.charAt(0)) {
                    case 't': {
                        this.threads = Integer.valueOf(setting.substring(1));
                        System.out.println(">Number Of CPUs Set To: " + this.threads);
                        break;
                    }
                    case 'i': {
                        this.som_iters = Integer.valueOf(setting.substring(1));
                        System.out.println(">SOM Iterations Set To: " + this.som_iters);
                        break;
                    }
                    case 'm': {
                        this.som_minGrid = Integer.valueOf(setting.substring(1));
                        System.out.println(">SOM Minimum Grid Size Set To: " + this.som_minGrid);
                        break;
                    }
                    case 'M': {
                        this.som_maxGrid = Integer.valueOf(setting.substring(1));
                        System.out.println(">SOM Maximum Grid Size Set To: " + this.som_maxGrid);
                        break;
                    }
                    case 'g': {
                        this.som_gridSize = Integer.valueOf(setting.substring(1));
                        System.out.println(">SOM square x/y grid size set to: " + this.som_gridSize);
                        break;
                    }
                    case 's': {
                        this.som_circle = false;
                        System.out.println(">SOM Topology Set To Square");
                        break;
                    }
                    case 'd': {
                        this.som_theta = Double.valueOf(setting.substring(1));
                        System.out.println(">SOM error dampener 'theta'  set to: " + this.som_theta);
                        break;
                    }
                    case 'x': {
                        this.som_DEScale = Double.valueOf(setting.substring(1));
                        System.out.println(">SOM error raised to exponent: " + this.som_DEScale);
                        break;
                    }
                    case 'r': {
                        this.de_resolution = Integer.valueOf(setting.substring(1));
                        System.out.println(">Cartogram x/y resolution set to: " + this.de_resolution);
                        break;
                    }
                    case 'E': {
                        this.doCart = false;
                        System.out.println(">Disable Density-Equalizing Cartogram");
                        break;
                    }
                    case 'S': {
                        this.doSM = true;
                        String xtra = new String();
                        if (setting.length() > 1) {
                            this.sm_iters = Integer.valueOf(setting.substring(1));
                            xtra = " with " + this.sm_iters + " iterations";
                        }
                        System.out.println(">Do Sammon Mapping" + xtra);
                        break;
                    }
                    case 'c': {
                        this.mst_MC = Integer.valueOf(setting.substring(1));
                        System.out.println(">Monte Carlo simulations set to: " + this.mst_MC);
                        break;
                    }
                    case 'p': {
                        this.mst_pval = Double.valueOf(setting.substring(1));
                        System.out.println(">Minimum Spanning Tree P-value set to: " + this.mst_pval);
                        break;
                    }
                    case 'e': {
                        this.ensemble_runs = Integer.valueOf(setting.substring(1));
                        if (this.ensemble_runs == 1) {
                            System.out.println(">Ensemble disabled");
                            break;
                        }
                        System.out.println(">Merge " + this.ensemble_runs + " Clustering Runs");
                        break;
                    }
                    case 'k': {
                        this.known_clusters = Integer.valueOf(setting.substring(1));
                        System.out.println(">Number Of Clusters Set To: " + this.known_clusters);
                        break;
                    }
                    case 'K': {
                        this.doKmeans = true;
                        System.out.println(">Clustering Algorithm: K-means");
                        break;
                    }
                    case 'A': {
                        this.doHierarchical = true;
                        String choice = "Ward's method";
                        if (setting.length() > 1) {
                            this.hierarchical_choice = Integer.valueOf(setting.substring(1));
                            switch (this.hierarchical_choice) {
                                case 1: {
                                    choice = "Single Linkage";
                                    break;
                                }
                                case 2: {
                                    choice = "Complete Linkage";
                                    break;
                                }
                                case 3: {
                                    choice = "Average Linkage";
                                    break;
                                }
                                case 4: {
                                    choice = "Ward's Method";
                                }
                            }
                        }
                        System.out.println(">Clustering Algorithm: " + choice);
                        break;
                    }
                    case 'D': {
                        this.outputDirectory = setting.substring(1);
                        System.out.println(">Write Output to: " + this.outputDirectory);
                        break;
                    }
                    case 'H': {
                        this.htmlOut = false;
                        System.out.println(">No html Output");
                        break;
                    }
                    case 'O': {
                        this.textOut = false;
                        System.out.println(">No Text Output");
                        break;
                    }
                    case 'v': {
                        if (setting.length() > 1) {
                            if (Integer.valueOf(setting.substring(1)) != 2) break;
                            System.out.println(">Display Clustering Results");
                            this.invokeViewerOnly = true;
                            break;
                        }
                        this.display2D = true;
                        System.out.println(">Launch Interactive Cluster Viewer");
                        break;
                    }
                    case 'R': {
                        this.noMapping = true;
                        System.out.println(">Do not perform dimensional reduction on input data");
                        break;
                    }
                    case 'V': {
                        this.verbose = true;
                        System.out.println(">Print Verbose Output");
                        break;
                    }
                    case 'B': {
                        this.batch = true;
                        System.out.println(">Using Batch Mode");
                        break;
                    }
                    case 'b': {
                        this.benchmark = true;
                        System.out.println(">Print Benchmark Values");
                        if (setting.length() <= 1) break;
                        this.trials = Integer.valueOf(setting.substring(1));
                        System.out.println(">" + this.trials + " trial runs per dataset");
                        break;
                    }
                    case 'n': {
                        int normChoice = Integer.valueOf(setting.substring(1));
                        if (normChoice == 1) {
                            this.unitVar = true;
                            System.out.println(">Normalize Input to Unit Variance");
                            break;
                        }
                        if (normChoice == 0) {
                            this.logNorm = true;
                            System.out.println(">Normalize Input to Logarithm Base 2");
                            break;
                        }
                        this.scale = Integer.valueOf(setting.substring(1));
                        System.out.println(">Normalize Input to Range [0," + this.scale + "]");
                        break;
                    }
                    case 'N': {
                        this.logNorm = true;
                        this.unitVar = true;
                        System.out.println(">Normalize Input: Log Base 2 with Unit Var");
                        break;
                    }
                    case 'F': {
                        if (setting.length() > 1) {
                            this.conf_Thresh = Integer.valueOf(setting.substring(1));
                            System.out.println(">Confidence Threshold: " + this.conf_Thresh);
                            break;
                        }
                        this.confidence = false;
                        System.out.println(">Do Not Report Cluster Confidence Values");
                        break;
                    }
                    case 'l': {
                        this.startData = Integer.valueOf(setting.substring(1));
                        System.out.println(">Start Reading Numerical Data From Column: " + this.startData);
                        break;
                    }
                    case 'C': {
                        this.readColumns = true;
                        System.out.println(">Read in Column Headers from First Row of Input");
                        break;
                    }
                    case 'P': {
                        if (setting.length() > 1) {
                            this.unCentered = true;
                            System.out.println(">SOM Distance Metric: Uncentered Correlation");
                            break;
                        }
                        this.Pearson = true;
                        System.out.println(">SOM Distance Metric: Pearson Correlation");
                        break;
                    }
                    case 'Q': {
                        this.distMatrix = true;
                        this.printConsMatrix = true;
                        System.out.println(">Transform Columns into Distance Matrix");
                        if (setting.length() <= 1) break;
                        this.dmDist = Integer.valueOf(setting.substring(1));
                        System.out.println(">Distance Matrix: " + (this.dmDist == 2 ? "Pearson's" : "Uncentered") + " Correlation");
                        break;
                    }
                    case 'j': {
                        int Choice;
                        if (setting.length() > 1) {
                            Choice = Integer.valueOf(setting.substring(1));
                            if (Choice == 1) {
                                this.medCenter = true;
                                System.out.println(">Median Center Normalization of All Rows");
                                break;
                            }
                            if (Choice == 2) {
                                this.medCenterCol = true;
                                System.out.println(">Median Center Normalization of All Columns");
                                break;
                            }
                            if (Choice != 3) continue block49;
                            this.medCenter = true;
                            this.medCenterCol = true;
                            System.out.println(">Median Center Normalization of All Rows and Columns");
                            break;
                        }
                        this.medCenter = true;
                        System.out.println(">Median Center Normalization of All Rows");
                        break;
                    }
                    case 'u': {
                        int Choice;
                        if (setting.length() > 1) {
                            Choice = Integer.valueOf(setting.substring(1));
                            if (Choice == 1) {
                                this.medCenter = true;
                                System.out.println(">Sum of Squares=1 Normalization of All Rows");
                                break;
                            }
                            if (Choice == 2) {
                                this.medCenterCol = true;
                                System.out.println(">Sum of Squares=1 Normalization of All Columns");
                                break;
                            }
                            if (Choice != 3) continue block49;
                            this.medCenter = true;
                            this.medCenterCol = true;
                            System.out.println(">Sum of Squares=1 Normalization of All Rows and Columns");
                            break;
                        }
                        this.medCenter = true;
                        System.out.println(">Median Center Normalization of All Rows");
                        break;
                    }
                    case 'h': {
                        int Choice;
                        if (setting.length() > 1) {
                            Choice = Integer.valueOf(setting.substring(1));
                            if (Choice == 1) {
                                this.mvMedian = false;
                                this.mvCol = false;
                                System.out.println(">Fill Missing Values with Means of Rows");
                                break;
                            }
                            if (Choice == 2) {
                                this.mvMedian = true;
                                this.mvCol = false;
                                System.out.println(">Fill Missing Values with Medians of Rows");
                                break;
                            }
                            if (Choice == 3) {
                                this.mvMedian = false;
                                this.mvCol = true;
                                System.out.println(">Fill Missing Values with Means of Columns");
                                break;
                            }
                            if (Choice != 4) continue block49;
                            this.mvMedian = true;
                            this.mvCol = true;
                            System.out.println(">Fill Missing Values with Medians of Columns");
                            break;
                        }
                        this.mvMedian = false;
                        this.mvCol = false;
                        System.out.println(">Fill Missing Values with Means of Rows");
                        break;
                    }
                    case '@': {
                        this.printConsMatrix = true;
                        System.out.println(">Print Consensus Cluster Matrix");
                        break;
                    }
                    case '$': {
                        this.writeTemp = true;
                        System.out.println(">Write Intermediate Data to Temp Folder");
                        break;
                    }
                    case 'o': {
                        this.printDefaultSettings();
                        System.exit(1);
                        break;
                    }
                    case '#': {
                        this.unitVarAfterDM = true;
                        System.out.println(">Apply Unit Variance Normalization to Distance Matrix");
                        break;
                    }
                    case 'w': {
                        this.PCLformat = true;
                        System.out.println(">Parse PCL formatted input file.");
                        break;
                    }
                    case 'W': {
                        this.GEOformat = true;
                        System.out.println(">Parse Gene Expression Omnibus Series Matrix formatted input file.");
                    }
                }
                continue;
            }
            this.inputFile = args[i];
        }
        if (args.length > 1) {
            System.out.println("===============================================\n");
        }
    }

    public void printDefaultSettings() {
        System.out.println("\n>Usage:\njava -jar autosome.jar [Input] [Options]\n\n>maximum JVM memory recommended, e.g. \njava -jar -Xmx1600m -Xms1600m -jar autosome.jar input.txt -p.01 -e30 -v -DC:\\out\n\n>Options:\nparameter | description (default value)\n\n-t[integer] set number of threads (available CPUs)\n-e[integer] set number of runs to merge into ensemble (50)\n-p[0-1] set p-value threshold for minimum spanning tree clustering (0.1)\n-D[directory] set output directory (same directory as input file)\n-C read in column headers from first row of input file (auto-detect otherwise)\n-v launch cluster viewer (false)\n-v2 open previous clustering results: input=clustering output text file (false)\n-n[integer] normalize input by unit variance '-n1', to log2 '-n0' or into range [0,X] '-nX' (false)\n-j[1,2,3] 1=perform median center normalization on all rows;2=columns;3=rows and columns\n-u[1,2,3] 1=perform sum of squares=1 normalization on all rows;2=columns;3=rows and columns\n-N normalize input to log2 with unit variance (false)\n-# apply unit variance normalization to distance matrix (false)\n-w read in PCL-formatted input file (false)\n-W read in Gene Expression Omnibus Series Matrix-formatted input file (false)\n-l[integer] start reading numerical data from this column, lowest column = 0 (1)\n-Q transform columns from input into Euclidean distance matrix (false)\n-Q[2,3] distance matrix metric; 2 = Pearson's, 3 = Uncentered Correlation (Euclidean)\n-h[1,2,3,4] fill missing values; 1=means of rows;2=medians of rows;\n\t\t3=means of columns;4=medians of columns  (means of rows)\n-c[integer] set number of Monte Carlo simulations for MST clustering (10)\n-g[integer] set x of SOM grid xy, where y=x (square root of input size*2)\n-M[integer] set maximum x/y grid of SOM (30)\n-m[integer] set minimum x/y grid of SOM (5)\n-P set SOM distance metric to Pearson Correlation (Euclidean)\n-P2 set SOM distance metric to Uncentered Correlation (Euclidean)\n-s set SOM topology to square (circle)\n-i[integer] set number of SOM iterations (500)\n-x[integer] set SOM error surface exponent (3)\n-r[power of 2] set density-equalizing cartogram resolution (32)\n-E disable Density-Equalizing Cartogram (false)\n-R disable SOM; use only if clustering with K-Means or Agglomerative (false)\n-S invoke Sammon Mapping instead of SOM (false)\n-S[integer] set number of Sammon Mapping iterations (100)\n-k[integer] specify number of clusters in dataset (false)\n-K invoke K-Means Clustering; requires option -k (false)\n-A invoke Agglomerative Clustering; requires option -k (false)\n-A[method] 1=Single, 2=Complete, 3=Average, 4=Ward's (4)\n-V print verbose output (false)\n");
    }

    public String getSettings() {
        StringBuffer sb = new StringBuffer();
        sb.append("CPU threads\t" + this.threads + "\n");
        sb.append("Input File\t" + this.inputFile + "\n");
        sb.append("Input Size\t" + this.inputSize + "\n");
        sb.append("Attributes\t" + this.input[0].getValues().length + "\n");
        if (this.batch) {
            sb.append("Trials per Dataset:\t" + this.trials + "\n");
        }
        sb.append("Ensemble Runs\t" + this.ensemble_runs + "\n");
        if (this.noMapping) {
            sb.append("No Dimensional Reduction / Mapping");
        }
        if (!this.doSM && !this.noMapping) {
            sb.append("SOM iterations\t" + this.som_iters + "\n");
            sb.append("SOM minimum grid\t" + this.som_minGrid + "\n");
            sb.append("SOM maximum grid\t" + this.som_maxGrid + "\n");
            sb.append("SOM actual grid\t" + (this.som_gridSize == 0 ? (int)Math.min((double)this.som_maxGrid, Math.max((double)this.som_minGrid, Math.sqrt(this.inputSize * 2))) : this.som_gridSize) + "\n");
            sb.append("SOM topology\t" + (this.som_circle ? "circle" : "square") + "\n");
            if (this.doCart) {
                sb.append("SOM error dampener (theta)\t" + this.som_theta + "\n");
            }
            if (this.doCart) {
                sb.append("SOM error surface exponent\t" + this.som_DEScale + "\n");
            }
        }
        if (!this.noMapping) {
            if (this.doCart) {
                sb.append("Cartogram resolution\t" + this.de_resolution + "x" + this.de_resolution + "\n");
            }
            if (this.doSM) {
                sb.append("Sammon Mapping iterations\t" + this.sm_iters + "\n");
            }
        }
        if (!this.doKmeans && !this.doHierarchical) {
            sb.append("MST Monte Carlo Simulations\t" + this.mst_MC + "\n");
            sb.append("MST P-value cutoff\t" + this.mst_pval + "\n");
        }
        if (this.benchmark) {
            sb.append("No. Known Clusters\t" + this.known_clusters + "\n");
        }
        if (this.doKmeans) {
            sb.append("Kmeans");
        }
        if (this.doHierarchical) {
            sb.append("Agglomerative Clustering Metric\t" + (this.hierarchical_choice == 1 ? "single" : (this.hierarchical_choice == 2 ? "complete" : (this.hierarchical_choice == 3 ? "average" : "Ward's\n"))));
        }
        if (this.known_clusters > 0) {
            sb.append("User Specified Cluster Number\t" + this.known_clusters + "\n");
        }
        sb.append("Running Time\t" + this.runTime + "\n");
        return sb.toString();
    }

    public void setInputMinMax() {
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int i = 0; i < this.input.length; ++i) {
            for (int j = 0; j < this.input[i].getValues().length; ++j) {
                if (min > this.input[i].getValues()[j]) {
                    min = this.input[i].getValues()[j];
                }
                if (!(max < this.input[i].getValues()[j])) continue;
                max = this.input[i].getValues()[j];
            }
        }
        this.inputMin = min;
        this.inputMax = max;
    }

    public String getName() {
        StringTokenizer st = new StringTokenizer(this.inputFile, "\\");
        String token = new String();
        while (st.hasMoreTokens()) {
            token = st.nextToken();
        }
        String[] tokens = token.split("/");
        token = tokens[tokens.length - 1];
        st = new StringTokenizer(token, ".");
        token = "";
        for (int i = 0; i < st.countTokens(); ++i) {
            token = token.concat((i > 0 ? "." : "") + st.nextToken());
        }
        return token;
    }

    public void setCenter() {
        this.center = new float[this.input[0].getValues().length];
        for (int i = 0; i < this.input.length; ++i) {
            for (int j = 0; j < this.input[i].getValues().length; ++j) {
                if (this.input[i].getValues()[j] == -1.0E9f) continue;
                int n = j;
                this.center[n] = this.center[n] + this.input[i].getValues()[j];
            }
        }
        int k = 0;
        while (k < this.center.length) {
            int n = k++;
            this.center[n] = this.center[n] / (float)this.input.length;
        }
    }

    public void convertDMLabels() {
        HashMap<String, Integer> h = new HashMap<String, Integer>();
        for (int i = 0; i < this.input.length; ++i) {
            if (!h.containsKey(this.input[i].getIdentity())) {
                h.put(this.input[i].getIdentity(), h.size() + 1);
                this.input[i].setIdentity(String.valueOf(h.size()));
                continue;
            }
            this.input[i].setIdentity(((Integer)h.get(this.input[i].getIdentity())).toString());
        }
    }

    public String getFolderDivider() {
        StringTokenizer st = new StringTokenizer(System.getProperty("os.name"));
        String os = st.nextToken();
        if (os.equals("Mac")) {
            return "/";
        }
        return "\\";
    }
}

