/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.launch;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.dataItem;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.launch.Settings;

public class makeDistMatrix {
    float[] distSqr;

    public dataItem[] getDistMatrix(Settings s) {
        int j;
        int i;
        float[][] dist = new float[s.input[0].getValues().length][s.input[0].getValues().length];
        if (s.EWEIGHT != null) {
            for (i = 0; i < s.input[0].getValues().length; ++i) {
                if (s.EWEIGHT[i] == 1.0) continue;
                for (j = 0; j < s.input.length; ++j) {
                    float[] fArray = s.input[j].getValues();
                    int n = i;
                    fArray[n] = (float)((double)fArray[n] * s.EWEIGHT[i]);
                }
            }
        }
        if (s.dmDist == 2) {
            s.setCenter();
        }
        for (i = 0; i < dist.length; ++i) {
            for (j = i; j < dist.length; ++j) {
                float f = s.dmDist == 1 ? this.getEucDist(s.input, i, j) : (s.dmDist == 2 ? this.getPearsonDist(s.input, i, j, s) : this.getUncenteredDist(s.input, i, j));
                dist[j][i] = f;
                dist[i][j] = f;
            }
        }
        s.input = new dataItem[dist.length];
        for (i = 0; i < s.input.length; ++i) {
            String label = String.valueOf(i + 1);
            if (s.columnHeaders != null && s.columnHeaders[i + s.startData] != null) {
                label = s.columnHeaders[i + s.startData].replace(" ", "_");
            }
            s.input[i] = new dataItem(dist[i], label);
        }
        return s.input;
    }

    private float getEucDist(dataItem[] d, int i, int j) {
        float f = 0.0f;
        for (int k = 0; k < d.length; ++k) {
            if (d[k].getValues()[i] == -1.0E9f || d[k].getValues()[j] == -1.0E9f) continue;
            f = (float)((double)f + Math.pow(d[k].getValues()[i] - d[k].getValues()[j], 2.0));
        }
        return (float)Math.sqrt(f);
    }

    private float getPearsonDist(dataItem[] d, int i, int j, Settings s) {
        float dist = 0.0f;
        float distSqr1 = 0.0f;
        float distSqr2 = 0.0f;
        for (int k = 0; k < d.length; ++k) {
            if (d[k].getValues()[i] == -1.0E9f || d[k].getValues()[j] == -1.0E9f) continue;
            dist += (d[k].getValues()[i] - s.center[i]) * (d[k].getValues()[j] - s.center[j]);
            distSqr1 = (float)((double)distSqr1 + Math.pow(d[k].getValues()[i] - s.center[i], 2.0));
            distSqr2 = (float)((double)distSqr2 + Math.pow(d[k].getValues()[j] - s.center[j], 2.0));
        }
        float p = dist / (float)Math.sqrt(distSqr1 * distSqr2);
        if (Float.isNaN(p)) {
            p = 0.0f;
        }
        return p;
    }

    private float getUncenteredDist(dataItem[] d, int i, int j) {
        float dist = 0.0f;
        float distSqr1 = 0.0f;
        float distSqr2 = 0.0f;
        for (int k = 0; k < d.length; ++k) {
            if (d[k].getValues()[i] == -1.0E9f || d[k].getValues()[j] == -1.0E9f) continue;
            dist += d[k].getValues()[i] * d[k].getValues()[j];
            distSqr1 = (float)((double)distSqr1 + Math.pow(d[k].getValues()[i], 2.0));
            distSqr2 = (float)((double)distSqr2 + Math.pow(d[k].getValues()[j], 2.0));
        }
        float p = dist / (float)Math.sqrt(distSqr1 * distSqr2);
        if (Float.isNaN(p)) {
            p = 0.0f;
        }
        return p;
    }

    private float[] getMean(dataItem[] input) {
        float[] mean = new float[input.length];
        for (int i = 0; i < input.length; ++i) {
            for (int j = 0; j < input[i].getValues().length; ++j) {
                int n = i;
                mean[n] = mean[n] + input[i].getValues()[j];
            }
            int n = i;
            mean[n] = mean[n] / (float)input[i].getValues().length;
        }
        return mean;
    }

    private void setDistSqr(Settings s) {
        this.distSqr = new float[s.input[0].getValues().length];
        for (int i = 0; i < s.input.length; ++i) {
            for (int j = 0; j < s.input[i].getValues().length; ++j) {
                if (s.input[i].getValues()[j] == -1.0E9f) continue;
                if (s.dmDist == 2) {
                    int n = j;
                    this.distSqr[n] = (float)((double)this.distSqr[n] + Math.pow(s.input[i].getValues()[j] - s.center[j], 2.0));
                    continue;
                }
                int n = j;
                this.distSqr[n] = (float)((double)this.distSqr[n] + Math.pow(s.input[i].getValues()[j], 2.0));
            }
        }
    }
}

