/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.mapping.cartogram;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.mapping.cartogram.Point;
import java.awt.geom.GeneralPath;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class DEC {
    private String genFileName = "";
    private String dataFileName = "";
    private String polygonFileName = "";
    private int maxNSquareLog = 14;
    private double blurWidth = 0.39;
    private double blurWidthFactor = 1.2;
    private int arrayLength;
    private ArrayList[] polygons;
    private float[] census;
    public static final int DEFAULT_MAXNSQUARELOG = 8;
    public static final double DEFAULT_BLURWIDTH = 0.1;
    public static final double DEFAULT_BLURWIDTHFACTOR = 1.2;
    private static final double CONVERGENCE = 1.0E-100;
    private static final double HINITIAL = 1.0E-4;
    private static final int IMAX = 50;
    private static final int MAXINTSTEPS = 3000;
    private static final double MINH = 1.0E-5;
    private static final int NSUBDIV = 1;
    private static final double PADDING = 2.0;
    private static final double PI = Math.PI;
    private static final double TIMELIMIT = 1.0E8;
    private static final double TOLF = 0.001;
    private static final double TOLINT = 0.001;
    private static final double TOLX = 0.001;
    public static final String DISPLFILE = null;
    GeneralPath[] inputShapes;
    GeneralPath[] outputShapes;
    ArrayFloat[] gridvx;
    ArrayFloat[] gridvy;
    ArrayFloat[] gridvz;
    float maxx;
    float maxy;
    float maxz;
    float minpop;
    float minx;
    float miny;
    float minz;
    float polymaxx;
    float polymaxy;
    float polymaxz;
    float polyminx;
    float polyminy;
    float polyminz;
    ArrayFloat[] rho;
    ArrayFloat[] rho_0;
    ArrayFloat[] vx;
    ArrayFloat[] vy;
    ArrayFloat[] vz;
    ArrayFloat[] x;
    ArrayFloat[] y;
    ArrayFloat[] z;
    ArrayFloat[] xappr;
    ArrayFloat[] yappr;
    ArrayFloat[] zappr;
    float xstepsize;
    float ystepsize;
    float zstepsize;
    int lx;
    int ly;
    int lz;
    int maxid;
    int nblurs = 0;
    int npoly;
    int[] ncorn;
    int[] polygonid;
    ArrayPoint[] corn;
    float[] errors;
    float[][] output;
    StringBuffer ps = new StringBuffer();
    float[] zcensus;
    ArrayList[] zpolygons;
    boolean zaxis = false;
    float[][] xy;
    float[][][] densities;
    int[][] origCoors;
    boolean twoD = false;
    boolean indep = true;
    int xyres;
    int zres;
    int zSpace = 0;
    int zAxisSize = 0;

    private static double erf(double z) {
        double t = 1.0 / (1.0 + 0.5 * Math.abs(z));
        double ans = 1.0 - t * Math.exp(-z * z - 1.26551223 + t * (1.00002368 + t * (0.37409196 + t * (0.09678418 + t * (-0.18628806 + t * (0.27886807 + t * (-1.13520398 + t * (1.48851587 + t * (-0.82215223 + t * 0.17087277)))))))));
        if (z >= 0.0) {
            return ans;
        }
        return -ans;
    }

    private void countcorn() {
        boolean polyctr = false;
        this.npoly = this.polygons.length;
        this.ncorn = new int[this.npoly];
        this.corn = new ArrayPoint[this.npoly];
        if (!this.zaxis) {
            this.xy = new float[this.npoly * 4][2];
        }
        this.polyminz = Float.MAX_VALUE;
        this.polyminy = Float.MAX_VALUE;
        this.polyminx = Float.MAX_VALUE;
        this.polymaxz = Float.MIN_VALUE;
        this.polymaxy = Float.MIN_VALUE;
        this.polymaxx = Float.MIN_VALUE;
        this.ncorn[0] = 1;
        for (int h = 0; h < this.polygons.length; ++h) {
            float[][] poly = (float[][])this.polygons[h].get(0);
            for (int k = 0; k < poly.length; ++k) {
                float x = poly[k][0];
                float y = poly[k][1];
                float z = poly[k][2];
                if (x < this.polyminx) {
                    this.polyminx = x;
                }
                if (x > this.polymaxx) {
                    this.polymaxx = x;
                }
                if (y < this.polyminy) {
                    this.polyminy = y;
                }
                if (y > this.polymaxy) {
                    this.polymaxy = y;
                }
                if (z < this.polyminz) {
                    this.polyminz = z;
                }
                if (!(z > this.polymaxz)) continue;
                this.polymaxz = z;
            }
            this.corn[h] = new ArrayPoint(poly.length);
        }
        this.densities = new float[this.zaxis ? (this.zSpace + 1) * (1 + (int)this.polymaxx) : 1 + (int)this.polymaxx][1 + (int)this.polymaxy][1 + (int)this.polymaxz];
        this.origCoors = new int[this.npoly][3];
        this.polymaxz += 1.0f;
        this.lx = (int)Math.pow(2.0, (int)(0.5 * (double)this.maxNSquareLog));
        this.ly = (int)Math.pow(2.0, (int)(0.5 * (double)this.maxNSquareLog));
        int ratiolog = Math.ceil(Math.log((this.polymaxx - this.polyminx) / (this.polymaxz - this.polyminz)) / Math.log(2.0)) + Math.floor(Math.log((this.polymaxx - this.polyminx) / (this.polymaxz - this.polyminz)) / Math.log(2.0)) > 2.0 * Math.log((this.polymaxx - this.polyminx) / (this.polymaxz - this.polyminz)) / Math.log(2.0) ? (int)Math.floor(Math.log((this.polymaxx - this.polyminx) / (this.polymaxz - this.polyminz)) / Math.log(2.0)) : (int)Math.ceil(Math.log((this.polymaxx - this.polyminx) / (this.polymaxz - this.polyminz)) / Math.log(2.0));
        this.lz = (int)Math.pow(2.0, (int)Math.ceil(0.5 * (double)(this.maxNSquareLog - ratiolog))) / 2;
        if (this.zaxis) {
            this.lx = this.zAxisSize;
            this.lz = this.ly;
        } else {
            this.zAxisSize = Math.max(this.lz, 16);
        }
        if (this.twoD) {
            this.lz = 2;
        }
        if ((this.polymaxx - this.polyminx) / (float)this.lx > (this.polymaxy - this.polyminy) / (float)this.ly) {
            this.maxx = (float)(0.5 * (3.0 * (double)this.polymaxx + -1.0 * (double)this.polyminx));
            this.minx = (float)(0.5 * (-1.0 * (double)this.polymaxx + 3.0 * (double)this.polyminx));
            this.maxy = (float)(0.5 * (double)(this.polymaxy + this.polyminy + (this.maxx - this.minx) * (float)this.ly / (float)this.lx));
            this.miny = (float)(0.5 * (double)(this.polymaxy + this.polyminy - (this.maxx - this.minx) * (float)this.ly / (float)this.lx));
            this.maxz = this.polymaxz;
            this.minz = 0.0f;
        } else {
            this.maxy = (float)(0.5 * (3.0 * (double)this.polymaxy + -1.0 * (double)this.polyminy));
            this.miny = (float)(0.5 * (-1.0 * (double)this.polymaxy + 3.0 * (double)this.polyminy));
            this.maxx = (float)(0.5 * (double)(this.polymaxx + this.polyminx + (this.maxy - this.miny) * (float)this.lx / (float)this.ly));
            this.minx = (float)(0.5 * (double)(this.polymaxx + this.polyminx - (this.maxy - this.miny) * (float)this.lx / (float)this.ly));
            this.maxz = this.polymaxz;
            this.minz = 0.0f;
        }
    }

    private void readcorn() {
        boolean polyctr = false;
        this.countcorn();
        this.polygonid = new int[this.npoly];
        this.xstepsize = (this.maxx - this.minx) / (float)this.lx;
        this.ystepsize = (this.maxy - this.miny) / (float)this.ly;
        this.zstepsize = (this.maxz - this.minz) / (float)this.lz;
        if ((double)Math.abs(this.xstepsize / this.ystepsize - 1.0f) > 0.001) {
            System.err.println("WARNING: Area elements are not square: " + this.xstepsize + " : " + this.ystepsize + "\n");
        }
        int itor = 0;
        int i = 0;
        boolean store = true;
        for (int h = 0; h < this.polygons.length; ++h) {
            this.polygonid[h] = h;
            float[][] poly = (float[][])this.polygons[h].get(0);
            for (int k = 0; k < poly.length; ++k) {
                float xcoord = poly[k][0];
                float ycoord = poly[k][1];
                float zcoord = poly[k][2];
                if (store) {
                    this.origCoors[itor][0] = (int)xcoord;
                    this.origCoors[itor][1] = (int)ycoord;
                    this.origCoors[itor++][2] = (int)zcoord;
                    store = false;
                }
                this.corn[h].array[i].x = (xcoord - this.minx) / this.xstepsize;
                this.corn[h].array[i].y = (ycoord - this.miny) / this.ystepsize;
                this.corn[h].array[i++].z = (zcoord - this.minz) / this.zstepsize;
            }
            i = 0;
            store = true;
        }
        this.polyminx = (this.polyminx - this.minx) / this.xstepsize;
        this.polyminy = (this.polyminy - this.miny) / this.ystepsize;
        this.polymaxx = (this.polymaxx - this.minx) / this.xstepsize;
        this.polymaxy = (this.polymaxy - this.miny) / this.ystepsize;
        this.polymaxz = (this.polymaxz - this.minz) / this.zstepsize;
        this.polyminz = (this.polyminz - this.minz) / this.zstepsize;
    }

    private void digdens() {
        int j;
        int i;
        int k;
        double totVol = 0.0;
        double totpop = 0.0;
        float[] cases = new float[this.census.length];
        for (int f = 0; f < this.census.length; ++f) {
            cases[f] = this.census[f];
            double pop = cases[f];
            if (pop != Double.MAX_VALUE && !Double.isInfinite(pop)) {
                totpop += pop;
                continue;
            }
            totVol -= 1.0;
        }
        double[] volume = new double[this.npoly];
        int polyctr = 0;
        while (polyctr < this.npoly) {
            totVol += 1.0;
            volume[polyctr] = 0.0;
            int n = polyctr++;
            volume[n] = volume[n] + 1.0;
        }
        float[] dens = new float[this.npoly];
        this.errors = new float[this.npoly];
        for (polyctr = 0; polyctr < this.npoly; ++polyctr) {
            dens[polyctr] = (float)((double)cases[this.polygonid[polyctr]] / volume[polyctr]);
            this.densities[this.origCoors[polyctr][0]][this.origCoors[polyctr][1]][this.origCoors[polyctr][2]] = dens[polyctr];
            if (this.zaxis) {
                for (int h = this.origCoors[polyctr][0]; h < this.origCoors[polyctr][0] + this.zSpace; ++h) {
                    this.densities[h][this.origCoors[polyctr][1]][this.origCoors[polyctr][2]] = dens[polyctr];
                }
            }
            this.errors[polyctr] = dens[polyctr];
        }
        float avgdens = (float)(totpop / totVol);
        for (k = 0; k <= this.lz; ++k) {
            for (i = 0; i < this.lx; ++i) {
                for (j = 0; j < this.ly; ++j) {
                    if ((float)i < this.polyminx || (float)i > this.polymaxx || (float)j < this.polyminy || (float)j > this.polymaxy) {
                        float[] fArray = this.rho_0[k].array[i];
                        int n = j;
                        fArray[n] = fArray[n] + avgdens;
                        continue;
                    }
                    float[] fArray = this.rho_0[k].array[i];
                    int n = j;
                    fArray[n] = fArray[n] + this.within2(i, j, k, avgdens);
                    if (this.rho_0[k].array[i][j] != 100.0f && (double)this.rho_0[k].array[i][j] != Double.MAX_VALUE && !Double.isInfinite(this.rho_0[k].array[i][j])) continue;
                    this.rho_0[k].array[i][j] = avgdens;
                }
            }
        }
        for (k = 0; k <= this.lz; ++k) {
            float[] fArray = this.rho_0[k].array[0];
            fArray[0] = fArray[0] + (this.rho_0[k].array[0][this.ly] + this.rho_0[k].array[this.lx][0] + this.rho_0[k].array[this.lx][this.ly]);
            for (i = 1; i < this.lx; ++i) {
                float[] fArray2 = this.rho_0[k].array[i];
                fArray2[0] = fArray2[0] + this.rho_0[k].array[i][this.ly];
            }
            for (j = 1; j < this.ly; ++j) {
                float[] fArray3 = this.rho_0[k].array[0];
                int n = j;
                fArray3[n] = fArray3[n] + this.rho_0[k].array[this.lx][j];
            }
            for (i = 0; i < this.lx; ++i) {
                this.rho_0[k].array[i][this.ly] = this.rho_0[k].array[i][0];
            }
            for (j = 0; j <= this.ly; ++j) {
                this.rho_0[k].array[this.lx][j] = this.rho_0[k].array[0][j];
            }
        }
        this.coscosft(this.rho_0, 1, 1);
        cases = null;
        for (i = 0; i < this.npoly; ++i) {
            this.corn[i].array = null;
            this.corn[i] = null;
        }
        this.corn = null;
        dens = null;
        this.ncorn = null;
        this.polygonid = null;
    }

    private float within2(float x, float y, float z, float avedens) {
        int zPos;
        float X = x;
        float Y = y;
        x *= this.xstepsize;
        y *= this.ystepsize;
        z *= this.zstepsize;
        y += this.miny;
        z += this.minz;
        if (Math.floor(x += this.minx) - (double)x == 0.0 && Math.floor(y) < (double)y) {
            x -= 1.0f;
            y = (float)Math.ceil(y);
        } else if (Math.floor(y) - (double)y == 0.0 && Math.floor(x) < (double)x) {
            y -= 1.0f;
            x = (float)Math.floor(x);
        } else {
            x = (float)Math.floor(x);
            y = (float)Math.ceil(y);
        }
        if (Math.abs(X - this.polyminx) < 1.0f) {
            x = 0.0f;
        }
        if (Math.abs(Y - this.polyminy) < 1.0f) {
            y = 0.0f;
        }
        if (Math.abs(X - this.polymaxx) < 1.0f) {
            x = this.densities.length / (this.zaxis ? this.zSpace + 1 : 1) - 2;
        }
        if (Math.abs(Y - this.polymaxy) < 1.0f) {
            y = this.densities[0].length - 2;
        }
        if ((zPos = (int)Math.floor(z)) >= this.densities[0][0].length) {
            zPos = this.densities[0][0].length - 1;
        }
        return this.densities[(int)x][(int)y][zPos];
    }

    private void four1(float[] data, long nn, int isign) {
        long m;
        long i;
        long n = nn << 1;
        long j = 1L;
        for (i = 1L; i < n; i += 2L) {
            if (j > i) {
                float tmpf = data[(int)j];
                data[(int)j] = data[(int)i];
                data[(int)i] = tmpf;
                tmpf = data[(int)j + 1];
                data[(int)j + 1] = data[(int)i + 1];
                data[(int)i + 1] = tmpf;
            }
            for (m = n >> 1; m >= 2L && j > m; j -= m, m >>= 1) {
            }
            j += m;
        }
        long mmax = 2L;
        while (n > mmax) {
            long istep = mmax << 1;
            double theta = (double)isign * (6.28318530717959 / (double)mmax);
            double wtemp = Math.sin(0.5 * theta);
            double wpr = -2.0 * wtemp * wtemp;
            double wpi = Math.sin(theta);
            double wr = 1.0;
            double wi = 0.0;
            for (m = 1L; m < mmax; m += 2L) {
                for (i = m; i <= n; i += istep) {
                    j = i + mmax;
                    float tempr = (float)(wr * (double)data[(int)j] - wi * (double)data[(int)j + 1]);
                    float tempi = (float)(wr * (double)data[(int)j + 1] + wi * (double)data[(int)j]);
                    data[(int)j] = data[(int)i] - tempr;
                    data[(int)j + 1] = data[(int)i + 1] - tempi;
                    int n2 = (int)i;
                    data[n2] = data[n2] + tempr;
                    int n3 = (int)i + 1;
                    data[n3] = data[n3] + tempi;
                }
                wtemp = wr;
                wr = wtemp * wpr - wi * wpi + wr;
                wi = wi * wpr + wtemp * wpi + wi;
            }
            mmax = istep;
        }
    }

    private void realft(float[] data, long n, int isign) {
        float h1r;
        float c2;
        float c1 = 0.5f;
        double theta = Math.PI / (double)(n >> 1);
        if (isign == 1) {
            c2 = -0.5f;
            this.four1(data, n >> 1, 1);
        } else {
            c2 = 0.5f;
            theta = -theta;
        }
        double wtemp = Math.sin(0.5 * theta);
        double wpr = -2.0 * wtemp * wtemp;
        double wpi = Math.sin(theta);
        double wr = 1.0 + wpr;
        double wi = wpi;
        long np3 = n + 3L;
        for (long i = 2L; i <= n >> 2; ++i) {
            long i1 = i + i - 1L;
            long i2 = 1L + i1;
            long i3 = np3 - i2;
            long i4 = 1L + i3;
            h1r = c1 * (data[(int)i1] + data[(int)i3]);
            float h1i = c1 * (data[(int)i2] - data[(int)i4]);
            float h2r = -c2 * (data[(int)i2] + data[(int)i4]);
            float h2i = c2 * (data[(int)i1] - data[(int)i3]);
            data[(int)i1] = (float)((double)h1r + wr * (double)h2r - wi * (double)h2i);
            data[(int)i2] = (float)((double)h1i + wr * (double)h2i + wi * (double)h2r);
            data[(int)i3] = (float)((double)h1r - wr * (double)h2r + wi * (double)h2i);
            data[(int)i4] = (float)((double)(-h1i) + wr * (double)h2i + wi * (double)h2r);
            wtemp = wr;
            wr = wtemp * wpr - wi * wpi + wr;
            wi = wi * wpr + wtemp * wpi + wi;
        }
        if (isign == 1) {
            h1r = data[1];
            data[1] = h1r + data[2];
            data[2] = h1r - data[2];
        } else {
            h1r = data[1];
            data[1] = c1 * (h1r + data[2]);
            data[2] = c1 * (h1r - data[2]);
            this.four1(data, n >> 1, -1);
        }
    }

    private void cosft(float[] z, int n, int isign) {
        int j;
        double wi = 0.0;
        double wr = 1.0;
        float[] a = new float[n + 2];
        for (j = 1; j <= n + 1; ++j) {
            a[j] = z[j - 1];
        }
        double theta = Math.PI / (double)n;
        double wtemp = Math.sin(0.5 * theta);
        double wpr = -2.0 * wtemp * wtemp;
        double wpi = Math.sin(theta);
        float sum = (float)(0.5 * (double)(a[1] - a[n + 1]));
        a[1] = (float)(0.5 * (double)(a[1] + a[n + 1]));
        int n2 = n + 2;
        for (j = 2; j <= n >> 1; ++j) {
            wtemp = wr;
            wr = wtemp * wpr - wi * wpi + wr;
            wi = wi * wpr + wtemp * wpi + wi;
            float y1 = (float)(0.5 * (double)(a[j] + a[n2 - j]));
            float y2 = a[j] - a[n2 - j];
            a[j] = (float)((double)y1 - wi * (double)y2);
            a[n2 - j] = (float)((double)y1 + wi * (double)y2);
            sum = (float)((double)sum + wr * (double)y2);
        }
        this.realft(a, n, 1);
        a[n + 1] = a[2];
        a[2] = sum;
        for (j = 4; j <= n; j += 2) {
            a[j] = sum += a[j];
        }
        if (isign == 1) {
            for (j = 1; j <= n + 1; ++j) {
                z[j - 1] = a[j];
            }
        } else if (isign == -1) {
            for (j = 1; j <= n + 1; ++j) {
                z[j - 1] = (float)(2.0 * (double)a[j] / (double)n);
            }
        }
        a = null;
    }

    private void sinft(float[] z, int n, int isign) {
        int j;
        double wi = 0.0;
        double wr = 1.0;
        int n2 = n + 2;
        float[] a = new float[n + 1];
        for (j = 1; j <= n; ++j) {
            a[j] = z[j - 1];
        }
        double theta = Math.PI / (double)n;
        double wtemp = Math.sin(0.5 * theta);
        double wpr = -2.0 * wtemp * wtemp;
        double wpi = Math.sin(theta);
        a[1] = 0.0f;
        for (j = 2; j <= (n >> 1) + 1; ++j) {
            wtemp = wr;
            wr = wtemp * wpr - wi * wpi + wr;
            wi = wi * wpr + wtemp * wpi + wi;
            float y1 = (float)(wi * (double)(a[j] + a[n2 - j]));
            float y2 = (float)(0.5 * (double)(a[j] - a[n2 - j]));
            a[j] = y1 + y2;
            a[n2 - j] = y1 - y2;
        }
        this.realft(a, n, 1);
        a[1] = (float)((double)a[1] * 0.5);
        a[2] = 0.0f;
        float sum = 0.0f;
        for (j = 1; j <= n - 1; j += 2) {
            a[j] = a[j + 1];
            a[j + 1] = sum += a[j];
        }
        if (isign == 1) {
            for (j = 1; j <= n; ++j) {
                z[j - 1] = a[j];
            }
        } else if (isign == -1) {
            for (j = 1; j <= n; ++j) {
                z[j - 1] = 2.0f * a[j] / (float)n;
            }
        }
        z[n] = 0.0f;
        a = null;
    }

    private void coscosft(ArrayFloat[] y, int isign1, int isign2) {
        int j;
        int i;
        int k;
        float[] temp = new float[this.lx + 1];
        for (k = 0; k <= this.lz; ++k) {
            for (i = 0; i <= this.lx; ++i) {
                this.cosft(y[k].array[i], this.ly, isign2);
            }
            for (j = 0; j <= this.ly; ++j) {
                for (i = 0; i <= this.lx; ++i) {
                    temp[i] = y[k].array[i][j];
                }
                this.cosft(temp, this.lx, isign1);
                for (i = 0; i <= this.lx; ++i) {
                    y[k].array[i][j] = temp[i];
                }
            }
        }
        for (i = 0; i <= this.lx; ++i) {
            for (j = 0; j <= this.ly; ++j) {
                temp = new float[this.lz + 1];
                for (k = 0; k <= this.lz; ++k) {
                    temp[k] = y[k].array[i][j];
                }
                this.cosft(temp, this.lz, isign1);
                for (k = 0; k <= this.lz; ++k) {
                    y[k].array[i][j] = temp[k];
                }
            }
        }
    }

    private void cossinft(ArrayFloat[] y, int isign1, int isign2) {
        int j;
        int i;
        int k;
        float[] temp = new float[this.lx + 1];
        for (k = 0; k <= this.lz; ++k) {
            for (i = 0; i <= this.lx; ++i) {
                this.sinft(y[k].array[i], this.ly, isign2);
            }
            for (j = 0; j <= this.ly; ++j) {
                for (i = 0; i <= this.lx; ++i) {
                    temp[i] = y[k].array[i][j];
                }
                this.cosft(temp, this.lx, isign1);
                for (i = 0; i <= this.lx; ++i) {
                    y[k].array[i][j] = temp[i];
                }
            }
        }
        for (i = 0; i <= this.lx; ++i) {
            for (j = 0; j <= this.ly; ++j) {
                temp = new float[this.lz + 1];
                for (k = 0; k <= this.lz; ++k) {
                    temp[k] = y[k].array[i][j];
                }
                this.cosft(temp, this.lz, isign1);
                for (k = 0; k <= this.lz; ++k) {
                    y[k].array[i][j] = temp[k];
                }
            }
        }
    }

    private void sincosft(ArrayFloat[] y, int isign1, int isign2) {
        int j;
        int i;
        int k;
        float[] temp = new float[this.lx + 1];
        for (k = 0; k <= this.lz; ++k) {
            for (i = 0; i <= this.lx; ++i) {
                this.cosft(y[k].array[i], this.ly, isign2);
            }
            for (j = 0; j <= this.ly; ++j) {
                for (i = 0; i <= this.lx; ++i) {
                    temp[i] = y[k].array[i][j];
                }
                this.sinft(temp, this.lx, isign1);
                for (i = 0; i <= this.lx; ++i) {
                    y[k].array[i][j] = temp[i];
                }
            }
        }
        for (i = 0; i <= this.lx; ++i) {
            for (j = 0; j <= this.ly; ++j) {
                temp = new float[this.lz + 1];
                for (k = 0; k <= this.lz; ++k) {
                    temp[k] = y[k].array[i][j];
                }
                this.cosft(temp, this.lz, isign1);
                for (k = 0; k <= this.lz; ++k) {
                    y[k].array[i][j] = temp[k];
                }
            }
        }
    }

    private void sinzft(ArrayFloat[] y, int isign1, int isign2) {
        int j;
        int i;
        int k;
        float[] temp = new float[this.lx + 1];
        for (k = 0; k <= this.lz; ++k) {
            for (i = 0; i <= this.lx; ++i) {
                this.cosft(y[k].array[i], this.ly, isign2);
            }
            for (j = 0; j <= this.ly; ++j) {
                for (i = 0; i <= this.lx; ++i) {
                    temp[i] = y[k].array[i][j];
                }
                this.cosft(temp, this.lx, isign1);
                for (i = 0; i <= this.lx; ++i) {
                    y[k].array[i][j] = temp[i];
                }
            }
        }
        for (i = 0; i <= this.lx; ++i) {
            for (j = 0; j <= this.ly; ++j) {
                temp = new float[this.lz + 1];
                for (k = 0; k <= this.lz; ++k) {
                    temp[k] = y[k].array[i][j];
                }
                this.sinft(temp, this.lz, isign1);
                for (k = 0; k <= this.lz; ++k) {
                    y[k].array[i][j] = temp[k];
                }
            }
        }
    }

    private void fourn(D3Tensor data, int[] nn, int ndim, int isign) {
        int idim;
        long ntot = 1L;
        for (idim = 1; idim <= ndim; ++idim) {
            ntot *= (long)nn[idim];
        }
        long nprev = 1L;
        for (idim = ndim; idim >= 1; --idim) {
            long i3;
            long i1;
            long i2;
            long n = nn[idim];
            long nrem = ntot / (n * nprev);
            long ip1 = nprev << 1;
            long ip2 = ip1 * n;
            long ip3 = ip2 * nrem;
            long i2rev = 1L;
            for (i2 = 1L; i2 <= ip2; i2 += ip1) {
                long ibit;
                if (i2 < i2rev) {
                    for (i1 = i2; i1 <= i2 + ip1 - 2L; i1 += 2L) {
                        for (i3 = i1; i3 <= ip3; i3 += ip2) {
                            long i3rev = i2rev + i3 - i2;
                            data.swapElements((int)i3, (int)i3rev);
                            data.swapElements((int)i3 + 1, (int)i3rev + 1);
                        }
                    }
                }
                for (ibit = ip2 >> 1; ibit >= ip1 && i2rev > ibit; i2rev -= ibit, ibit >>= 1) {
                }
                i2rev += ibit;
            }
            long ifp1 = ip1;
            while (ifp1 < ip2) {
                long ifp2 = ifp1 << 1;
                float theta = (float)((double)(2 * isign) * Math.PI / (double)(ifp2 / ip1));
                float wtemp = (float)Math.sin(0.5 * (double)theta);
                float wpr = (float)(-2.0 * (double)wtemp * (double)wtemp);
                float wpi = (float)Math.sin(theta);
                float wr = 1.0f;
                float wi = 0.0f;
                for (i3 = 1L; i3 <= ifp1; i3 += ip1) {
                    for (i1 = i3; i1 <= i3 + ip1 - 2L; i1 += 2L) {
                        for (i2 = i1; i2 <= ip3; i2 += ifp2) {
                            long k1 = i2;
                            long k2 = k1 + ifp1;
                            double tempr = wr * data.getElement((int)k2) - wi * data.getElement((int)k2 + 1);
                            double tempi = wr * data.getElement((int)k2 + 1) + wi * data.getElement((int)k2);
                            data.setElement((int)k2, (float)((double)data.getElement((int)k1) - tempr));
                            data.setElement((int)k2 + 1, (float)((double)data.getElement((int)k1 + 1) - tempi));
                            data.addToElement((int)k1, (float)tempr);
                            data.addToElement((int)k1 + 1, (float)tempi);
                        }
                    }
                    wtemp = wr;
                    wr = wtemp * wpr - wi * wpi + wr;
                    wi = wi * wpr + wtemp * wpi + wi;
                }
                ifp1 = ifp2;
            }
            nprev *= n;
        }
    }

    private void rlft3(D3Tensor data, DMatrix speq, int nn1, int nn2, int nn3, int isign) {
        int i2;
        int j2;
        int i1;
        int[] nn = new int[4];
        if (data.getElementsCount() != nn1 * nn2 * nn3) {
            System.err.println("rlft3: problem with dimensions or contiguity of data array\n");
            System.exit(1);
        }
        float c1 = 0.5f;
        float c2 = -0.5f * (float)isign;
        double theta = (double)(2 * isign) * (Math.PI / (double)nn3);
        double wtemp = (float)Math.sin(0.5 * theta);
        double wpr = -2.0 * wtemp * wtemp;
        double wpi = (float)Math.sin(theta);
        nn[1] = nn1;
        nn[2] = nn2;
        nn[3] = nn3 >> 1;
        if (isign == 1) {
            data.setOffset(0, 0, -1);
            this.fourn(data, nn, 3, isign);
            data.setOffset(0, 0, 1);
            for (i1 = 1; i1 <= nn1; ++i1) {
                j2 = 0;
                for (i2 = 1; i2 <= nn2; ++i2) {
                    speq.setElement(i1, ++j2, data.getElement(i1, i2, 1));
                    speq.setElement(i1, ++j2, data.getElement(i1, i2, 2));
                }
            }
        }
        for (i1 = 1; i1 <= nn1; ++i1) {
            int j1 = i1 != 1 ? nn1 - i1 + 2 : 1;
            double wr = 1.0;
            double wi = 0.0;
            int ii3 = 1;
            int i3 = 1;
            while (i3 <= (nn3 >> 2) + 1) {
                for (i2 = 1; i2 <= nn2; ++i2) {
                    float h2r;
                    float h2i;
                    float h1i;
                    float h1r;
                    if (i3 == 1) {
                        j2 = i2 != 1 ? (nn2 - i2 << 1) + 3 : 1;
                        h1r = c1 * (data.getElement(i1, i2, 1) + speq.getElement(j1, j2));
                        h1i = c1 * (data.getElement(i1, i2, 2) - speq.getElement(j1, j2 + 1));
                        h2i = c2 * (data.getElement(i1, i2, 1) - speq.getElement(j1, j2));
                        h2r = -c2 * (data.getElement(i1, i2, 2) + speq.getElement(j1, j2 + 1));
                        data.setElement(i1, i2, 1, h1r + h2r);
                        data.setElement(i1, i2, 2, h1i + h2i);
                        speq.setElement(j1, j2, h1r - h2r);
                        speq.setElement(j1, j2 + 1, h2i - h1i);
                        continue;
                    }
                    j2 = i2 != 1 ? nn2 - i2 + 2 : 1;
                    int j3 = nn3 + 3 - (i3 << 1);
                    h1r = c1 * (data.getElement(i1, i2, ii3) + data.getElement(j1, j2, j3));
                    h1i = c1 * (data.getElement(i1, i2, ii3 + 1) - data.getElement(j1, j2, j3 + 1));
                    h2i = c2 * (data.getElement(i1, i2, ii3) - data.getElement(j1, j2, j3));
                    h2r = -c2 * (data.getElement(i1, i2, ii3 + 1) + data.getElement(j1, j2, j3 + 1));
                    data.setElement(i1, i2, ii3, (float)((double)h1r + wr * (double)h2r - wi * (double)h2i));
                    data.setElement(i1, i2, ii3 + 1, (float)((double)h1i + wr * (double)h2i + wi * (double)h2r));
                    data.setElement(j1, j2, j3, (float)((double)h1r - wr * (double)h2r + wi * (double)h2i));
                    data.setElement(j1, j2, j3 + 1, (float)((double)(-h1i) + wr * (double)h2i + wi * (double)h2r));
                }
                wtemp = wr;
                wr = wtemp * wpr - wi * wpi + wr;
                wi = wi * wpr + wtemp * wpi + wi;
                ++i3;
                ii3 += 2;
            }
        }
        if (isign == -1) {
            data.setOffset(0, 0, -1);
            this.fourn(data, nn, 3, isign);
            data.setOffset(0, 0, 1);
        }
    }

    private void gaussianblur() {
        int q;
        int p;
        int j;
        int i;
        int k;
        D3Tensor blur = new D3Tensor(1, 1, 1, this.lx, 1, this.ly);
        D3Tensor conv = new D3Tensor(1, 1, 1, this.lx, 1, this.ly);
        D3Tensor pop = new D3Tensor(1, 1, 1, this.lx, 1, this.ly);
        DMatrix speqblur = new DMatrix(1, 1, 1, 2 * this.lx);
        DMatrix speqconv = new DMatrix(1, 1, 1, 2 * this.lx);
        DMatrix speqpop = new DMatrix(1, 1, 1, 2 * this.lx);
        for (k = 0; k <= this.lz; ++k) {
            for (i = 1; i <= this.lx; ++i) {
                for (j = 1; j <= this.ly; ++j) {
                    p = i > this.lx / 2 ? i - 1 - this.lx : i - 1;
                    q = j > this.ly / 2 ? j - 1 - this.ly : j - 1;
                    pop.setElement(1, i, j, this.rho_0[k].array[i - 1][j - 1]);
                    conv.setElement(1, i, j, (float)(0.5 * (DEC.erf(((double)p + 0.5) / (Math.sqrt(2.0) * (this.blurWidth * Math.pow(this.blurWidthFactor, this.nblurs)))) - DEC.erf(((double)p - 0.5) / (Math.sqrt(2.0) * (this.blurWidth * Math.pow(this.blurWidthFactor, this.nblurs))))) * (DEC.erf(((double)q + 0.5) / (Math.sqrt(2.0) * (this.blurWidth * Math.pow(this.blurWidthFactor, this.nblurs)))) - DEC.erf(((double)q - 0.5) / (Math.sqrt(2.0) * (this.blurWidth * Math.pow(this.blurWidthFactor, this.nblurs))))) / (double)(this.lx * this.ly)));
                }
            }
            this.rlft3(pop, speqpop, 1, this.lx, this.ly, 1);
            this.rlft3(conv, speqconv, 1, this.lx, this.ly, 1);
            for (i = 1; i <= this.lx; ++i) {
                for (j = 1; j <= this.ly / 2; ++j) {
                    blur.setElement(1, i, 2 * j - 1, pop.getElement(1, i, 2 * j - 1) * conv.getElement(1, i, 2 * j - 1) - pop.getElement(1, i, 2 * j) * conv.getElement(1, i, 2 * j));
                    blur.setElement(1, i, 2 * j, pop.getElement(1, i, 2 * j) * conv.getElement(1, i, 2 * j - 1) + pop.getElement(1, i, 2 * j - 1) * conv.getElement(1, i, 2 * j));
                }
            }
            for (i = 1; i <= this.lx; ++i) {
                speqblur.setElement(1, 2 * i - 1, speqpop.getElement(1, 2 * i - 1) * speqconv.getElement(1, 2 * i - 1) - speqpop.getElement(1, 2 * i) * speqconv.getElement(1, 2 * i));
                speqblur.setElement(1, 2 * i, speqpop.getElement(1, 2 * i) * speqconv.getElement(1, 2 * i - 1) + speqpop.getElement(1, 2 * i - 1) * speqconv.getElement(1, 2 * i));
            }
            this.rlft3(blur, speqblur, 1, this.lx, this.ly, -1);
            for (i = 1; i <= this.lx; ++i) {
                for (j = 1; j <= this.ly; ++j) {
                    this.rho_0[k].array[i - 1][j - 1] = blur.getElement(1, i, j);
                }
            }
        }
        blur = new D3Tensor(1, 1, 1, this.lz, 1, this.ly);
        conv = new D3Tensor(1, 1, 1, this.lz, 1, this.ly);
        pop = new D3Tensor(1, 1, 1, this.lz, 1, this.ly);
        speqblur = new DMatrix(1, 1, 1, 2 * this.lz);
        speqconv = new DMatrix(1, 1, 1, 2 * this.lz);
        speqpop = new DMatrix(1, 1, 1, 2 * this.lz);
        for (k = 0; k <= this.lx; ++k) {
            for (i = 1; i <= this.lz; ++i) {
                for (j = 1; j <= this.ly; ++j) {
                    p = i > this.lz / 2 ? i - 1 - this.lx : i - 1;
                    q = j > this.ly / 2 ? j - 1 - this.ly : j - 1;
                    pop.setElement(1, i, j, this.rho_0[i - 1].array[k][j - 1]);
                    conv.setElement(1, i, j, (float)(0.5 * (DEC.erf(((double)p + 0.5) / (Math.sqrt(2.0) * (this.blurWidth * Math.pow(this.blurWidthFactor, this.nblurs)))) - DEC.erf(((double)p - 0.5) / (Math.sqrt(2.0) * (this.blurWidth * Math.pow(this.blurWidthFactor, this.nblurs))))) * (DEC.erf(((double)q + 0.5) / (Math.sqrt(2.0) * (this.blurWidth * Math.pow(this.blurWidthFactor, this.nblurs)))) - DEC.erf(((double)q - 0.5) / (Math.sqrt(2.0) * (this.blurWidth * Math.pow(this.blurWidthFactor, this.nblurs))))) / (double)(this.lz * this.ly)));
                }
            }
            this.rlft3(pop, speqpop, 1, this.lz, this.ly, 1);
            this.rlft3(conv, speqconv, 1, this.lz, this.ly, 1);
            for (i = 1; i <= this.lz; ++i) {
                for (j = 1; j <= this.ly / 2; ++j) {
                    blur.setElement(1, i, 2 * j - 1, pop.getElement(1, i, 2 * j - 1) * conv.getElement(1, i, 2 * j - 1) - pop.getElement(1, i, 2 * j) * conv.getElement(1, i, 2 * j));
                    blur.setElement(1, i, 2 * j, pop.getElement(1, i, 2 * j) * conv.getElement(1, i, 2 * j - 1) + pop.getElement(1, i, 2 * j - 1) * conv.getElement(1, i, 2 * j));
                }
            }
            for (i = 1; i <= this.lz; ++i) {
                speqblur.setElement(1, 2 * i - 1, speqpop.getElement(1, 2 * i - 1) * speqconv.getElement(1, 2 * i - 1) - speqpop.getElement(1, 2 * i) * speqconv.getElement(1, 2 * i));
                speqblur.setElement(1, 2 * i, speqpop.getElement(1, 2 * i) * speqconv.getElement(1, 2 * i - 1) + speqpop.getElement(1, 2 * i - 1) * speqconv.getElement(1, 2 * i));
            }
            this.rlft3(blur, speqblur, 1, this.lz, this.ly, -1);
            for (i = 1; i <= this.lz; ++i) {
                for (j = 1; j <= this.ly; ++j) {
                    this.rho_0[i].array[k][j - 1] = blur.getElement(1, i, j);
                }
            }
        }
    }

    private void initcond() {
        int j;
        int i;
        int k;
        this.coscosft(this.rho_0, -1, -1);
        for (k = 0; k < this.lz; ++k) {
            for (i = 0; i < this.lx; ++i) {
                for (j = 0; j < this.ly; ++j) {
                    if (!((double)this.rho_0[k].array[i][j] < -1.0E10)) continue;
                    System.err.println("ERROR: Negative density in DENSITYFILE.");
                    System.exit(1);
                }
            }
        }
        this.gaussianblur();
        this.minpop = this.rho_0[0].array[0][0];
        float maxpop = this.rho_0[0].array[0][0];
        for (k = 0; k < this.lz; ++k) {
            for (i = 0; i < this.lx; ++i) {
                for (j = 0; j < this.ly; ++j) {
                    if (!(this.rho_0[k].array[i][j] < this.minpop)) continue;
                    this.minpop = this.rho_0[k].array[i][j];
                }
            }
        }
        for (k = 0; k < this.lz; ++k) {
            for (i = 0; i < this.lx; ++i) {
                for (j = 0; j < this.ly; ++j) {
                    if (!(this.rho_0[k].array[i][j] > maxpop)) continue;
                    maxpop = this.rho_0[k].array[i][j];
                }
            }
        }
        if (!(0.0f < this.minpop) || (double)this.minpop < 1.0E-8 * (double)maxpop) {
            // empty if block
        }
        this.coscosft(this.rho_0, 1, 1);
    }

    private void calcv(float t) {
        int k;
        int j;
        int i;
        for (i = 0; i <= this.lz; ++i) {
            for (j = 0; j <= this.lx; ++j) {
                for (k = 0; k <= this.ly; ++k) {
                    this.rho[i].array[j][k] = (float)Math.exp(-(Math.PI * (double)j / (double)this.lx * (Math.PI * (double)j / (double)this.lx) + Math.PI * (double)k / (double)this.ly * (Math.PI * (double)k / (double)this.ly) + Math.PI * (double)i / (double)this.lz * (Math.PI * (double)i / (double)this.lz)) * (double)t) * this.rho_0[i].array[j][k];
                }
            }
        }
        for (i = 0; i <= this.lz; ++i) {
            for (j = 0; j <= this.lx; ++j) {
                for (k = 0; k <= this.ly; ++k) {
                    this.gridvx[i].array[j][k] = (float)(-(Math.PI * (double)j / (double)this.lx)) * this.rho[i].array[j][k];
                    this.gridvy[i].array[j][k] = (float)(-(Math.PI * (double)k / (double)this.ly)) * this.rho[i].array[j][k];
                    this.gridvz[i].array[j][k] = (float)(-(Math.PI * (double)i / (double)this.lz)) * this.rho[i].array[j][k];
                }
            }
        }
        this.coscosft(this.rho, -1, -1);
        this.sincosft(this.gridvx, -1, -1);
        this.cossinft(this.gridvy, -1, -1);
        this.sinzft(this.gridvz, -1, -1);
        for (i = 0; i <= this.lz; ++i) {
            for (j = 0; j <= this.lx; ++j) {
                for (k = 0; k <= this.ly; ++k) {
                    this.gridvx[i].array[j][k] = -this.gridvx[i].array[j][k] / this.rho[i].array[j][k];
                    this.gridvy[i].array[j][k] = !this.zaxis ? -this.gridvy[i].array[j][k] / this.rho[i].array[j][k] : 0.0f;
                    this.gridvz[i].array[j][k] = 0.0f;
                }
            }
        }
    }

    private float intpol(ArrayFloat[] arr, float x, float y, float z) {
        int gaussx = (int)x;
        int gaussy = (int)y;
        int gaussz = (int)z;
        float deltax = x - (float)gaussx;
        float deltay = y - (float)gaussy;
        float deltaz = z - (float)gaussz;
        if (gaussx == this.lx && gaussy == this.ly && gaussz == this.lz) {
            return arr[gaussz].array[gaussx][gaussy];
        }
        if (gaussx == this.lx && gaussz == this.lz) {
            return (1.0f - deltay) * arr[gaussz].array[gaussx][gaussy] + deltay * arr[gaussz].array[gaussx][gaussy + 1];
        }
        if (gaussy == this.ly && gaussz == this.lz) {
            return (1.0f - deltax) * arr[gaussz].array[gaussx][gaussy] + deltax * arr[gaussz].array[gaussx + 1][gaussy];
        }
        if (gaussx == this.lx && gaussy == this.ly) {
            return (1.0f - deltaz) * arr[gaussz].array[gaussx][gaussy] + deltaz * arr[gaussz + 1].array[gaussx][gaussy];
        }
        if (gaussx == this.lx) {
            return (1.0f - deltay) * (1.0f - deltaz) * arr[gaussz].array[gaussx][gaussy] + deltay * (1.0f - deltaz) * arr[gaussz].array[gaussx][gaussy + 1] + deltaz * (1.0f - deltay) * arr[gaussz + 1].array[gaussx][gaussy] + deltaz * deltay * arr[gaussz + 1].array[gaussx][gaussy + 1];
        }
        if (gaussy == this.ly) {
            return (1.0f - deltax) * (1.0f - deltaz) * arr[gaussz].array[gaussx][gaussy] + deltax * (1.0f - deltaz) * arr[gaussz].array[gaussx + 1][gaussy] + deltaz * (1.0f - deltax) * arr[gaussz + 1].array[gaussx][gaussy] + deltaz * deltax * arr[gaussz + 1].array[gaussx + 1][gaussy];
        }
        if (gaussz == this.lz) {
            return (1.0f - deltax) * (1.0f - deltay) * arr[gaussz].array[gaussx][gaussy] + deltax * (1.0f - deltay) * arr[gaussz].array[gaussx + 1][gaussy] + deltay * (1.0f - deltax) * arr[gaussz].array[gaussx][gaussy + 1] + deltay * deltax * arr[gaussz].array[gaussx + 1][gaussy + 1];
        }
        return (1.0f - deltax) * (1.0f - deltay) * (1.0f - deltaz) * arr[gaussz].array[gaussx][gaussy] + (1.0f - deltax) * deltay * (1.0f - deltaz) * arr[gaussz].array[gaussx][gaussy + 1] + deltax * (1.0f - deltay) * (1.0f - deltaz) * arr[gaussz].array[gaussx + 1][gaussy] + deltax * deltay * (1.0f - deltaz) * arr[gaussz].array[gaussx + 1][gaussy + 1] + (1.0f - deltax) * (1.0f - deltay) * deltaz * arr[gaussz + 1].array[gaussx][gaussy] + (1.0f - deltax) * deltay * deltaz * arr[gaussz + 1].array[gaussx][gaussy + 1] + deltax * (1.0f - deltay) * deltaz * arr[gaussz + 1].array[gaussx + 1][gaussy] + deltax * deltay * deltaz * arr[gaussz + 1].array[gaussx + 1][gaussy + 1];
    }

    private boolean newt2(float h, float[] retxyAppr, float xguess, float yguess, float zguess, int j, int k, int w) {
        float deltaz = 0.0f;
        float xappr = xguess;
        float yappr = yguess;
        float zappr = zguess;
        for (int i = 1; i <= 50; ++i) {
            if (xappr > (float)(this.lx + 1) || yappr > (float)(this.ly + 1) || zappr > (float)(this.lz + 1)) {
                return false;
            }
            float fx = (float)((double)xappr - 0.5 * (double)h * (double)this.intpol(this.gridvx, xappr, yappr, zappr) - (double)this.x[w].array[j][k] - 0.5 * (double)h * (double)this.vx[w].array[j][k]);
            float fy = (float)((double)yappr - 0.5 * (double)h * (double)this.intpol(this.gridvy, xappr, yappr, zappr) - (double)this.y[w].array[j][k] - 0.5 * (double)h * (double)this.vy[w].array[j][k]);
            float fz = (float)((double)zappr - 0.5 * (double)h * (double)this.intpol(this.gridvz, xappr, yappr, zappr) - (double)this.z[w].array[j][k] - 0.5 * (double)h * (double)this.vz[w].array[j][k]);
            int gaussx = (int)xappr;
            int gaussy = (int)yappr;
            int gaussz = (int)zappr;
            int gaussxplus = gaussx == this.lx ? 0 : gaussx + 1;
            int gaussyplus = gaussy == this.ly ? 0 : gaussy + 1;
            int gausszplus = gaussz == this.lz ? 0 : gaussz + 1;
            float deltax = this.x[w].array[j][k] - (float)gaussx;
            float deltay = this.y[w].array[j][k] - (float)gaussy;
            deltaz = this.z[w].array[j][k] - (float)gaussz;
            float dfxdx = (float)(1.0 - 0.5 * (double)h * (double)((1.0f - deltay) * (this.gridvx[gaussz].array[gaussxplus][gaussy] - this.gridvx[gaussz].array[gaussx][gaussy]) + deltay * (this.gridvx[gaussz].array[gaussxplus][gaussyplus] - this.gridvx[gaussz].array[gaussx][gaussyplus]) + (1.0f - deltaz) * (this.gridvx[gaussz].array[gaussxplus][gaussy] - this.gridvx[gaussz].array[gaussx][gaussy]) + deltaz * (this.gridvx[gausszplus].array[gaussxplus][gaussy] - this.gridvx[gausszplus].array[gaussx][gaussy])));
            float dfxdy = (float)(-0.5 * (double)h * (double)((1.0f - deltax) * (this.gridvx[gaussz].array[gaussx][gaussyplus] - this.gridvx[gaussz].array[gaussx][gaussy]) + deltax * (this.gridvx[gaussz].array[gaussxplus][gaussyplus] - this.gridvx[gaussz].array[gaussxplus][gaussy]) + (1.0f - deltaz) * (this.gridvx[gaussz].array[gaussx][gaussyplus] - this.gridvx[gaussz].array[gaussx][gaussy]) + deltaz * (this.gridvx[gausszplus].array[gaussx][gaussyplus] - this.gridvx[gausszplus].array[gaussxplus][gaussy])));
            float dfxdz = (float)(-0.5 * (double)h * (double)((1.0f - deltax) * (this.gridvx[gausszplus].array[gaussx][gaussy] - this.gridvx[gaussz].array[gaussx][gaussy]) + deltax * (this.gridvx[gausszplus].array[gaussxplus][gaussyplus] - this.gridvx[gausszplus].array[gaussxplus][gaussy]) + (1.0f - deltay) * (this.gridvx[gausszplus].array[gaussx][gaussy] - this.gridvx[gaussz].array[gaussx][gaussy]) + deltay * (this.gridvx[gaussz].array[gaussx][gaussyplus] - this.gridvx[gausszplus].array[gaussx][gaussyplus])));
            float dfydx = (float)(-0.5 * (double)h * (double)((1.0f - deltay) * (this.gridvy[gaussz].array[gaussxplus][gaussy] - this.gridvy[gaussz].array[gaussx][gaussy]) + deltay * (this.gridvy[gaussz].array[gaussxplus][gaussyplus] - this.gridvy[gaussz].array[gaussx][gaussyplus]) + (1.0f - deltaz) * (this.gridvy[gaussz].array[gaussxplus][gaussy] - this.gridvy[gaussz].array[gaussx][gaussy]) + deltaz * (this.gridvy[gausszplus].array[gaussxplus][gaussy] - this.gridvy[gausszplus].array[gaussx][gaussy])));
            float dfydy = (float)(1.0 - 0.5 * (double)h * (double)((1.0f - deltax) * (this.gridvy[gaussz].array[gaussx][gaussyplus] - this.gridvy[gaussz].array[gaussx][gaussy]) + deltax * (this.gridvy[gaussz].array[gaussxplus][gaussyplus] - this.gridvy[gaussz].array[gaussxplus][gaussy]) + (1.0f - deltaz) * (this.gridvy[gaussz].array[gaussx][gaussyplus] - this.gridvy[gaussz].array[gaussx][gaussy]) + deltaz * (this.gridvy[gausszplus].array[gaussx][gaussyplus] - this.gridvy[gausszplus].array[gaussxplus][gaussy])));
            float dfydz = (float)(-0.5 * (double)h * (double)((1.0f - deltax) * (this.gridvy[gausszplus].array[gaussx][gaussy] - this.gridvy[gaussz].array[gaussx][gaussy]) + deltax * (this.gridvy[gausszplus].array[gaussxplus][gaussyplus] - this.gridvy[gausszplus].array[gaussxplus][gaussy]) + (1.0f - deltay) * (this.gridvy[gausszplus].array[gaussx][gaussy] - this.gridvy[gaussz].array[gaussx][gaussy]) + deltay * (this.gridvy[gaussz].array[gaussx][gaussyplus] - this.gridvy[gausszplus].array[gaussx][gaussyplus])));
            float dfzdz = (float)(1.0 - 0.5 * (double)h * (double)((1.0f - deltax) * (this.gridvz[gausszplus].array[gaussx][gaussy] - this.gridvz[gaussz].array[gaussx][gaussy]) + deltax * (this.gridvz[gausszplus].array[gaussxplus][gaussy] - this.gridvz[gaussz].array[gaussxplus][gaussy]) + (1.0f - deltay) * (this.gridvz[gausszplus].array[gaussx][gaussy] - this.gridvz[gaussz].array[gaussx][gaussy]) + deltay * (this.gridvz[gausszplus].array[gaussx][gaussyplus] - this.gridvz[gaussz].array[gaussx][gaussyplus])));
            float dfzdy = (float)(-0.5 * (double)h * (double)((1.0f - deltax) * (this.gridvz[gaussz].array[gaussx][gaussyplus] - this.gridvz[gaussz].array[gaussx][gaussy]) + deltax * (this.gridvz[gaussz].array[gaussxplus][gaussyplus] - this.gridvz[gaussz].array[gaussxplus][gaussy]) + (1.0f - deltaz) * (this.gridvz[gaussz].array[gaussx][gaussyplus] - this.gridvz[gaussz].array[gaussx][gaussy]) + deltaz * (this.gridvz[gausszplus].array[gaussx][gaussyplus] - this.gridvz[gausszplus].array[gaussx][gaussy])));
            float dfzdx = (float)(-0.5 * (double)h * (double)((1.0f - deltay) * (this.gridvz[gaussz].array[gaussxplus][gaussy] - this.gridvz[gaussz].array[gaussx][gaussy]) + deltax * (this.gridvz[gaussz].array[gaussxplus][gaussyplus] - this.gridvz[gaussz].array[gaussx][gaussyplus]) + (1.0f - deltaz) * (this.gridvz[gaussz].array[gaussxplus][gaussy] - this.gridvz[gaussz].array[gaussx][gaussy]) + deltaz * (this.gridvz[gausszplus].array[gaussxplus][gaussy] - this.gridvz[gausszplus].array[gaussx][gaussy])));
            if ((double)(fx * fx + fy * fy + fz * fz) < 0.001) {
                retxyAppr[0] = xappr;
                retxyAppr[1] = yappr;
                retxyAppr[2] = zappr;
                return true;
            }
            float jDeter = dfxdx * dfydy * dfzdz + dfxdy * dfydz * dfzdx + dfxdz * dfydx * dfzdy - dfxdx * dfydz * dfzdy - dfxdy * dfydx * dfzdz - dfxdz * dfydy * dfzdx;
            deltax = -(fx * (dfydy * dfzdz - dfydz * dfzdy) + fy * (dfxdz * dfzdy - dfxdy * dfzdz) + fz * (dfxdy * dfydz - dfxdz * dfydy)) / jDeter;
            deltay = -(fx * (dfydz * dfzdx - dfydx * dfzdz) + fy * (dfxdx * dfzdz - dfxdz * dfzdx) + fz * (dfxdz * dfydx - dfxdx * dfydz)) / jDeter;
            deltaz = -(fx * (dfydx * dfzdy - dfydy * dfzdx) + fy * (dfxdy * dfzdx - dfxdx * dfzdy) + fz * (dfxdx * dfydy - dfxdy * dfydx)) / jDeter;
            if ((double)(deltax * deltax + deltay * deltay + deltaz * deltaz) < 0.001) {
                retxyAppr[0] = xappr;
                retxyAppr[1] = yappr;
                retxyAppr[2] = zappr;
                return true;
            }
            xappr += deltax;
            yappr += deltay;
            zappr += deltaz;
        }
        retxyAppr[0] = xappr;
        retxyAppr[1] = yappr;
        retxyAppr[2] = zappr;
        return false;
    }

    private boolean nonlinvoltra() {
        int k;
        int j;
        int w;
        BufferedWriter displfile = null;
        if (DISPLFILE != null) {
            try {
                displfile = new BufferedWriter(new FileWriter(DISPLFILE));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        float maxchange = 0.0f;
        maxchange = Float.MAX_VALUE;
        do {
            this.initcond();
            ++this.nblurs;
        } while ((double)this.minpop < 0.0);
        float h = 1.0E-4f;
        float t = 0.0f;
        for (w = 0; w <= this.lz; ++w) {
            for (j = 0; j <= this.lx; ++j) {
                for (k = 0; k <= this.ly; ++k) {
                    this.x[w].array[j][k] = j;
                    this.y[w].array[j][k] = k;
                    this.z[w].array[j][k] = w;
                }
            }
        }
        this.calcv(0.0f);
        for (w = 0; w <= this.lz; ++w) {
            for (j = 0; j <= this.lx; ++j) {
                for (k = 0; k <= this.ly; ++k) {
                    this.vx[w].array[j][k] = this.gridvx[w].array[j][k];
                    this.vy[w].array[j][k] = this.gridvy[w].array[j][k];
                    this.vz[w].array[j][k] = this.gridvz[w].array[j][k];
                }
            }
        }
        int i = 1;
        do {
            boolean stepsize_ok = true;
            this.calcv(t + h);
            for (w = 0; w <= this.lz; ++w) {
                block13: for (j = 0; j <= this.lx; ++j) {
                    for (k = 0; k <= this.ly; ++k) {
                        float vxplus = this.intpol(this.gridvx, this.x[w].array[j][k] + h * this.vx[w].array[j][k], this.y[w].array[j][k] + h * this.vy[w].array[j][k], this.z[w].array[j][k] + h * this.vz[w].array[j][k]);
                        float vyplus = this.intpol(this.gridvy, this.x[w].array[j][k] + h * this.vx[w].array[j][k], this.y[w].array[j][k] + h * this.vy[w].array[j][k], this.z[w].array[j][k] + h * this.vz[w].array[j][k]);
                        float vzplus = this.intpol(this.gridvz, this.x[w].array[j][k] + h * this.vx[w].array[j][k], this.y[w].array[j][k] + h * this.vy[w].array[j][k], this.z[w].array[j][k] + h * this.vz[w].array[j][k]);
                        float xguess = (float)((double)this.x[w].array[j][k] + 0.5 * (double)h * (double)(this.vx[w].array[j][k] + vxplus));
                        float yguess = (float)((double)this.y[w].array[j][k] + 0.5 * (double)h * (double)(this.vy[w].array[j][k] + vyplus));
                        float zguess = (float)((double)this.z[w].array[j][k] + 0.5 * (double)h * (double)(this.vz[w].array[j][k] + vzplus));
                        float[] ret = new float[]{this.xappr[w].array[j][k], this.yappr[w].array[j][k], this.zappr[w].array[j][k]};
                        boolean result = this.newt2(h, ret, xguess, yguess, zguess, j, k, w);
                        this.xappr[w].array[j][k] = ret[0];
                        this.yappr[w].array[j][k] = ret[1];
                        this.zappr[w].array[j][k] = ret[2];
                        if (!result) {
                            return false;
                        }
                        if (!((double)((xguess - this.xappr[w].array[j][k]) * (xguess - this.xappr[w].array[j][k]) + (yguess - this.yappr[w].array[j][k]) * (yguess - this.yappr[w].array[j][k]) + (zguess - this.zappr[w].array[j][k]) * (zguess - this.zappr[w].array[j][k])) > 0.001)) continue;
                        if ((double)h < 1.0E-5) {
                            ++this.nblurs;
                            return false;
                        }
                        h /= 10.0f;
                        stepsize_ok = false;
                        continue block13;
                    }
                }
            }
            if (!stepsize_ok) continue;
            t += h;
            maxchange = 0.0f;
            for (w = 0; w <= this.lz; ++w) {
                for (j = 0; j <= this.lx; ++j) {
                    for (k = 0; k <= this.ly; ++k) {
                        if ((this.x[w].array[j][k] - this.xappr[w].array[j][k]) * (this.x[w].array[j][k] - this.xappr[w].array[j][k]) + (this.y[w].array[j][k] - this.yappr[w].array[j][k]) * (this.y[w].array[j][k] - this.yappr[w].array[j][k]) + (this.z[w].array[j][k] - this.zappr[w].array[j][k]) * (this.z[w].array[j][k] - this.zappr[w].array[j][k]) > maxchange) {
                            maxchange = (this.x[w].array[j][k] - this.xappr[w].array[j][k]) * (this.x[w].array[j][k] - this.xappr[w].array[j][k]) + (this.y[w].array[j][k] - this.yappr[w].array[j][k]) * (this.y[w].array[j][k] - this.yappr[w].array[j][k]) + (this.z[w].array[j][k] - this.zappr[w].array[j][k]) * (this.z[w].array[j][k] - this.zappr[w].array[j][k]);
                        }
                        this.x[w].array[j][k] = this.xappr[w].array[j][k];
                        this.y[w].array[j][k] = this.yappr[w].array[j][k];
                        this.z[w].array[j][k] = this.zappr[w].array[j][k];
                        this.vx[w].array[j][k] = this.intpol(this.gridvx, this.xappr[w].array[j][k], this.yappr[w].array[j][k], this.zappr[w].array[j][k]);
                        this.vy[w].array[j][k] = this.intpol(this.gridvy, this.xappr[w].array[j][k], this.yappr[w].array[j][k], this.zappr[w].array[j][k]);
                        this.vz[w].array[j][k] = this.intpol(this.gridvz, this.xappr[w].array[j][k], this.yappr[w].array[j][k], this.zappr[w].array[j][k]);
                    }
                }
            }
            h = (float)((double)h * 1.2);
            ++i;
        } while (i < 3000 && (double)t < 1.0E8 && (double)maxchange > 1.0E-100);
        if ((double)maxchange > 1.0E-100) {
            System.err.println("WARNING: Insufficient convergence within 3000 steps, time 1.0E8");
        }
        if (DISPLFILE != null) {
            try {
                displfile.write("time " + t + "\nminx " + this.minx + "\nmaxx " + this.maxx + "\nminy " + this.miny + "\nmaxy " + this.maxy + "\n");
                displfile.write("sigma " + this.blurWidth * Math.pow(this.blurWidthFactor, this.nblurs - 1) + "\n");
                displfile.write("background 0\nlx\nly\n\n");
                for (j = 0; j <= this.lx; ++j) {
                    for (k = 0; k <= this.ly; ++k) {
                        displfile.write("j " + j + ", k " + k + ", x " + this.x[j].array[k] + ", y " + this.y[j].array[k] + "\n");
                    }
                }
                displfile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    Point transf(Point p) {
        Point a = new Point();
        Point b = new Point();
        Point c = new Point();
        Point d = new Point();
        Point g = new Point();
        Point i = new Point();
        Point j = new Point();
        Point ptr = new Point();
        p.x = (p.x - this.minx) * (float)this.lx / (this.maxx - this.minx);
        p.y = (p.y - this.miny) * (float)this.ly / (this.maxy - this.miny);
        p.z = (p.z - this.minz) * (float)this.lz / (this.maxz - this.minz);
        int gaussx = (int)p.x;
        int gaussy = (int)p.y;
        int gaussz = (int)p.z;
        if (gaussx >= this.lx) {
            gaussx = this.lx - 1;
        }
        if (gaussy >= this.ly) {
            gaussy = this.ly - 1;
        }
        if (gaussz >= this.lz) {
            gaussz = this.lz - 1;
        }
        if (gaussx < 0 || gaussx > this.lx || gaussy < 0 || gaussy > this.ly) {
            return p;
        }
        float deltax = p.x - (float)gaussx;
        float deltay = p.y - (float)gaussy;
        float deltaz = p.z - (float)gaussz;
        a.x = (1.0f - deltax) * this.x[gaussz].array[gaussx][gaussy] + deltax * this.x[gaussz].array[gaussx + 1][gaussy];
        a.y = (1.0f - deltax) * this.y[gaussz].array[gaussx][gaussy] + deltax * this.y[gaussz].array[gaussx + 1][gaussy];
        b.x = (1.0f - deltax) * this.x[gaussz].array[gaussx][gaussy + 1] + deltax * this.x[gaussz].array[gaussx + 1][gaussy + 1];
        b.y = (1.0f - deltax) * this.y[gaussz].array[gaussx][gaussy + 1] + deltax * this.y[gaussz].array[gaussx + 1][gaussy + 1];
        c.x = (1.0f - deltay) * this.x[gaussz].array[gaussx][gaussy] + deltay * this.x[gaussz].array[gaussx][gaussy + 1];
        c.y = (1.0f - deltay) * this.y[gaussz].array[gaussx][gaussy] + deltay * this.y[gaussz].array[gaussx][gaussy + 1];
        c.z = (1.0f - deltay) * this.z[gaussz].array[gaussx][gaussy] + deltay * this.z[gaussz].array[gaussx][gaussy + 1];
        d.x = (1.0f - deltay) * this.x[gaussz].array[gaussx + 1][gaussy] + deltay * this.x[gaussz].array[gaussx + 1][gaussy + 1];
        d.y = (1.0f - deltay) * this.y[gaussz].array[gaussx + 1][gaussy] + deltay * this.y[gaussz].array[gaussx + 1][gaussy + 1];
        g.y = (1.0f - deltay) * this.y[gaussz + 1].array[gaussx][gaussy] + deltay * this.y[gaussz + 1].array[gaussx][gaussy + 1];
        g.z = (1.0f - deltay) * this.z[gaussz + 1].array[gaussx][gaussy] + deltay * this.z[gaussz + 1].array[gaussx][gaussy + 1];
        i.y = (1.0f - deltaz) * this.y[gaussz].array[gaussx][gaussy] + deltaz * this.y[gaussz + 1].array[gaussx][gaussy];
        i.z = (1.0f - deltaz) * this.z[gaussz].array[gaussx][gaussy] + deltaz * this.z[gaussz + 1].array[gaussx][gaussy];
        j.y = (1.0f - deltaz) * this.y[gaussz].array[gaussx][gaussy + 1] + deltaz * this.y[gaussz + 1].array[gaussx][gaussy + 1];
        j.z = (1.0f - deltaz) * this.z[gaussz].array[gaussx][gaussy + 1] + deltaz * this.z[gaussz + 1].array[gaussx][gaussy + 1];
        float den = (b.x - a.x) * (c.y - d.y) + (a.y - b.y) * (c.x - d.x);
        float t = ((c.x - a.x) * (c.y - d.y) + (a.y - c.y) * (c.x - d.x)) / den;
        float u = ((b.x - a.x) * (c.y - a.y) + (a.y - b.y) * (c.x - a.x)) / den;
        float den2 = (j.z - i.z) * (c.y - g.y) + (i.y - j.y) * (c.z - g.z);
        float t2 = ((c.z - i.z) * (c.y - g.y) + (i.y - c.y) * (c.z - g.z)) / den2;
        ptr.x = (1.0f - (a.x + t * (b.x - a.x)) / (float)this.lx) * this.minx + (a.x + t * (b.x - a.x)) / (float)this.lx * this.maxx;
        ptr.y = (1.0f - (a.y + t * (b.y - a.y)) / (float)this.ly) * this.miny + (a.y + t * (b.y - a.y)) / (float)this.ly * this.maxy;
        ptr.z = (1.0f - (i.z + t2 * (j.z - i.z)) / (float)this.lz) * this.minz + (i.z + t2 * (j.z - i.z)) / (float)this.lz * this.maxz;
        return ptr;
    }

    private void cartogram() {
        Point p = new Point();
        this.output = new float[this.npoly * 4][3];
        this.ps = new StringBuffer();
        int itor = 0;
        boolean count = false;
        for (int h = 0; h < this.polygons.length; ++h) {
            float[][] poly = (float[][])this.polygons[h].get(0);
            int k = 0;
            while (k < poly.length) {
                float xcoord = poly[k][0];
                float ycoord = poly[k][1];
                float zcoord = poly[k][2];
                p.x = xcoord;
                p.y = ycoord;
                p.z = zcoord;
                p = this.transf(p);
                if (!this.zaxis) {
                    if (this.twoD) {
                        this.output[itor][0] = p.x;
                        this.output[itor][1] = p.y;
                        this.output[itor][2] = 1.0f;
                    } else {
                        this.xy[itor][0] = p.x;
                        this.xy[itor][1] = p.y;
                    }
                } else {
                    this.output[itor][0] = this.xy[itor][0];
                    this.output[itor][1] = this.xy[itor][1];
                    this.output[itor][2] = p.x;
                }
                ++k;
                ++itor;
            }
        }
    }

    public DEC(ArrayList[] polygons, float[] census, float[] zcensus, ArrayList[] zpolygons, boolean twoD, boolean indep, int xyres, int zres) {
        this.polygons = polygons;
        this.census = census;
        this.zcensus = zcensus;
        this.zpolygons = zpolygons;
        this.twoD = twoD;
        this.indep = indep;
        this.xyres = xyres;
        this.zres = zres;
    }

    public float[][] makeCartogram() {
        this.maxNSquareLog = (int)(Math.log(this.xyres) / Math.log(2.0) / 0.5);
        for (int q = 0; q < (this.indep ? 1 : 2); ++q) {
            boolean n;
            this.readcorn();
            this.gridvz = new ArrayFloat[this.lz + 1];
            this.gridvx = new ArrayFloat[this.lz + 1];
            this.gridvy = new ArrayFloat[this.lz + 1];
            this.rho = new ArrayFloat[this.lz + 1];
            this.rho_0 = new ArrayFloat[this.lz + 1];
            this.vx = new ArrayFloat[this.lz + 1];
            this.vy = new ArrayFloat[this.lz + 1];
            this.vz = new ArrayFloat[this.lz + 1];
            this.x = new ArrayFloat[this.lz + 1];
            this.xappr = new ArrayFloat[this.lz + 1];
            this.y = new ArrayFloat[this.lz + 1];
            this.yappr = new ArrayFloat[this.lz + 1];
            this.z = new ArrayFloat[this.lz + 1];
            this.zappr = new ArrayFloat[this.lz + 1];
            this.arrayLength = this.x.length;
            for (int i = 0; i <= this.lz; ++i) {
                this.gridvx[i] = new ArrayFloat(this.lx + 1, this.ly + 1);
                this.gridvy[i] = new ArrayFloat(this.lx + 1, this.ly + 1);
                this.gridvz[i] = new ArrayFloat(this.lx + 1, this.ly + 1);
                this.rho[i] = new ArrayFloat(this.lx + 1, this.ly + 1);
                this.rho_0[i] = new ArrayFloat(this.lx + 1, this.ly + 1);
                this.vx[i] = new ArrayFloat(this.lx + 1, this.ly + 1);
                this.vy[i] = new ArrayFloat(this.lx + 1, this.ly + 1);
                this.vz[i] = new ArrayFloat(this.lx + 1, this.ly + 1);
                this.x[i] = new ArrayFloat(this.lx + 1, this.ly + 1);
                this.xappr[i] = new ArrayFloat(this.lx + 1, this.ly + 1);
                this.y[i] = new ArrayFloat(this.lx + 1, this.ly + 1);
                this.yappr[i] = new ArrayFloat(this.lx + 1, this.ly + 1);
                this.z[i] = new ArrayFloat(this.lx + 1, this.ly + 1);
                this.zappr[i] = new ArrayFloat(this.lx + 1, this.ly + 1);
            }
            this.digdens();
            while (!(n = this.nonlinvoltra())) {
            }
            this.cartogram();
            if (this.twoD) {
                return this.output;
            }
            this.census = this.zcensus;
            this.polygons = this.zpolygons;
            this.zaxis = true;
            this.maxNSquareLog = (int)(Math.log(this.zres) / Math.log(2.0) / 0.5);
        }
        return this.output;
    }

    public void setBlurWidth(double blurWidth) {
        this.blurWidth = blurWidth;
    }

    public void setBlurWidthFactor(double blurWidthFactor) {
        this.blurWidthFactor = blurWidthFactor;
    }

    public void setGenFileName(String genFileName) {
        this.genFileName = genFileName;
    }

    public void setPolygonFileName(String polygonFileName) {
        this.polygonFileName = polygonFileName;
    }

    public void setDataFileName(String dataFileName) {
        this.dataFileName = dataFileName;
    }

    public void setMaxNSquareLog(int maxNSquareLog) {
        this.maxNSquareLog = maxNSquareLog;
    }

    public double getBlurWidth() {
        return this.blurWidth;
    }

    public double getBlurWidthFactor() {
        return this.blurWidthFactor;
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    public String getGenFileName() {
        return this.genFileName;
    }

    public String getPolygonFileName() {
        return this.polygonFileName;
    }

    public int getMaxNSquareLog() {
        return this.maxNSquareLog;
    }

    public ArrayFloat[] retreiveX() {
        return this.x;
    }

    public ArrayFloat[] retreiveY() {
        return this.y;
    }

    public void putX(ArrayFloat[] x) {
        this.x = x;
    }

    public void putY(ArrayFloat[] y) {
        this.y = y;
    }

    public int getArrayLength() {
        return this.arrayLength;
    }

    public int getLx() {
        return this.lx;
    }

    public int getLy() {
        return this.ly;
    }

    public float getMaxx() {
        return this.maxx;
    }

    public float getMaxy() {
        return this.maxy;
    }

    public float getMinx() {
        return this.minx;
    }

    public float getMiny() {
        return this.miny;
    }

    public void setArrayLength(int arrayLength) {
        this.arrayLength = arrayLength;
    }

    public void setLx(int lx) {
        this.lx = lx;
    }

    public void setLy(int ly) {
        this.ly = ly;
    }

    public void setMaxx(float maxx) {
        this.maxx = maxx;
    }

    public void setMaxy(float maxy) {
        this.maxy = maxy;
    }

    public void setMinx(float minx) {
        this.minx = minx;
    }

    public void setMiny(float miny) {
        this.miny = miny;
    }

    public class DMatrix {
        private int nrl;
        private int ncl;
        private float[][] matrix;

        public DMatrix(int nrl, int nrh, int ncl, int nch) {
            this.matrix = new float[nrh - nrl + 1][nch - ncl + 1];
            this.nrl = nrl;
            this.ncl = ncl;
        }

        public float getElement(int x, int y) {
            return this.matrix[x - this.nrl][y - this.ncl];
        }

        public void setElement(int x, int y, float f) {
            this.matrix[x - this.nrl][y - this.ncl] = f;
        }
    }

    public class D3Tensor {
        private int nrl;
        private int ncl;
        private int ndl;
        int xSize;
        int ySize;
        int zSize;
        int kOffset = 0;
        private float[][][] matrix;

        public D3Tensor(int nrl, int nrh, int ncl, int nch, int ndl, int ndh) {
            this.nrl = nrl;
            this.ncl = ncl;
            this.ndl = ndl;
            this.xSize = nrh - nrl + 1;
            this.ySize = nch - ncl + 1;
            this.zSize = ndh - ndl + 1;
            this.matrix = new float[this.xSize][this.ySize][this.zSize];
        }

        public float getElement(int x, int y, int z) {
            return this.matrix[x - this.nrl][y - this.ncl][z - this.ndl];
        }

        public float getElement(int k) {
            int zPos = (k += this.kOffset) % this.zSize;
            int yPos = k / this.zSize % this.ySize;
            int xPos = k / this.zSize / this.ySize;
            return this.matrix[xPos][yPos][zPos];
        }

        private float getAndSetElement(int k, float x) {
            int zPos = (k += this.kOffset) % this.zSize;
            int yPos = k / this.zSize % this.ySize;
            int xPos = k / this.zSize / this.ySize;
            float f = this.matrix[xPos][yPos][zPos];
            this.matrix[xPos][yPos][zPos] = x;
            return f;
        }

        public void addToElement(int k, float x) {
            int zPos = (k += this.kOffset) % this.zSize;
            int yPos = k / this.zSize % this.ySize;
            int xPos = k / this.zSize / this.ySize;
            float[] fArray = this.matrix[xPos][yPos];
            int n = zPos;
            fArray[n] = fArray[n] + x;
        }

        public void setElement(int k, float f) {
            int zPos = (k += this.kOffset) % this.zSize;
            int yPos = k / this.zSize % this.ySize;
            int xPos = k / this.zSize / this.ySize;
            this.matrix[xPos][yPos][zPos] = f;
        }

        public void setElement(int x, int y, int z, float f) {
            this.matrix[x - this.nrl][y - this.ncl][z - this.ndl] = f;
        }

        public int getElementsCount() {
            return this.xSize * this.ySize * this.zSize;
        }

        public void swapElements(int a, int b) {
            float x = this.getElement(a);
            float y = this.getAndSetElement(b, x);
            this.setElement(a, y);
        }

        public void setOffset(int i, int j, int k) {
            this.kOffset += k + (j + i * this.ySize) * this.zSize;
        }
    }

    public class ArrayPoint {
        public Point[] array = null;

        public ArrayPoint(int i) {
            this.array = new Point[i];
            for (int x = 0; x < i; ++x) {
                this.array[x] = new Point();
            }
        }
    }

    public class ArrayFloat {
        public float[][] array = null;

        public ArrayFloat() {
        }

        public ArrayFloat(int x, int y) {
            this.array = new float[x][y];
        }

        public float[][] getArray() {
            return this.array;
        }

        public void setArray(float[][] array) {
            this.array = array;
        }

        public class ArrayInt {
            public int[] array = null;

            public ArrayInt(int x) {
                this.array = new int[x];
            }
        }
    }
}

