/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.mapping.som;

import java.util.ArrayList;
import java.util.Random;

public class Node {
    private float[] weights;
    public float[] pos = new float[2];
    private ArrayList dataItems = new ArrayList();
    private double error;
    private double[][] directionalError = new double[5][5];
    boolean vis = true;
    boolean hiLight = false;

    public Node(float[] f) {
        this.weights = new float[f.length];
        for (int j = 0; j < this.weights.length; ++j) {
            this.weights[j] = f[j];
        }
    }

    public Node(int length, float[] max, float[] min) {
        this.weights = new float[length];
        Random r = new Random();
        for (int i = 0; i < this.weights.length; ++i) {
            this.weights[i] = min[i] + r.nextFloat() * (max[i] - min[i]);
        }
    }

    public int getSize() {
        return this.weights.length;
    }

    public float getWeight(int i) {
        return this.weights[i];
    }

    public void setWeight(float value, int index) {
        this.weights[index] = value;
    }

    public double getEuclideanDist(Node input) {
        float dist = 0.0f;
        for (int i = 0; i < this.getSize(); ++i) {
            dist = (float)((double)dist + Math.pow(this.getWeight(i) - input.getWeight(i), 2.0));
        }
        return dist;
    }

    public double getCosineDist(Node input) {
        double cosine = 0.0;
        float distA = 0.0f;
        for (int i = 0; i < this.getSize(); ++i) {
            distA = (float)((double)distA + Math.pow(this.getWeight(i), 2.0));
        }
        float distB = 0.0f;
        for (int i = 0; i < input.getSize(); ++i) {
            distB = (float)((double)distB + Math.pow(input.getWeight(i), 2.0));
        }
        float dot = 0.0f;
        for (int i = 0; i < input.getSize(); ++i) {
            dot += this.getWeight(i) * input.getWeight(i);
        }
        cosine = Math.cos(dot / (distA * distB));
        return cosine;
    }

    public double getPearsonDist(Node input) {
        int i;
        float dist = 0.0f;
        float distSqr1 = 0.0f;
        float distSqr2 = 0.0f;
        float meanInput = 0.0f;
        float meanNode = 0.0f;
        for (i = 0; i < this.getSize(); ++i) {
            meanInput += input.getWeight(i);
            meanNode += this.getWeight(i);
        }
        meanInput /= (float)this.getSize();
        meanNode /= (float)this.getSize();
        for (i = 0; i < this.getSize(); ++i) {
            dist += (this.getWeight(i) - meanNode) * (input.getWeight(i) - meanInput);
            distSqr1 = (float)((double)distSqr1 + Math.pow(this.getWeight(i) - meanNode, 2.0));
            distSqr2 = (float)((double)distSqr2 + Math.pow(input.getWeight(i) - meanInput, 2.0));
        }
        return 1.0 - (double)dist / Math.sqrt(distSqr1 * distSqr2);
    }

    public double getUnCenteredDist(Node input) {
        float dist = 0.0f;
        float distSqr1 = 0.0f;
        float distSqr2 = 0.0f;
        for (int i = 0; i < this.getSize(); ++i) {
            dist += this.getWeight(i) * input.getWeight(i);
            distSqr1 = (float)((double)distSqr1 + Math.pow(this.getWeight(i), 2.0));
            distSqr2 = (float)((double)distSqr2 + Math.pow(input.getWeight(i), 2.0));
        }
        return 1.0 - (double)dist / Math.sqrt(distSqr1 * distSqr2);
    }

    public void addDataItem(int d) {
        this.dataItems.add(d);
    }

    public ArrayList getDataItems() {
        return this.dataItems;
    }

    public void setError(double e) {
        this.error = e;
    }

    public double getError() {
        return this.error;
    }

    public void setDirError(double e, int i, int j) {
        this.directionalError[i][j] = e;
    }

    public double getDirError(int i, int j) {
        return this.directionalError[i][j];
    }

    public void normalizeDirError(double norm) {
        for (int i = 0; i < this.directionalError.length; ++i) {
            int j = 0;
            while (j < this.directionalError[i].length) {
                double[] dArray = this.directionalError[i];
                int n = j++;
                dArray[n] = dArray[n] / norm;
            }
        }
    }

    public void setVis(boolean vis) {
        this.vis = vis;
    }

    public boolean getVis() {
        return this.vis;
    }

    public void setHi(boolean hiLight) {
        this.hiLight = hiLight;
    }

    public boolean getHi() {
        return this.hiLight;
    }
}

