/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.mapping.som;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.Point;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.dataItem;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.launch.Settings;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.mapping.som.Node;
import java.util.ArrayList;
import java.util.Random;

public class SOM
implements Runnable {
    private int iterations = 1000;
    private double learnRate = 0.9;
    private double learningRate = 0.0;
    private double lambda = 0.0;
    private double decay = 0.0;
    private int halfWidth = 0;
    private int maxGridSize = 100;
    private int minGridSize = 30;
    private int gridSize = 30;
    private boolean autoGrid = true;
    private boolean circle = true;
    private double theta = 1.5;
    private dataItem[] input;
    private Node[] trainingData;
    private Node[][] map;
    private Settings s;
    private Node center;
    private int nodeNum = 0;

    public SOM(Settings s) {
        this.input = s.input;
        this.s = s;
        this.iterations = s.som_iters;
        this.maxGridSize = s.som_maxGrid;
        this.minGridSize = s.som_minGrid;
        this.gridSize = s.som_gridSize;
        this.autoGrid = this.gridSize <= 0;
        this.circle = s.som_circle;
        this.theta = s.som_theta;
    }

    public void run() {
        this.init();
        this.doTraining();
        this.doMapping();
        this.calcError();
    }

    private void init() {
        int i;
        this.trainingData = new Node[this.input.length];
        if (this.s.Pearson) {
            this.center = new Node(this.input[0].getValues());
        }
        float[] max = new float[this.input[0].getValues().length];
        float[] min = new float[this.input[0].getValues().length];
        for (int j = 0; j < max.length; ++j) {
            max[j] = -3.4028235E38f;
            min[j] = Float.MAX_VALUE;
        }
        for (i = 0; i < this.trainingData.length; ++i) {
            this.trainingData[i] = new Node(this.input[i].getValues());
            for (int k = 0; k < this.trainingData[i].getSize(); ++k) {
                if (this.trainingData[i].getWeight(k) > max[k]) {
                    max[k] = this.trainingData[i].getWeight(k);
                }
                if (!(this.trainingData[i].getWeight(k) < min[k])) continue;
                min[k] = this.trainingData[i].getWeight(k);
            }
        }
        if (this.gridSize == 0) {
            this.gridSize = (int)Math.min((double)this.maxGridSize, Math.max((double)this.minGridSize, Math.sqrt(this.trainingData.length * 2)));
        }
        this.map = new Node[this.gridSize][this.gridSize];
        for (i = 0; i < this.map.length; ++i) {
            for (int j = 0; j < this.map[i].length; ++j) {
                this.map[i][j] = new Node(this.trainingData[0].getSize(), max, min);
                this.map[i][j].pos[0] = i;
                this.map[i][j].pos[1] = j;
                if (!this.s.Pearson) continue;
                for (int q = 0; q < this.center.getSize(); ++q) {
                    this.center.setWeight(this.map[i][j].getWeight(q), q);
                }
            }
        }
        this.halfWidth = this.gridSize;
        this.lambda = (double)this.iterations / Math.log(this.halfWidth);
        this.nodeNum = (int)(this.s.som_circle ? Math.PI * Math.pow(this.map.length / 2, 2.0) : Math.pow(this.map.length, 2.0));
    }

    public void doTraining() {
        Random r = new Random();
        boolean progress = false;
        for (int m = 0; m < 2; ++m) {
            int i;
            for (i = 0; i < this.iterations; ++i) {
                int sample = r.nextInt(this.trainingData.length);
                this.decay = Math.exp((double)(-i) / this.lambda);
                int[] minCoord = this.findBMU(this.trainingData[sample]);
                double radius = this.calcRadius();
                this.learningRate = this.learnRate * this.decay;
                this.updateWeights(this.trainingData[sample], minCoord, radius, i);
            }
            if (m != 0) continue;
            this.learnRate = 0.1;
            this.halfWidth = this.gridSize / 4;
            for (i = 0; i < this.map.length; ++i) {
                for (int j = 0; j < this.map[i].length; ++j) {
                    this.map[i][j].pos[0] = i;
                    this.map[i][j].pos[1] = j;
                }
            }
        }
    }

    private int[] findBMU(Node input) {
        int[] minCoord = new int[2];
        double minDist = Double.MAX_VALUE;
        for (int i = 0; i < this.map.length; ++i) {
            for (int j = 0; j < this.map[i].length; ++j) {
                double dist;
                if (this.checkCircle(i, j)) continue;
                double d = !this.s.Pearson && !this.s.unCentered ? this.map[i][j].getEuclideanDist(input) : (dist = this.s.unCentered ? this.map[i][j].getUnCenteredDist(input) : this.map[i][j].getPearsonDist(input));
                if (!(dist < minDist)) continue;
                minDist = dist;
                minCoord[0] = i;
                minCoord[1] = j;
            }
        }
        return minCoord;
    }

    private boolean checkCircle(int i, int j) {
        if (!this.circle) {
            return false;
        }
        return Math.sqrt(Math.pow(i - this.map.length / 2, 2.0) + Math.pow(j - this.map[0].length / 2, 2.0)) > (double)(this.map.length / 2);
    }

    private double calcRadius() {
        return (double)this.halfWidth * this.decay;
    }

    private void updateWeights(Node input, int[] minCoord, double radius, int iteration) {
        for (int i = 0; i < this.map.length; ++i) {
            for (int j = 0; j < this.map[0].length; ++j) {
                double dist;
                if ((double)Math.abs(i - minCoord[0]) > radius || (double)Math.abs(j - minCoord[1]) > radius || this.checkCircle(i, j) || (dist = Math.sqrt(Math.pow(i - minCoord[0], 2.0) + Math.pow(j - minCoord[1], 2.0))) > radius) continue;
                for (int q = 0; q < this.map[i][j].getSize(); ++q) {
                    float weight = this.map[i][j].getWeight(q);
                    this.map[i][j].setWeight((float)((double)weight + Math.exp(-Math.pow(dist, 2.0) / (2.0 * Math.pow(radius, 2.0))) * this.learningRate * (double)(input.getWeight(q) - weight)), q);
                    if (!this.s.Pearson) continue;
                    this.center.setWeight((this.center.getWeight(q) * (float)this.nodeNum - weight + this.map[i][j].getWeight(q)) / (float)this.nodeNum, q);
                }
                this.map[i][j].pos[0] = (float)((double)this.map[i][j].pos[0] + Math.exp(-Math.pow(dist, 2.0) / (2.0 * Math.pow(radius, 2.0))) * 0.9 * this.decay * (double)(this.map[minCoord[0]][minCoord[1]].pos[0] - this.map[i][j].pos[0]));
                this.map[i][j].pos[1] = (float)((double)this.map[i][j].pos[1] + Math.exp(-Math.pow(dist, 2.0) / (2.0 * Math.pow(radius, 2.0))) * 0.9 * this.decay * (double)(this.map[minCoord[0]][minCoord[1]].pos[1] - this.map[i][j].pos[1]));
            }
        }
    }

    public void doMapping() {
        for (int i = 0; i < this.trainingData.length; ++i) {
            int[] coordinates = this.findBMU(this.trainingData[i]);
            this.map[coordinates[0]][coordinates[1]].addDataItem(i);
            this.input[i].setPoint(new Point(coordinates));
        }
    }

    public void calcError() {
        int j;
        int i;
        double maxDist = 0.0;
        double maxDirError = 0.0;
        ArrayList<Double> allDists = new ArrayList<Double>();
        for (i = 0; i < this.map.length; ++i) {
            for (j = 0; j < this.map[i].length; ++j) {
                if (this.checkCircle(i, j)) continue;
                double dist = 0.0;
                int xIndex = 0;
                int yIndex = 0;
                int counter = 0;
                for (int k = i > 0 ? i - 1 : i; k < (i < this.map.length - 1 ? i + 2 : i + 1); ++k) {
                    for (int w = j > 0 ? j - 1 : j; w < (j < this.map[i].length - 1 ? j + 2 : j + 1); ++w) {
                        if (k == i && w == j || this.checkCircle(k, w)) continue;
                        xIndex = w < j ? 0 : (w == j ? 1 : 2);
                        yIndex = k < i ? 0 : (k == i ? 1 : 2);
                        if (w - 1 == j && k == i) {
                            xIndex = 2;
                        }
                        this.map[i][j].setDirError(this.map[i][j].getEuclideanDist(this.map[k][w]), xIndex, yIndex);
                        dist += this.map[i][j].getDirError(xIndex, yIndex);
                        if (this.map[i][j].getDirError(xIndex, yIndex) > maxDirError) {
                            maxDirError = this.map[i][j].getDirError(xIndex, yIndex);
                        }
                        ++counter;
                    }
                }
                if (counter == 0) continue;
                dist /= (double)counter;
                for (int a = 0; a < 3; ++a) {
                    for (int b = 0; b < 3; ++b) {
                        if (this.map[i][j].getDirError(a, b) != 0.0) continue;
                        this.map[i][j].setDirError(dist, a, b);
                    }
                }
                this.map[i][j].setError(dist);
                if (maxDist < dist) {
                    maxDist = dist;
                }
                allDists.add(dist);
            }
        }
        for (i = 0; i < this.map.length; ++i) {
            for (j = 0; j < this.map[i].length; ++j) {
                double normDist = this.map[i][j].getError() / (maxDist / this.theta);
                this.map[i][j].setError(Math.min(1.0, normDist));
                this.map[i][j].normalizeDirError(maxDirError);
            }
        }
    }

    public Object[] getDEInfo(double XYerrExp) {
        int i;
        int res = 3;
        ArrayList<int[]> ids = new ArrayList<int[]>();
        ArrayList[] polygons = new ArrayList[this.map.length * this.map[0].length * res * res];
        float[] census = new float[polygons.length];
        int count = 0;
        for (i = res * this.map.length - 1; i >= 0; --i) {
            for (int j = 0; j < res * this.map[0].length; ++j) {
                float[][] poly = new float[4][3];
                poly[0][0] = j;
                poly[0][1] = i;
                poly[0][2] = 0.0f;
                poly[1][0] = j + 1;
                poly[1][1] = i;
                poly[1][2] = 0.0f;
                poly[2][0] = j + 1;
                poly[2][1] = i - 1;
                poly[2][2] = 0.0f;
                poly[3][0] = j;
                poly[3][1] = i - 1;
                poly[3][2] = 0.0f;
                polygons[count] = new ArrayList();
                polygons[count++].add(poly);
            }
        }
        count = 0;
        for (i = 0; i < this.map.length; ++i) {
            for (int yItor = 0; yItor < res; ++yItor) {
                for (int j = 0; j < this.map[0].length; ++j) {
                    for (int k = 0; k < res; ++k) {
                        double err = this.map[i][j].getError();
                        census[count++] = (float)(255.0 * Math.pow(err, XYerrExp));
                    }
                }
            }
        }
        int itor = 0;
        for (int i2 = 0; i2 < this.map.length; ++i2) {
            for (int j = 0; j < this.map[0].length; ++j) {
                if (this.map[i2][j].getDataItems().size() > 0) {
                    int[] rgb = new int[]{200, 200, 200};
                    for (int v = 0; v < this.map[i2][j].getDataItems().size(); ++v) {
                        int node = i2 * res * res * this.map.length + j * res;
                        int lowestX = 1;
                        int lowestY = 1;
                        double lowErr = Double.MAX_VALUE;
                        for (int k = 0; k < 3; ++k) {
                            for (int q = 0; q < 3; ++q) {
                                if (!(this.map[i2][j].getDirError(k, q) < lowErr)) continue;
                                lowErr = this.map[i2][j].getDirError(k, q);
                                lowestX = q;
                                lowestY = k;
                            }
                        }
                        node += lowestX;
                        ids.add(new int[]{node += lowestY * (this.map.length * res), Integer.valueOf(this.map[i2][j].getDataItems().get(v).toString())});
                    }
                }
                ++itor;
            }
        }
        Object[] info = new Object[5];
        info[0] = polygons;
        info[1] = census;
        info[2] = ids;
        return info;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public Node[][] getMap() {
        return this.map;
    }
}

