/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.featureVector;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.AbstractAttributeClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.featureVector.FeatureVectorContext;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterViz;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ViewUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;

public class FeatureVectorCluster
extends AbstractAttributeClusterer {
    public static String SHORTNAME = "featurevector";
    public static String NAME = "Create Correlation Network from Node Attributes";
    public static String GROUP_ATTRIBUTE = "__featureVectorGroups";
    static final String interaction = "distance";
    @ContainsTunables
    public FeatureVectorContext context = null;

    public FeatureVectorCluster(FeatureVectorContext context, ClusterManager clusterManager) {
        super(clusterManager);
        this.context = context;
        if (this.network == null) {
            this.network = clusterManager.getNetwork();
        }
        context.setNetwork(this.network);
    }

    public String getShortName() {
        return SHORTNAME;
    }

    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    public ClusterViz getVisualizer() {
        return null;
    }

    public void run(TaskMonitor monitor) {
        this.monitor = monitor;
        monitor.setTitle("Performing " + this.getName());
        List nodeAttributeList = this.context.nodeAttributeList.getSelectedValues();
        if (nodeAttributeList == null || nodeAttributeList.size() == 0) {
            if (monitor != null) {
                monitor.showMessage(TaskMonitor.Level.ERROR, "Error: no attribute list selected");
            }
            return;
        }
        Object[] attributeArray = new String[nodeAttributeList.size()];
        int index = 0;
        for (String attr : nodeAttributeList) {
            attributeArray[index++] = "node." + attr;
        }
        Arrays.sort(attributeArray);
        if (monitor != null) {
            monitor.setProgress(0.0);
            monitor.setStatusMessage("Initializaing");
        }
        Matrix matrix = new Matrix(this.network, (String[])attributeArray, false, this.context.ignoreMissing, this.context.selectedOnly);
        if (monitor != null) {
            monitor.setProgress(0.1);
            monitor.setStatusMessage("Calculating edge distances");
            if (this.canceled) {
                return;
            }
        }
        matrix.setUniformWeights();
        if (this.context.zeroMissing) {
            matrix.setMissingToZero();
        }
        int nNodes = matrix.nRows();
        double maxdistance = Double.MIN_VALUE;
        double mindistance = Double.MAX_VALUE;
        double[][] distanceMatrix = new double[nNodes][nNodes];
        for (int i = 0; i < nNodes; ++i) {
            for (int j = i + 1; j < nNodes; ++j) {
                double distance = ((DistanceMetric)((Object)this.context.metric.getSelectedValue())).getMetric(matrix, matrix, matrix.getWeights(), i, j);
                maxdistance = Math.max(maxdistance, distance);
                mindistance = Math.min(mindistance, distance);
                distanceMatrix[i][j] = distance;
            }
            if (this.canceled) {
                return;
            }
            monitor.setProgress((double)i / ((double)nNodes * 4.0));
        }
        monitor.setStatusMessage("Assigning values to edges");
        ArrayList<CyEdge> edgeList = new ArrayList<CyEdge>();
        double scale = maxdistance - mindistance;
        CyNetwork newNet = null;
        if (this.context.createNewNetwork) {
            newNet = ModelUtils.createChildNetwork(this.clusterManager, this.network, this.network.getNodeList(), null, "--clustered");
        }
        for (int i = 0; i < nNodes; ++i) {
            for (int j = i + 1; j < nNodes; ++j) {
                double distance = (distanceMatrix[i][j] - mindistance) / scale;
                CyNode source = (CyNode)ModelUtils.getNetworkObjectWithName(this.network, matrix.getRowLabel(i), CyNode.class);
                CyNode target = (CyNode)ModelUtils.getNetworkObjectWithName(this.network, matrix.getRowLabel(j), CyNode.class);
                if (this.context.createNewNetwork && distance > this.context.edgeCutoff && this.context.edgeCutoff != 0.0) continue;
                if (this.context.createNewNetwork) {
                    CyEdge edge = newNet.addEdge(source, target, false);
                    ModelUtils.createAndSet(newNet, (CyIdentifiable)edge, this.context.edgeAttribute, distance, Double.class, null);
                    edgeList.add(edge);
                    continue;
                }
                List connectingEdges = this.network.getConnectingEdgeList(source, target, CyEdge.Type.ANY);
                if (connectingEdges == null || connectingEdges.size() == 0) continue;
                CyEdge edge = (CyEdge)connectingEdges.get(0);
                ModelUtils.createAndSet(this.network, (CyIdentifiable)edge, this.context.edgeAttribute, distance, Double.class, null);
            }
            if (this.canceled) {
                return;
            }
            monitor.setProgress(25.0 + 75.0 * (double)i / (double)nNodes / 100.0);
        }
        if (this.context.createNewNetwork) {
            VisualStyle style = ViewUtils.getCurrentVisualStyle(this.clusterManager);
            CyNetworkView view = ViewUtils.createView(this.clusterManager, newNet, false);
            ViewUtils.doLayout(this.clusterManager, view, monitor, "force-directed");
            ViewUtils.setVisualStyle(this.clusterManager, view, style);
            ViewUtils.registerView(this.clusterManager, view);
        }
        monitor.setStatusMessage("Complete");
    }
}

