/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.featureVector;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BaseMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListMultipleSelection;
import org.cytoscape.work.util.ListSingleSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureVectorContext {
    CyNetwork network;
    @Tunable(description="Distance Metric", gravity=2.0)
    public ListSingleSelection<DistanceMetric> metric = new ListSingleSelection((Object[])BaseMatrix.distanceTypes);
    @Tunable(description="Node attributes for cluster", groups={"Array sources"}, tooltip="You must choose at least 2 node columns for an attribute cluster", gravity=50.0)
    public ListMultipleSelection<String> nodeAttributeList = null;
    @Tunable(description="Only use selected nodes/edges for cluster", groups={"Clustering Parameters"}, gravity=60.0)
    public boolean selectedOnly = false;
    @Tunable(description="Ignore nodes/edges with no data", groups={"Clustering Parameters"}, gravity=62.0)
    public boolean ignoreMissing = true;
    @Tunable(description="Edge attribute to use for distance values", groups={"Advanced Parameters"}, params="displayState=collapsed", gravity=70.0)
    public String edgeAttribute = "FeatureDistance";
    @Tunable(description="Set missing data to zero (not common)", groups={"Advanced Parameters"}, gravity=71.0)
    public boolean zeroMissing = false;
    @Tunable(description="Create a new network with results", groups={"Visualization Options"}, gravity=63.0)
    public boolean createNewNetwork = true;
    @Tunable(description="Only create edges if nodes are closer than this", groups={"Visualization Options"}, dependsOn="createNewNetwork=true", gravity=64.0)
    public double edgeCutoff = 0.01;

    public List<String> getParams(Matrix matrix) {
        ArrayList<String> params = new ArrayList<String>();
        params.add("metric=" + ((DistanceMetric)((Object)this.metric.getSelectedValue())).toString());
        if (this.nodeAttributeList.getSelectedValues() != null) {
            params.add("nodeAttributeList=" + this.nodeAttributeList.getSelectedValues().toString());
        }
        params.add("selectedOnly=" + this.selectedOnly);
        params.add("edgeAttribute=" + this.edgeAttribute);
        params.add("ignoreMissing=" + this.ignoreMissing);
        params.add("zeroMissing=" + this.zeroMissing);
        return params;
    }

    public void setNetwork(CyNetwork network) {
        if (this.network != null && this.network.equals(network)) {
            return;
        }
        this.network = network;
        this.nodeAttributeList = ModelUtils.updateNodeAttributeList(network, this.nodeAttributeList);
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public DistanceMetric getDistanceMetric() {
        return (DistanceMetric)((Object)this.metric.getSelectedValue());
    }
}

