/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.fft;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.AbstractKClusterAlgorithm;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.fft.FFTContext;
import java.util.HashMap;
import java.util.Random;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunFFT
extends AbstractKClusterAlgorithm {
    Random random = null;
    FFTContext context;

    public RunFFT(CyNetwork network, String[] weightAttributes, DistanceMetric metric, TaskMonitor monitor, FFTContext context) {
        super(network, weightAttributes, metric, monitor);
        this.context = context;
    }

    @Override
    public int kcluster(int nClusters, int nIterations, Matrix matrix, DistanceMetric metric, int[] clusterID) {
        this.random = null;
        int nelements = matrix.nRows();
        int ifound = 1;
        int[] tclusterid = new int[nelements];
        int[] saved = new int[nelements];
        int[] mapping = new int[nClusters];
        int[] counts = new int[nClusters];
        HashMap<Integer, Integer> centers = new HashMap<Integer, Integer>();
        double error = Double.MAX_VALUE;
        if (this.monitor != null) {
            this.monitor.setProgress(0.0);
        }
        for (int i = 0; i < nelements; ++i) {
            clusterID[i] = 0;
        }
        Random randomGenerator = new Random();
        centers.put(0, randomGenerator.nextInt(nelements));
        for (int i = 1; i < nClusters; ++i) {
            int y = this.getMaxMin(centers, matrix);
            centers.put(i, y);
        }
        int k = centers.get(0);
        for (int i = 0; i < nelements; ++i) {
            if (i == k) {
                clusterID[i] = 0;
                continue;
            }
            double distance = metric.getMetric(matrix, matrix, matrix.getWeights(), i, k);
            clusterID[i] = k;
            for (int j = 1; j < nClusters; ++j) {
                if (i == centers.get(j)) {
                    clusterID[i] = j;
                    continue;
                }
                double tdistance = metric.getMetric(matrix, matrix, matrix.getWeights(), i, centers.get(j));
                if (!(tdistance < distance)) continue;
                distance = tdistance;
                clusterID[i] = j;
            }
        }
        return ifound;
    }

    public int getMaxMin(HashMap<Integer, Integer> centers, Matrix matrix) {
        int y = 0;
        int nelements = matrix.nRows();
        int numC = centers.size();
        int k = centers.get(0);
        double maxD = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < nelements; ++i) {
            if (centers.containsValue(i)) continue;
            double minD = this.metric.getMetric(matrix, matrix, matrix.getWeights(), i, k);
            if (numC > 1) {
                for (int j = 1; j < numC; ++j) {
                    double tminD = this.metric.getMetric(matrix, matrix, matrix.getWeights(), i, centers.get(j));
                    if (!(tminD < minD)) continue;
                    minD = tminD;
                }
            }
            if (!(minD > maxD)) continue;
            maxD = minD;
            y = i;
        }
        return y;
    }

    private int binomial(int n, double p) {
        int y;
        double q = 1.0 - p;
        if ((double)n * p < 30.0) {
            double s = p / q;
            double a = (double)(n + 1) * s;
            double r = Math.exp((double)n * Math.log(q));
            int x = 0;
            double u = this.uniform();
            while (true) {
                if (u < r) {
                    return x;
                }
                u -= r;
                r *= a / (double)(++x) - s;
            }
        }
        double fm = (double)n * p + p;
        int m = (int)fm;
        double p1 = Math.floor(2.195 * Math.sqrt((double)n * p * q) - 4.6 * q) + 0.5;
        double xm = (double)m + 0.5;
        double xl = xm - p1;
        double xr = xm + p1;
        double c = 0.134 + 20.5 / (15.3 + (double)m);
        double a = (fm - xl) / (fm - xl * p);
        double b = (xr - fm) / (xr * q);
        double lambdal = a * (1.0 + 0.5 * a);
        double lambdar = b * (1.0 + 0.5 * b);
        double p2 = p1 * (1.0 + 2.0 * c);
        double p3 = p2 + c / lambdal;
        double p4 = p3 + c / lambdar;
        while (true) {
            double u = this.uniform();
            double v = this.uniform();
            if ((u *= p4) <= p1) {
                return (int)(xm - p1 * v + u);
            }
            if (u > p2) {
                if (u > p3) {
                    y = (int)(xr - Math.log(v) / lambdar);
                    if (y > n) continue;
                    v = v * (u - p3) * lambdar;
                } else {
                    y = (int)(xl + Math.log(v) / lambdal);
                    if (y < 0) continue;
                    v = v * (u - p2) * lambdal;
                }
            } else {
                double x = xl + (u - p1) / c;
                if ((v = v * c + 1.0 - Math.abs((double)m - x + 0.5) / p1) > 1.0) continue;
                y = (int)x;
            }
            int k = Math.abs(y - m);
            if (k > 20 && (double)k < 0.5 * (double)n * p * q - 1.0) {
                double rho = (double)k / ((double)n * p * q) * (((double)k * ((double)k / 3.0 + 0.625) + 0.1666666666666) / ((double)n * p * q) + 0.5);
                double t = (double)(-k * k) / ((double)(2 * n) * p * q);
                double A = Math.log(v);
                if (A < t - rho) {
                    return y;
                }
                if (A > t + rho) continue;
                double x1 = y + 1;
                double f1 = m + 1;
                double z = n + 1 - m;
                double w = n - y + 1;
                double x2 = x1 * x1;
                double f2 = f1 * f1;
                double z2 = z * z;
                double w2 = w * w;
                if (A > xm * Math.log(f1 / x1) + ((double)(n - m) + 0.5) * Math.log(z / w) + (double)(y - m) * Math.log(w * p / (x1 * q)) + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / f2) / f2) / f2) / f2) / f1 / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / z2) / z2) / z2) / z2) / z / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / x2) / x2) / x2) / x2) / x1 / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / w2) / w2) / w2) / w2) / w / 166320.0) continue;
                return y;
            }
            double s = p / q;
            double aa = s * (double)(n + 1);
            double f = 1.0;
            int i = m;
            while (i < y) {
                f *= aa / (double)(++i) - s;
            }
            i = y;
            while (i < m) {
                f /= aa / (double)(++i) - s;
            }
            if (!(v > f)) break;
        }
        return y;
    }

    private double uniform() {
        if (this.random == null) {
            this.random = new Random();
        }
        return this.random.nextDouble();
    }
}

