/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.AttributeList;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BaseMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.KClusterAttributes;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach.types.SplitCost;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.SummaryMethod;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListSingleSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HopachPAMContext {
    @Tunable(description="Distance metric", groups={"Basic HOPACH Tuning"}, gravity=10.0)
    public ListSingleSelection<DistanceMetric> metric = new ListSingleSelection((Object[])BaseMatrix.distanceTypes);
    @Tunable(description="Split cost type", groups={"Basic HOPACH Tuning"}, gravity=11.0)
    public ListSingleSelection<SplitCost> splitCost = new ListSingleSelection((Object[])SplitCost.values());
    @Tunable(description="Value summary method", groups={"Basic HOPACH Tuning"}, gravity=12.0)
    public ListSingleSelection<SummaryMethod> summaryMethod = new ListSingleSelection((Object[])SummaryMethod.values());
    @Tunable(description="Maximum number of spliting level", groups={"Basic HOPACH Tuning"}, gravity=13.0)
    public int maxLevel = 9;
    @Tunable(description="Maximum number of clusters at each level", groups={"Basic HOPACH Tuning"}, gravity=14.0)
    public int K = 9;
    @Tunable(description="Maximum number of subclusters at each level", groups={"Basic HOPACH Tuning"}, gravity=15.0)
    public int L = 9;
    @Tunable(description="Force splitting at initial level", groups={"Basic HOPACH Tuning"}, gravity=16.0)
    public boolean forceInitSplit = false;
    @Tunable(description="Minimum cost reduction for collapse", groups={"Basic HOPACH Tuning"}, gravity=17.0)
    public double minCostReduction = 0.0;
    @ContainsTunables
    public AttributeList attributeList = null;
    @Tunable(description="Use only selected nodes/edges for cluster", groups={"HOPACH Parameters"}, gravity=100.0)
    public boolean selectedOnly = false;
    @Tunable(description="Cluster attributes as well as nodes", groups={"HOPACH Parameters"}, gravity=101.0)
    public boolean clusterAttributes = false;
    @Tunable(description="Create groups from clusters", groups={"Visualization Options"}, gravity=150.0)
    public boolean createGroups = false;
    @Tunable(description="Show HeatMap when complete", groups={"Visualization Options"}, gravity=151.0)
    public boolean showUI = false;
    private CyNetwork network;
    public KClusterAttributes kcontext = new KClusterAttributes();

    public HopachPAMContext() {
        this.kcontext.useSilhouette = false;
    }

    public void setNetwork(CyNetwork network) {
        if (this.network != null && this.network.equals(network)) {
            return;
        }
        this.network = network;
        if (this.attributeList == null) {
            this.attributeList = new AttributeList(network, true);
        } else {
            this.attributeList.setNetwork(network);
        }
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public DistanceMetric getDistanceMetric() {
        return (DistanceMetric)((Object)this.metric.getSelectedValue());
    }

    public List<String> getParams() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("metric=" + ((DistanceMetric)((Object)this.metric.getSelectedValue())).toString());
        params.add("nodeAttributeList=" + this.attributeList.getNodeAttributeList().toString());
        params.add("selectedOnly=" + this.selectedOnly);
        params.add("clusterAttributes=" + this.clusterAttributes);
        params.add("createGroups=" + this.createGroups);
        return params;
    }
}

