/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.AbstractKClusterAlgorithm;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Clusters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach.HopachPAM;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach.HopachPAMContext;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach.types.SplitCost;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.pam.HopachablePAM;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.MeanSummarizer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.MedianSummarizer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.PrimitiveMeanSummarizer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.PrimitiveMedianSummarizer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.PrimitiveSummarizer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.Summarizer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.SummaryMethod;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.TaskMonitor;

public class RunHopachPAM
extends AbstractKClusterAlgorithm {
    SplitCost splitCost;
    SummaryMethod summaryMethod;
    int maxLevel;
    int K;
    int L;
    double minCostReduction;
    boolean forceInitSplit;
    HopachPAMContext context = null;

    public RunHopachPAM(CyNetwork network, String[] weightAttributes, DistanceMetric metric, TaskMonitor monitor, HopachPAMContext context) {
        super(network, weightAttributes, metric, monitor);
        this.context = context;
    }

    void setParameters(SplitCost splitCost, SummaryMethod summaryMethod, int maxLevel, int K, int L, boolean forceInitSplit, double minCostReduction) {
        this.splitCost = splitCost;
        this.summaryMethod = summaryMethod;
        this.maxLevel = maxLevel;
        this.K = K;
        this.L = L;
        this.forceInitSplit = forceInitSplit;
        this.minCostReduction = minCostReduction;
    }

    public int kcluster(int nClusters, int nIterations, Matrix matrix, DistanceMetric metric, int[] clusterId) {
        PrimitiveSummarizer psummarizer;
        Summarizer summarizer;
        this.monitor.setProgress(0.0);
        switch (this.summaryMethod) {
            case MEDIAN: {
                summarizer = new MedianSummarizer();
                psummarizer = new PrimitiveMedianSummarizer();
                break;
            }
            default: {
                summarizer = new MeanSummarizer();
                psummarizer = new PrimitiveMeanSummarizer();
            }
        }
        HopachablePAM partitioner = new HopachablePAM(this.network, matrix, metric);
        partitioner.setParameters(this.K, this.L, this.splitCost, summarizer);
        HopachPAM hopachPam = new HopachPAM(partitioner);
        hopachPam.setParameters(this.maxLevel, this.minCostReduction, this.forceInitSplit, psummarizer);
        Clusters c = hopachPam.run();
        for (int i = 0; i < c.size(); ++i) {
            clusterId[i] = c.getClusterIndex(i);
        }
        return c.getNumberOfClusters();
    }
}

