/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.kmedoid;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.AbstractKClusterAlgorithm;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.kmedoid.KMedoidContext;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.TaskMonitor;

public class RunKMedoidCluster
extends AbstractKClusterAlgorithm {
    KMedoidContext context;

    public RunKMedoidCluster(CyNetwork network, String[] weightAttributes, DistanceMetric metric, TaskMonitor monitor, KMedoidContext context) {
        super(network, weightAttributes, metric, monitor);
        this.context = context;
    }

    public int kcluster(int nClusters, int nIterations, Matrix matrix, DistanceMetric metric, int[] clusterID) {
        if (this.monitor != null) {
            this.monitor.setProgress(0.0);
        }
        int iteration = 0;
        double[][] distances = new double[matrix.nRows()][matrix.nRows()];
        for (int i = 0; i < matrix.nRows(); ++i) {
            for (int j = 0; j < matrix.nRows(); ++j) {
                distances[i][j] = metric.getMetric(matrix, matrix, matrix.getWeights(), i, j);
            }
        }
        int[] centers = this.context.kcluster.initializeNearCenter ? this.chooseCentralElementsAsCenters(matrix.nRows(), nClusters, distances) : this.chooseRandomElementsAsCenters(matrix.nRows(), nClusters);
        int[] oldCenters = null;
        while (this.centersChanged(oldCenters, centers)) {
            oldCenters = centers;
            this.assignPointsToClosestCenter(oldCenters, distances, clusterID);
            centers = this.calculateCenters(nClusters, matrix, metric, clusterID);
            if (iteration++ < nIterations) continue;
            break;
        }
        return 1;
    }

    public void cancel() {
        this.cancelled = true;
    }

    private void assignPointsToClosestCenter(int[] centers, double[][] distances, int[] clusterId) {
        block0: for (int row = 0; row < distances.length; ++row) {
            double minDistance = Double.MAX_VALUE;
            for (int cluster2 = 0; cluster2 < centers.length; ++cluster2) {
                if (centers[cluster2] == row) {
                    clusterId[row] = cluster2;
                    continue block0;
                }
                double distance = distances[row][centers[cluster2]];
                if (!(distance < minDistance)) continue;
                clusterId[row] = cluster2;
                minDistance = distance;
            }
        }
    }

    private int[] calculateCenters(int nClusters, Matrix matrix, DistanceMetric metric, int[] clusterId) {
        int[] newCenters = new int[nClusters];
        for (int cluster2 = 0; cluster2 < nClusters; ++cluster2) {
            newCenters[cluster2] = this.findMedoid(matrix, cluster2, clusterId);
        }
        return newCenters;
    }

    private int findMedoid(Matrix matrix, int cluster2, int[] clusterid) {
        double minDistance = Double.MAX_VALUE;
        int medoid = -1;
        for (int row = 0; row < matrix.nRows(); ++row) {
            double distance;
            if (clusterid[row] != cluster2 || !((distance = this.metric.getMetric(matrix, matrix, matrix.getWeights(), row, cluster2)) < minDistance)) continue;
            medoid = row;
            minDistance = distance;
        }
        return medoid;
    }

    private boolean centersChanged(int[] oldCenters, int[] centers) {
        if (oldCenters == null || centers == null) {
            return true;
        }
        for (int i = 0; i < oldCenters.length; ++i) {
            if (oldCenters[i] == centers[i]) continue;
            return true;
        }
        return false;
    }

    private void outputCenters(int[] centers) {
        System.out.println("Centroid points: ");
        for (int i = 0; i < centers.length; ++i) {
            System.out.println(" " + i + ": " + centers[i]);
        }
    }

    private void outputClusterId(int[] clusterId) {
        System.out.println("Cluster IDs: ");
        for (int i = 0; i < clusterId.length; ++i) {
            System.out.println(" " + i + ": " + clusterId[i]);
        }
    }
}

