/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.pam;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BaseMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Clusters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach.types.KClusterable;
import java.util.HashSet;
import java.util.Iterator;
import org.cytoscape.model.CyNetwork;

public class PAM
implements KClusterable {
    protected BaseMatrix data;
    protected DistanceMetric metric;
    protected DistanceMatrix distances;
    protected int nClusters;
    protected Clusters clusters;
    int[] idx;
    double cost;
    protected double[] nearestDistances;
    double[] nextNearestDistances;
    int[] nearestMedoids;
    int[] nextNearestMedoids;
    HashSet<Integer> medoids;
    HashSet<Integer> nonmedoids;
    Integer[] elements;
    int maxSwaps = 1000;
    private CyNetwork network;

    public PAM(CyNetwork network, BaseMatrix data, DistanceMetric metric) {
        this(data, metric, null, null);
        this.network = network;
    }

    public PAM(BaseMatrix data, DistanceMetric metric, DistanceMatrix distances, int[] idx) {
        this.data = data;
        this.metric = metric;
        if (data == null || data.nRows() == 0) {
            throw new IllegalArgumentException("Data matrix is empty.");
        }
        if (idx == null) {
            int m = data.nRows();
            idx = new int[m];
            for (int i = 0; i < m; ++i) {
                idx[i] = i;
            }
        }
        this.idx = idx;
        this.distances = distances == null ? new DistanceMatrix(data, metric, idx) : distances.subset(idx);
        this.clusters = null;
    }

    public Clusters cluster(int k) {
        int n = this.size();
        if (n == 0) {
            throw new IllegalArgumentException("No data elements are indexed.");
        }
        if (k > n) {
            throw new IllegalArgumentException("Number of clusters must be less than the number of data elements.");
        }
        if (k == n) {
            return new Clusters(k);
        }
        this.nClusters = k;
        this.initialize();
        this.buildPhase();
        this.swapPhase();
        this.clusters = new Clusters(this.nearestMedoids, this.getCost());
        return this.clusters;
    }

    public int size() {
        return this.idx.length;
    }

    private double getCost() {
        double c = 0.0;
        for (int i = 0; i < this.nearestDistances.length; ++i) {
            c += this.nearestDistances[i];
        }
        return c;
    }

    private void initialize() {
        int m = this.size();
        this.nearestDistances = new double[m];
        this.nextNearestDistances = new double[m];
        this.nearestMedoids = new int[m];
        this.nextNearestMedoids = new int[m];
        this.elements = new Integer[m];
        this.medoids = new HashSet();
        this.nonmedoids = new HashSet();
        for (int ii = 0; ii < m; ++ii) {
            this.nextNearestDistances[ii] = Double.POSITIVE_INFINITY;
            this.nearestDistances[ii] = Double.POSITIVE_INFINITY;
            this.nextNearestMedoids[ii] = -1;
            this.nearestMedoids[ii] = -1;
            this.elements[ii] = new Integer(ii);
            this.nonmedoids.add(this.elements[ii]);
        }
    }

    private void buildPhase() {
        int m = this.size();
        double[] totalDistances = new double[m];
        for (int ii = 0; ii < m; ++ii) {
            double d = 0.0;
            for (int jj = 0; jj < m; ++jj) {
                d += this.distances.getValue(ii, jj);
            }
            totalDistances[ii] = d;
        }
        double minDistance = totalDistances[0];
        int minIndex = 0;
        for (int ii = 0; ii < m; ++ii) {
            if (!(totalDistances[ii] < minDistance)) continue;
            minDistance = totalDistances[ii];
            minIndex = ii;
        }
        this.addMedoid(minIndex);
        double[] gains = new double[m];
        for (int kk = 1; kk < this.nClusters; ++kk) {
            for (int ii = 0; ii < m; ++ii) {
                if (this.medoids.contains(this.elements[ii])) {
                    gains[ii] = -1.0;
                    continue;
                }
                double gain = 0.0;
                for (int jj = 0; jj < m; ++jj) {
                    if (jj == ii || this.medoids.contains(this.elements[jj]) || !(this.nearestDistances[jj] > this.distances.getValue(ii, jj))) continue;
                    gain += this.nearestDistances[jj] - this.distances.getValue(ii, jj);
                }
                gains[ii] = gain;
            }
            double maxGain = Double.NEGATIVE_INFINITY;
            int maxIndex = -1;
            for (int ii = 0; ii < m; ++ii) {
                if (!(gains[ii] > maxGain)) continue;
                maxGain = gains[ii];
                maxIndex = ii;
            }
            this.addMedoid(maxIndex);
        }
        if (this.nClusters != this.medoids.size()) {
            throw new RuntimeException("Expected error in BUILD phase: Number of medoids does not match parameter k.");
        }
    }

    private void swapPhase() {
        while (true) {
            double bestChange = 0.0;
            int bestii = -1;
            int besthh = -1;
            for (int ii : this.medoids) {
                for (int hh : this.nonmedoids) {
                    double change = 0.0;
                    Integer[] nonmedIt2 = new Integer[this.nonmedoids.size() + 1];
                    this.nonmedoids.toArray(nonmedIt2);
                    nonmedIt2[nonmedIt2.length - 1] = ii;
                    Integer[] arr$ = nonmedIt2;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        int jj = arr$[i$];
                        double d = this.nearestDistances[jj];
                        if (this.distances.getValue(ii, jj) > d) {
                            if (!(this.distances.getValue(jj, hh) < d)) continue;
                            change += this.distances.getValue(jj, hh) - d;
                            continue;
                        }
                        double e = this.nextNearestDistances[jj];
                        if (this.distances.getValue(jj, hh) < e) {
                            change += this.distances.getValue(jj, hh) - d;
                            continue;
                        }
                        change += e - d;
                    }
                    if (!(change < bestChange)) continue;
                    bestChange = change;
                    bestii = ii;
                    besthh = hh;
                }
            }
            if (bestChange >= 0.0) break;
            this.swap(besthh, bestii);
        }
    }

    private void addMedoid(int add) {
        this.medoids.add(this.elements[add]);
        this.nonmedoids.remove(this.elements[add]);
        this.updateNearest(add, -1);
    }

    private void swap(int add, int remove) {
        this.medoids.add(this.elements[add]);
        this.nonmedoids.remove(this.elements[add]);
        this.medoids.remove(this.elements[remove]);
        this.nonmedoids.add(this.elements[remove]);
        this.updateNearest(add, remove);
    }

    private void updateNearest(int added, int removed) {
        int ii;
        int m = this.size();
        if (removed >= 0) {
            for (ii = 0; ii < m; ++ii) {
                if (this.nearestMedoids[ii] == removed) {
                    this.nearestMedoids[ii] = this.nextNearestMedoids[ii];
                    this.nearestDistances[ii] = this.nextNearestDistances[ii];
                    this.updateNextNearest(ii);
                    continue;
                }
                if (this.nextNearestMedoids[ii] != removed) continue;
                this.updateNextNearest(ii);
            }
        }
        if (added >= 0) {
            for (ii = 0; ii < m; ++ii) {
                double d = this.distances.getValue(ii, added);
                if (d < this.nearestDistances[ii]) {
                    double oldDistance = this.nearestDistances[ii];
                    int oldMedoid = this.nearestMedoids[ii];
                    this.nearestMedoids[ii] = added;
                    this.nearestDistances[ii] = d;
                    this.nextNearestMedoids[ii] = oldMedoid;
                    this.nextNearestDistances[ii] = oldDistance;
                    continue;
                }
                if (!(d < this.nextNearestDistances[ii])) continue;
                this.nextNearestMedoids[ii] = added;
                this.nextNearestDistances[ii] = d;
            }
        }
        Integer[] a = new Integer[this.medoids.size()];
    }

    private void updateNextNearest(int ii) {
        int nearestMedoid = this.nearestMedoids[ii];
        Iterator<Integer> it = this.medoids.iterator();
        double minDistance = Double.POSITIVE_INFINITY;
        int nextNearestMedoid = -1;
        while (it.hasNext()) {
            int jj = it.next();
            if (jj == nearestMedoid || !(this.distances.getValue(ii, jj) < minDistance)) continue;
            minDistance = this.distances.getValue(ii, jj);
            nextNearestMedoid = jj;
        }
        this.nextNearestDistances[ii] = minDistance;
        this.nextNearestMedoids[ii] = nextNearestMedoid;
    }
}

