/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.pam;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.AbstractAttributeClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.pam.PAMContext;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.pam.RunPAM;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterViz;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.KnnView;
import java.util.Collections;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class PAMClusterer
extends AbstractAttributeClusterer {
    public static String SHORTNAME = "pam";
    public static String NAME = "Partition Around Medoids (PAM) cluster";
    @Tunable(description="Network to cluster", context="nogui")
    public CyNetwork network = null;
    @ContainsTunables
    public PAMContext context = null;

    public PAMClusterer(PAMContext context, ClusterManager clusterManager) {
        super(clusterManager);
        this.context = context;
        if (this.network == null) {
            this.network = clusterManager.getNetwork();
        }
        context.setNetwork(this.network);
    }

    @ProvidesTitle
    public String getShortName() {
        return SHORTNAME;
    }

    public String getName() {
        return NAME;
    }

    public ClusterViz getVisualizer() {
        return new KnnView(this.clusterManager);
    }

    public void run(TaskMonitor monitor) {
        Integer[] rowOrder;
        String[] attributeArray;
        this.monitor = monitor;
        monitor.setTitle("Performing " + this.getName());
        List<String> nodeAttributeList = this.context.attributeList.getNodeAttributeList();
        String edgeAttribute = this.context.attributeList.getEdgeAttribute();
        if (nodeAttributeList == null && edgeAttribute == null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Must select either one edge column or two or more node columns");
            return;
        }
        if (nodeAttributeList != null && nodeAttributeList.size() > 0 && edgeAttribute != null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Can't have both node and edge columns selected");
            return;
        }
        if (nodeAttributeList != null && nodeAttributeList.size() < 2) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Must have at least two node columns for cluster weighting");
            return;
        }
        if (this.context.selectedOnly && CyTableUtil.getNodesInState((CyNetwork)this.network, (String)"selected", (boolean)true).size() < 3) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Must have at least three nodes to cluster");
            return;
        }
        this.createGroups = this.context.createGroups;
        Collections.sort(nodeAttributeList);
        if (nodeAttributeList != null && nodeAttributeList.size() > 1) {
            attributeArray = new String[nodeAttributeList.size()];
            int i = 0;
            for (String attr : nodeAttributeList) {
                attributeArray[i++] = "node." + attr;
            }
        } else {
            attributeArray = new String[]{"edge." + edgeAttribute};
        }
        monitor.setStatusMessage("Performing PAM cluster with k = " + this.context.kcluster.kNumber + " using " + (Object)((Object)this.distanceMetric) + " and attributes: " + attributeArray);
        monitor.setStatusMessage("Initializing");
        this.resetAttributes(this.network, SHORTNAME);
        RunPAM algo = new RunPAM(this.network, attributeArray, this.distanceMetric, monitor, this.context);
        String resultsString = "PAM results:";
        int nIterations = 0;
        if (this.context.clusterAttributes && attributeArray.length > 1) {
            monitor.setStatusMessage("Clustering attributes");
            rowOrder = algo.cluster(this.clusterManager, this.context.kcluster.kNumber, nIterations, true, this.getShortName(), this.context.kcluster, false);
            this.updateAttributes(this.network, SHORTNAME, rowOrder, attributeArray, algo.getAttributeList(), algo.getMatrix());
        }
        monitor.setStatusMessage("Clustering nodes");
        rowOrder = algo.cluster(this.clusterManager, this.context.kcluster.kNumber, nIterations, false, this.getShortName(), this.context.kcluster, this.createGroups);
        this.updateAttributes(this.network, SHORTNAME, rowOrder, attributeArray, algo.getAttributeList(), algo.getMatrix());
        if (this.context.showUI) {
            this.insertTasksAfterCurrentTask(new Task[]{new KnnView(this.clusterManager)});
        }
    }
}

