/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.pam;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BaseMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Clusters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.pam.PAM;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class PAMTest {
    @Test
    public void testSingletonCluster() {
        Double[] data = new Double[]{0.9, 0.9};
        int k = 1;
        int[] ans = new int[]{0};
        BaseMatrix mat = new BaseMatrix(0, 2, data);
        PAM pam = new PAM(null, mat, DistanceMetric.CITYBLOCK);
        Clusters c = pam.cluster(k);
        Assert.assertEquals((long)c.getNumberOfClusters(), (long)k);
    }

    @Test
    public void testCluster() {
        int i;
        System.out.println("testCluster begin");
        Double[] data = new Double[]{0.9, 0.9, 0.8, 0.8, 0.4, 0.4, 0.5, 0.5, 0.1, 0.1};
        int k = 3;
        int[] ans = new int[]{0, 0, 1, 1, 2};
        BaseMatrix mat = new BaseMatrix(0, 2, data);
        PAM pam = new PAM(null, mat, DistanceMetric.CITYBLOCK);
        Clusters c = pam.cluster(k);
        System.out.println("testCluster end");
        Assert.assertEquals((long)c.getNumberOfClusters(), (long)k);
        for (i = 0; i < c.size(); ++i) {
            System.out.println("c[" + i + "] = " + c.getClusterIndex(i));
        }
        for (i = 0; i < c.size(); ++i) {
            Assert.assertEquals((long)c.getClusterIndex(i), (long)ans[i]);
        }
    }

    @Test
    public void testLarge() {
        System.out.println("testLarge begin");
        int k = 8;
        int[] ans = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
        BufferedReader reader = new BufferedReader(new InputStreamReader(PAMTest.class.getResourceAsStream("/pam_data.txt")));
        ArrayList<Double> vectors = new ArrayList<Double>();
        int vectorWidth = 0;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] vector = line.split("\t");
                vectorWidth = vector.length;
                for (String v : vector) {
                    vectors.add(Double.parseDouble(v));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Double[] data = new Double[vectors.size()];
        data = vectors.toArray(data);
        BaseMatrix mat = new BaseMatrix(0, vectorWidth, data);
        PAM pam = new PAM(null, mat, DistanceMetric.EUCLIDEAN);
        Clusters c = pam.cluster(k);
        System.out.println("testLarge end");
        Assert.assertEquals((long)c.getNumberOfClusters(), (long)k);
        for (int i = 0; i < c.size(); ++i) {
            Assert.assertEquals((long)c.getClusterIndex(i), (long)ans[i]);
        }
    }
}

