/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.silhouette;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Clusters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMatrix;

public class DistanceCalculator {
    public static double[][] segregations(DistanceMatrix distances, Clusters clusters) {
        int m = distances.size();
        int k = clusters.getNumberOfClusters();
        double[][] S = new double[m][k];
        int[] sizes = clusters.getSizes();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < m; ++j) {
                double[] dArray = S[i];
                int n = clusters.getClusterIndex(j);
                dArray[n] = dArray[n] + distances.getValue(i, j);
            }
            for (int jj = 0; jj < k; ++jj) {
                if (sizes[jj] > 1) {
                    double[] dArray = S[i];
                    int n = jj;
                    dArray[n] = dArray[n] / (double)sizes[jj];
                    continue;
                }
                if (sizes[jj] != 0) continue;
                S[i][jj] = Double.POSITIVE_INFINITY;
            }
            int c = clusters.getClusterIndex(i);
            int size = sizes[c];
            if (size <= 1) continue;
            double[] dArray = S[i];
            int n = c;
            dArray[n] = dArray[n] * (double)(size / (size - 1));
        }
        return S;
    }

    public static double[][] separations(DistanceMatrix distances, Clusters clusters) {
        int k = clusters.getNumberOfClusters();
        double[][] S = new double[k][k];
        if (k == 1) {
            S[0][0] = 0.0;
            return S;
        }
        int[][] partitions = clusters.getPartitions();
        for (int i = 0; i < k; ++i) {
            for (int j = i + 1; j < k; ++j) {
                double d = 0.0;
                int n = 0;
                for (int c1 = 0; c1 < partitions[i].length; ++c1) {
                    for (int c2 = 0; c2 < partitions[j].length; ++c2) {
                        d += distances.getValue(partitions[i][c1], partitions[j][c2]);
                        ++n;
                    }
                }
                double d2 = d / (double)n;
                S[j][i] = d2;
                S[i][j] = d2;
            }
        }
        return S;
    }

    public static double[][] separations(DistanceMatrix distances, int[] medoids) {
        int k = medoids.length;
        double[][] S = new double[k][k];
        if (k == 1) {
            S[0][0] = 0.0;
            return S;
        }
        for (int i = 0; i < k; ++i) {
            for (int j = i + 1; j < k; ++j) {
                double d = distances.getValue(medoids[i], medoids[j]);
                S[j][i] = d;
                S[i][j] = d;
            }
        }
        return S;
    }
}

