/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.silhouette;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Clusters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach.types.Segregatable;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach.types.Subsegregatable;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.silhouette.SilhouetteCalculator;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.silhouette.Silhouettes;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.MeanSummarizer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.MedianSummarizer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.Summarizer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSplitSilhouetteCalculator {
    public static Clusters segregateByAverageSilhouette(Segregatable seg, int K, Summarizer summarizer) {
        Clusters split = null;
        int m = seg.size();
        if (K > m - 1) {
            K = m - 1;
        }
        double avgSil = Double.NEGATIVE_INFINITY;
        for (int k = 2; k <= K; ++k) {
            Clusters clusters = seg.cluster(k);
            Silhouettes sils = SilhouetteCalculator.silhouettes(seg.segregations(clusters), clusters);
            double t = sils.getAverage(summarizer);
            if (!(t > avgSil)) continue;
            avgSil = t;
            split = clusters;
        }
        if (split != null) {
            split.setCost(1.0 - avgSil);
        }
        return split;
    }

    public static Clusters segregateByMeanSilhouette(Segregatable seg, int K) {
        return MSplitSilhouetteCalculator.segregateByAverageSilhouette(seg, K, new MeanSummarizer());
    }

    public static Clusters segregateByMedianSilhouette(Segregatable seg, int K) {
        return MSplitSilhouetteCalculator.segregateByAverageSilhouette(seg, K, new MedianSummarizer());
    }

    public static ArrayList<Double> averageSilhouettes(Subsegregatable sseg, Clusters clusters, int L, Summarizer summarizer) {
        int K = clusters.getNumberOfClusters();
        ArrayList<Double> splitSilhouettes = new ArrayList<Double>();
        int[][] partitions = clusters.getPartitions();
        for (int kk = 0; kk < K; ++kk) {
            Clusters subclusters = MSplitSilhouetteCalculator.segregateByAverageSilhouette(sseg.subset(partitions[kk]), L, summarizer);
            if (subclusters == null) continue;
            splitSilhouettes.add(1.0 - subclusters.getCost());
        }
        return splitSilhouettes;
    }

    public static ArrayList<Double> meanSilhouettes(Subsegregatable sseg, Clusters clusters, int L) {
        return MSplitSilhouetteCalculator.averageSilhouettes(sseg, clusters, L, new MeanSummarizer());
    }

    public static ArrayList<Double> medianSilhouettes(Subsegregatable sseg, Clusters clusters, int L) {
        return MSplitSilhouetteCalculator.averageSilhouettes(sseg, clusters, L, new MedianSummarizer());
    }

    public static double averageSplitSilhouette(Subsegregatable sseg, Clusters clusters, int L, Summarizer summarizer) {
        ArrayList<Double> splitSilhouettes = MSplitSilhouetteCalculator.averageSilhouettes(sseg, clusters, L, summarizer);
        if (splitSilhouettes.size() == 0) {
            return Double.POSITIVE_INFINITY;
        }
        return summarizer.summarize(splitSilhouettes.toArray(new Double[splitSilhouettes.size()]));
    }

    public static double meanSplitSilhouette(Subsegregatable sseg, Clusters clusters, int L) {
        return MSplitSilhouetteCalculator.averageSplitSilhouette(sseg, clusters, L, new MeanSummarizer());
    }

    public static double medianSplitSilhouette(Subsegregatable sseg, Clusters clusters, int L) {
        return MSplitSilhouetteCalculator.averageSplitSilhouette(sseg, clusters, L, new MedianSummarizer());
    }

    public static Clusters splitByAverageSplitSilhouette(Subsegregatable sseg, int K, int L, boolean forceSplit, Summarizer summarizer) {
        Clusters split = null;
        int m = sseg.size();
        if (K > m / 3) {
            K = m / 3;
        }
        int minK = forceSplit ? 2 : 1;
        double avgSplitSil = Double.POSITIVE_INFINITY;
        for (int k = minK; k <= K; ++k) {
            Clusters clusters = sseg.cluster(k);
            double t = MSplitSilhouetteCalculator.averageSplitSilhouette(sseg, clusters, L, summarizer);
            if (!(t < avgSplitSil)) continue;
            avgSplitSil = t;
            split = clusters;
        }
        if (split == null) {
            split = sseg.cluster(minK);
        }
        split.setCost(avgSplitSil);
        return split;
    }

    public static Clusters splitByMeanSplitSilhouette(Subsegregatable sseg, int K, int L) {
        return MSplitSilhouetteCalculator.splitByMeanSplitSilhouette(sseg, K, L, false);
    }

    public static Clusters splitByMeanSplitSilhouette(Subsegregatable sseg, int K, int L, boolean forceSplit) {
        return MSplitSilhouetteCalculator.splitByAverageSplitSilhouette(sseg, K, L, forceSplit, new MeanSummarizer());
    }

    public static Clusters splitByMedianSplitSilhouette(Subsegregatable sseg, int K, int L) {
        return MSplitSilhouetteCalculator.splitByMedianSplitSilhouette(sseg, K, L, false);
    }

    public static Clusters splitByMedianSplitSilhouette(Subsegregatable sseg, int K, int L, boolean forceSplit) {
        return MSplitSilhouetteCalculator.splitByAverageSplitSilhouette(sseg, K, L, forceSplit, new MedianSummarizer());
    }

    public static Clusters splitByAverageSilhouette(Segregatable seg, int K, boolean forceSplit, Summarizer summarizer) {
        Clusters split = MSplitSilhouetteCalculator.segregateByAverageSilhouette(seg, K, summarizer);
        if (!forceSplit && split.getCost() >= 1.0) {
            split = seg.cluster(1);
            split.setCost(1.0);
        }
        return split;
    }

    public static Clusters splitByMeanSilhouette(Segregatable seg, int K, boolean forceSplit) {
        return MSplitSilhouetteCalculator.splitByAverageSilhouette(seg, K, forceSplit, new MeanSummarizer());
    }

    public static Clusters splitByMedianSilhouette(Segregatable seg, int K, boolean forceSplit) {
        return MSplitSilhouetteCalculator.splitByAverageSilhouette(seg, K, forceSplit, new MedianSummarizer());
    }
}

