/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.silhouette;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.silhouette.SilhouetteResult;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class SilhouetteUtil {
    public static SilhouetteResult SilhouetteCalculator(Matrix matrix, DistanceMetric metric, int[] labels) {
        double[][] distanceMatrix = matrix.getDistanceMatrix(metric);
        return SilhouetteUtil.SilhouetteCalculator(distanceMatrix, labels);
    }

    public static SilhouetteResult SilhouetteCalculator(double[][] distancematrix, int[] labels) {
        SilhouetteResult silresult = new SilhouetteResult();
        HashMap<Integer, Integer> classlabels = new HashMap<Integer, Integer>();
        int samplenum = labels.length;
        for (int i = 0; i < samplenum; ++i) {
            Integer currentlabel = labels[i];
            if (classlabels.containsKey(currentlabel)) {
                int count = (Integer)classlabels.get(currentlabel) + 1;
                classlabels.put(currentlabel, count);
                continue;
            }
            classlabels.put(currentlabel, 1);
        }
        int classnum = classlabels.size();
        for (int i = 0; i < samplenum; ++i) {
            double silhouettevalue = 0.0;
            double a = 0.0;
            double b = 0.0;
            Integer classlabel = labels[i];
            HashMap<Integer, Double> bvalues = new HashMap<Integer, Double>();
            for (int j = 0; j < samplenum; ++j) {
                if (i == j) continue;
                Integer currentclasslabel = labels[j];
                double distancevalue = 0.0;
                if (bvalues.containsKey(currentclasslabel)) {
                    distancevalue = (Double)bvalues.get(currentclasslabel);
                }
                bvalues.put(currentclasslabel, distancevalue += distancematrix[i][j]);
            }
            double mindis = Double.MAX_VALUE;
            Integer minlabel = null;
            for (Integer kLabel : bvalues.keySet()) {
                int count = (Integer)classlabels.get(kLabel);
                double value = (Double)bvalues.get(kLabel);
                if (kLabel.equals(classlabel)) {
                    a = value / (double)count;
                    continue;
                }
                if (!(value / (double)count < mindis)) continue;
                mindis = value / (double)count;
                minlabel = kLabel;
            }
            b = mindis;
            silhouettevalue = a > b ? (b - a) / a : (b - a) / b;
            silresult.addSilhouettevalue(silhouettevalue, minlabel);
        }
        return silresult;
    }

    public static void printSilhouette(SilhouetteResult result, int[] labels) {
        TreeMap clusters = new TreeMap();
        for (int row = 0; row < labels.length; ++row) {
            if (!clusters.containsKey(labels[row])) {
                clusters.put(labels[row], new TreeSet());
            }
            ((SortedSet)clusters.get(labels[row])).add(result.getSilhouettevalue(row));
        }
        for (Integer cluster2 : clusters.keySet()) {
            System.out.println("Cluster #" + cluster2);
            for (Double sil : (SortedSet)clusters.get(cluster2)) {
                System.out.println("Silhouette " + sil);
            }
        }
    }
}

