/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.silhouette;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.Numeric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.Summarizer;
import java.util.ArrayList;

public class Silhouettes {
    ArrayList<Double> silhouetteValues = new ArrayList();
    ArrayList<Integer> neighborLabels = new ArrayList();

    public void addSilhouette(double value, Integer label) {
        this.silhouetteValues.add(value);
        this.neighborLabels.add(label);
    }

    public void deleteSilhouette(int index) {
        this.silhouetteValues.remove(index);
        this.neighborLabels.remove(index);
    }

    public double getSilhouette(int index) {
        return this.silhouetteValues.get(index);
    }

    public Integer getNeighbor(int index) {
        return this.neighborLabels.get(index);
    }

    public int size() {
        return this.silhouetteValues.size();
    }

    public double getMean() {
        return Numeric.mean(this.silhouetteValues.toArray(new Double[this.silhouetteValues.size()]));
    }

    public double getMedian() {
        return Numeric.median(this.silhouetteValues.toArray(new Double[this.silhouetteValues.size()]));
    }

    public double getAverage(Summarizer summarizer) {
        return summarizer.summarize(this.silhouetteValues.toArray(new Double[this.silhouetteValues.size()]));
    }
}

