/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.clusterFilters;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AbstractClusterResults;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AbstractNetworkClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.NewNetworkView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNetworkFilter
extends AbstractNetworkClusterer {
    protected String groupAttribute;

    public AbstractNetworkFilter(ClusterManager clusterManager, String groupAttribute) {
        super(clusterManager);
        this.groupAttribute = groupAttribute;
    }

    public void run(TaskMonitor monitor) {
        monitor.setTitle("Filtering using " + this.getName());
        this.monitor = monitor;
        if (this.network == null) {
            this.network = this.clusterManager.getNetwork();
        }
        this.clusterAttributeName = this.getClusterAttributeName();
        List<List<CyNode>> clusterList = AbstractNetworkClusterer.getNodeClusters(this.network, this.getClusterAttribute());
        ArrayList<NodeCluster> newClusterList = new ArrayList<NodeCluster>();
        System.out.println("ClusterList has " + clusterList.size() + " clusters");
        HashMap<NodeCluster, List<CyNode>> addedNodeMap = new HashMap<NodeCluster, List<CyNode>>();
        for (List<CyNode> nodeList : clusterList) {
            NodeCluster newCluster = this.doFilter(nodeList, addedNodeMap);
            if (newCluster == null || newCluster.size() <= 0) continue;
            newClusterList.add(newCluster);
        }
        if (addedNodeMap.size() > 0) {
            for (NodeCluster addedCluster : addedNodeMap.keySet()) {
                for (NodeCluster cluster2 : newClusterList) {
                    if (cluster2.equals(addedCluster)) continue;
                    this.removeNodes(cluster2, (List)addedNodeMap.get(addedCluster));
                }
            }
        }
        monitor.showMessage(TaskMonitor.Level.INFO, "Removing groups");
        this.removeGroups(this.network, this.groupAttribute);
        monitor.showMessage(TaskMonitor.Level.INFO, "Creating groups");
        List<List<CyNode>> nodeClusters = this.createGroups(this.network, newClusterList, this.groupAttribute);
        System.out.println("nodeClusters has " + nodeClusters.size() + " clusters");
        this.results = new AbstractClusterResults(this.network, clusterList);
        AbstractClusterResults results2 = new AbstractClusterResults(this.network, nodeClusters);
        monitor.showMessage(TaskMonitor.Level.INFO, "Done.  Results:\n\nBefore Filter:\n" + this.results + "\n\nAfter Filter:\n" + results2);
        if (this.showUI()) {
            monitor.showMessage(TaskMonitor.Level.INFO, "Creating network");
            this.insertTasksAfterCurrentTask(new Task[]{new NewNetworkView(this.network, this.clusterManager, true, this.restoreEdges())});
        }
    }

    public abstract NodeCluster doFilter(List<CyNode> var1, Map<NodeCluster, List<CyNode>> var2);

    public abstract String getClusterAttribute();

    public abstract String getClusterAttributeName();

    public abstract boolean restoreEdges();

    public abstract boolean showUI();

    private void removeNodes(NodeCluster cluster2, List<CyNode> nodesToRemove) {
        for (CyNode node : nodesToRemove) {
            if (!cluster2.contains(node)) continue;
            cluster2.remove(node);
        }
    }
}

