/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.clusterFilters.BestNeighbor;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.clusterFilters.AbstractNetworkFilter;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.clusterFilters.BestNeighbor.BestNeighborContext;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Tunable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BestNeighborFilter
extends AbstractNetworkFilter {
    public static String SHORTNAME = "bestneighbor";
    public static String NAME = "Best Neighbor Filter";
    public static final String GROUP_ATTRIBUTE = "__BestNeighborGroups.SUID";
    @Tunable(description="Network to filter", context="nogui")
    public CyNetwork network = null;
    @ContainsTunables
    public BestNeighborContext context = null;

    public BestNeighborFilter(BestNeighborContext context, ClusterManager clusterManager) {
        super(clusterManager, GROUP_ATTRIBUTE);
        this.context = context;
        if (this.network == null) {
            this.network = clusterManager.getNetwork();
        }
        context.setNetwork(this.network);
        ((AbstractNetworkFilter)this).network = this.network;
    }

    @Override
    public String getShortName() {
        return SHORTNAME;
    }

    @Override
    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    @Override
    public String getClusterAttribute() {
        return this.context.getClusterAttribute();
    }

    @Override
    public String getClusterAttributeName() {
        return this.context.getClusterAttributeName();
    }

    @Override
    public boolean restoreEdges() {
        return this.context.vizProperties.restoreEdges;
    }

    @Override
    public boolean showUI() {
        return this.context.vizProperties.showUI;
    }

    @Override
    public NodeCluster doFilter(List<CyNode> nodeList, Map<NodeCluster, List<CyNode>> addedNodeMap) {
        HashSet<CyNode> clusterNodes = new HashSet<CyNode>(nodeList);
        ArrayList<CyNode> newNodeList = new ArrayList<CyNode>();
        newNodeList.addAll(nodeList);
        ArrayList<CyNode> nodesToAdd = new ArrayList<CyNode>();
        for (CyNode node : nodeList) {
            for (CyNode neighbor : this.network.getNeighborList(node, CyEdge.Type.ANY)) {
                double adjacency;
                if (clusterNodes.contains(neighbor) || !((adjacency = this.getAdjacency(neighbor, clusterNodes)) > this.context.threshold)) continue;
                nodesToAdd.add(neighbor);
            }
        }
        newNodeList.addAll(nodesToAdd);
        if (newNodeList.size() > 1) {
            NodeCluster newNodeCluster = new NodeCluster((Collection<CyNode>)newNodeList);
            if (nodesToAdd.size() > 0) {
                addedNodeMap.put(newNodeCluster, nodesToAdd);
            }
            return newNodeCluster;
        }
        return null;
    }

    private double getAdjacency(CyNode neighbor, Set<CyNode> clusterNodes) {
        List edgeList = this.network.getAdjacentEdgeList(neighbor, CyEdge.Type.ANY);
        int totalEdges = edgeList.size();
        if (totalEdges == 0) {
            return 0.0;
        }
        int adjacentEdges = 0;
        for (CyEdge edge : edgeList) {
            if (!clusterNodes.contains(edge.getSource()) && !clusterNodes.contains(edge.getTarget())) continue;
            ++adjacentEdges;
        }
        return (double)adjacentEdges / (double)totalEdges;
    }
}

