/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.clusterFilters.Density;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AdvancedProperties;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.clusterFilters.AbstractFilterContext;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.NetworkVizProperties;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.TunableUIHelper;
import org.cytoscape.work.util.ListSingleSelection;

public class DensityContext
extends AbstractFilterContext {
    CyNetwork network;
    @Tunable(description="Minimum density", groups={"Density Filter Basic Parameters"}, gravity=1.0)
    public double minimumDensity = 0.5;
    @Tunable(description="Cluster results column to filter", groups={"Density Filter Basic Parameters"}, gravity=2.0)
    public ListSingleSelection clusterAttribute = null;
    @ContainsTunables
    public AdvancedProperties advancedAttributes = null;
    @ContainsTunables
    public NetworkVizProperties vizProperties = new NetworkVizProperties();

    public DensityContext() {
        this.advancedAttributes = new AdvancedProperties("__densityFilter", false);
    }

    public DensityContext(DensityContext origin) {
        super(origin);
        this.advancedAttributes = origin.advancedAttributes != null ? new AdvancedProperties(origin.advancedAttributes) : new AdvancedProperties("__densityFilter", false);
        this.minimumDensity = origin.minimumDensity;
    }

    public void setNetwork(CyNetwork network) {
        if (this.network != null && this.network.equals(network)) {
            return;
        }
        this.network = network;
        List<String> integerColumns = super.getClusterAttributeList(network);
        if (integerColumns != null) {
            this.clusterAttribute = new ListSingleSelection(integerColumns);
            String defaultAttribute = super.getDefaultAttribute(network);
            if (integerColumns.contains(defaultAttribute)) {
                this.clusterAttribute.setSelectedValue((Object)defaultAttribute);
            }
        }
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public String getClusterAttributeName() {
        return this.advancedAttributes.clusterAttribute;
    }

    public String getClusterAttribute() {
        return this.clusterAttribute.getSelectedValue().toString();
    }

    public void setUIHelper(TunableUIHelper helper) {
    }
}

