/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.edgeConverters;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.DistanceMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.edgeConverters.DistanceConverter1;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.edgeConverters.DistanceConverter2;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.edgeConverters.EdgeWeightConverter;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.edgeConverters.LogConverter;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.edgeConverters.NegLogConverter;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.edgeConverters.NoneConverter;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.edgeConverters.SCPSConverter;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.edgeConverters.ThresholdHeuristic;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.HistoChangeListener;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.HistogramDialog;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.RequestsUIHelper;
import org.cytoscape.work.swing.TunableUIHelper;
import org.cytoscape.work.util.BoundedDouble;
import org.cytoscape.work.util.ListSingleSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeAttributeHandler
implements HistoChangeListener,
RequestsUIHelper {
    private DistanceMatrix matrix = null;
    private CyNetwork network = null;
    private List<EdgeWeightConverter> converters = null;
    private TunableUIHelper helper = null;
    private ListSingleSelection<String> attribute;
    @Tunable(description="Cluster only selected nodes", groups={"Source for array data"}, gravity=11.0)
    public boolean selectedOnly;
    @Tunable(description="Edge weight conversion", groups={"Source for array data"}, gravity=12.0)
    public ListSingleSelection<EdgeWeightConverter> edgeWeighter;
    public BoundedDouble edgeCutOff;
    public boolean edgeHistogram = false;
    @Tunable(description="Assume edges are undirected", groups={"Source for array data", "Array data adjustments"}, gravity=15.0)
    public boolean undirectedEdges = true;
    @Tunable(description="Adjust loops before clustering", groups={"Source for array data", "Array data adjustments"}, gravity=16.0)
    public boolean adjustLoops = true;
    private HistogramDialog histo = null;

    @Tunable(description="Array Sources", groups={"Source for array data"}, gravity=10.0)
    public ListSingleSelection<String> getattribute() {
        this.attribute = ModelUtils.updateEdgeAttributeList(this.network, this.attribute);
        return this.attribute;
    }

    public void setattribute(ListSingleSelection<String> attr) {
    }

    @Tunable(description="Edge cut off", listenForChange={"selectedOnly", "attribute", "edgeWeighter", "EdgeHistogram"}, groups={"Source for array data", "Edge weight cutoff"}, params="slider=true", gravity=13.0, tooltip="Edges less than this value will not be included")
    public BoundedDouble getedgeCutOff() {
        this.updateBounds();
        return this.edgeCutOff;
    }

    public void setedgeCutOff(BoundedDouble value) {
    }

    @Tunable(description="Show/Hide Edge Weight Histogram", groups={"Source for array data", "Edge weight cutoff"}, context="gui", gravity=14.0)
    public boolean getEdgeHistogram() {
        return this.edgeHistogram;
    }

    public void setEdgeHistogram(boolean eh) {
        this.edgeHistogram = eh;
        if (this.edgeHistogram) {
            this.createHistogramDialog();
        } else if (this.histo != null) {
            this.histo.setVisible(false);
        }
    }

    public EdgeAttributeHandler(CyNetwork network) {
        this(network, true);
    }

    public EdgeAttributeHandler(CyNetwork network, boolean initialize) {
        this.network = network;
        this.converters = new ArrayList<EdgeWeightConverter>();
        this.converters.add(new NoneConverter());
        this.converters.add(new DistanceConverter1());
        this.converters.add(new DistanceConverter2());
        this.converters.add(new LogConverter());
        this.converters.add(new NegLogConverter());
        this.converters.add(new SCPSConverter());
        if (initialize) {
            this.initializeTunables();
        }
    }

    public EdgeAttributeHandler(EdgeAttributeHandler clone) {
        this.converters = clone.converters;
        this.selectedOnly = clone.selectedOnly;
        this.attribute = new ListSingleSelection(clone.attribute.getPossibleValues());
        this.attribute.setSelectedValue(clone.attribute.getSelectedValue());
        this.edgeCutOff = new BoundedDouble((Double)clone.edgeCutOff.getLowerBound(), (Double)clone.edgeCutOff.getValue(), (Double)clone.edgeCutOff.getUpperBound(), false, false);
        this.adjustLoops = clone.adjustLoops;
        this.undirectedEdges = clone.undirectedEdges;
        this.edgeWeighter = new ListSingleSelection(clone.edgeWeighter.getPossibleValues());
        this.edgeWeighter.setSelectedValue(clone.edgeWeighter.getSelectedValue());
    }

    public void initializeTunables() {
        this.attribute = ModelUtils.updateEdgeAttributeList(this.network, this.attribute);
        Object[] edgeWeightConverters = this.converters.toArray(new EdgeWeightConverter[1]);
        if (edgeWeightConverters.length > 0) {
            this.edgeWeighter = new ListSingleSelection(edgeWeightConverters);
            this.edgeWeighter.setSelectedValue(edgeWeightConverters[0]);
        } else {
            this.edgeWeighter = new ListSingleSelection((Object[])new EdgeWeightConverter[0]);
        }
        this.edgeCutOff = new BoundedDouble(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(100.0), false, false);
    }

    public void setNetwork(CyNetwork network) {
        this.network = network;
        this.attribute = ModelUtils.updateEdgeAttributeList(network, this.attribute);
    }

    public BoundedDouble updateBounds() {
        double cutOff = 0.0;
        double max = 100.0;
        double min = 0.0;
        if (this.attribute == null || ((String)this.attribute.getSelectedValue()).equals("--None--")) {
            this.edgeCutOff.setBounds((Comparable)Double.valueOf(min), (Comparable)Double.valueOf(max));
            return this.edgeCutOff;
        }
        this.matrix = new DistanceMatrix(this.network, (String)this.attribute.getSelectedValue(), this.selectedOnly, (EdgeWeightConverter)this.edgeWeighter.getSelectedValue());
        max = this.matrix.getMaxWeight();
        min = this.matrix.getMinWeight();
        if (max != (Double)this.edgeCutOff.getUpperBound() || min != (Double)this.edgeCutOff.getLowerBound()) {
            this.edgeCutOff.setBounds((Comparable)Double.valueOf(min), (Comparable)Double.valueOf(max));
        }
        return this.edgeCutOff;
    }

    @Override
    public void histoValueChanged(double cutoffValue) {
        this.edgeCutOff.setValue((Comparable)Double.valueOf(cutoffValue));
    }

    public void createHistogramDialog() {
        if (this.matrix == null) {
            this.matrix = new DistanceMatrix(this.network, (String)this.attribute.getSelectedValue(), this.selectedOnly, (EdgeWeightConverter)this.edgeWeighter.getSelectedValue());
        }
        ThresholdHeuristic thueristic = new ThresholdHeuristic(this.matrix);
        double[] dataArray = this.matrix.getEdgeValues();
        int nbins = 100;
        if (dataArray.length < 100) {
            nbins = 10;
        }
        String title = "Histogram for " + (String)this.attribute.getSelectedValue() + " edge attribute";
        this.histo = new HistogramDialog(this.helper.getParent(), title, dataArray, nbins, thueristic);
        this.histo.pack();
        this.histo.setVisible(true);
        this.histo.addHistoChangeListener(this);
    }

    public DistanceMatrix getMatrix() {
        if (this.matrix == null) {
            if (this.attribute.getSelectedValue() == null) {
                return null;
            }
            this.matrix = new DistanceMatrix(this.network, (String)this.attribute.getSelectedValue(), this.selectedOnly, (EdgeWeightConverter)this.edgeWeighter.getSelectedValue());
        }
        this.matrix.setUndirectedEdges(this.undirectedEdges);
        if (this.edgeCutOff != null) {
            this.matrix.setEdgeCutOff((Double)this.edgeCutOff.getValue());
        }
        if (this.adjustLoops) {
            this.matrix.adjustLoops();
        }
        return this.matrix;
    }

    public void setParams(List<String> params) {
        if (this.adjustLoops) {
            params.add("adjustLoops");
        }
        if (this.edgeCutOff != null) {
            params.add("edgeCutOff=" + ((Double)this.edgeCutOff.getValue()).toString());
        }
        if (this.selectedOnly) {
            params.add("selectedOnly");
        }
        if (this.undirectedEdges) {
            params.add("undirectedEdges");
        }
        params.add("converter=" + ((EdgeWeightConverter)this.edgeWeighter.getSelectedValue()).getShortName());
        params.add("dataAttribute=" + (String)this.attribute.getSelectedValue());
    }

    public EdgeWeightConverter getConverter(String converterName) {
        if (converterName == null) {
            return null;
        }
        for (EdgeWeightConverter ewc : this.converters) {
            if (!converterName.equals(ewc.getShortName())) continue;
            return ewc;
        }
        return null;
    }

    public void setUIHelper(TunableUIHelper helper) {
        this.helper = helper;
    }
}

