/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AP;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AdvancedProperties;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.edgeConverters.EdgeAttributeHandler;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.NetworkVizProperties;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterAlgorithmContext;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.TunableUIHelper;

public class APContext
implements ClusterAlgorithmContext {
    CyNetwork network;
    @Tunable(description="Lambda parameter", groups={"AP Tuning"}, gravity=1.0)
    public double lambda = 0.5;
    @Tunable(description="Preference Parameter (Set to Avg Edge Weight if < 0)", groups={"AP Tuning"}, gravity=2.0)
    public double preference = -1.0;
    @Tunable(description="Number of iterations", groups={"AP Tuning"}, gravity=3.0)
    public int rNumber = 8;
    @ContainsTunables
    public EdgeAttributeHandler edgeAttributeHandler;
    @ContainsTunables
    public AdvancedProperties advancedAttributes;
    @ContainsTunables
    public NetworkVizProperties vizProperties = new NetworkVizProperties();

    public APContext() {
        this.advancedAttributes = new AdvancedProperties("__APCluster", false);
    }

    public APContext(APContext origin) {
        this.advancedAttributes = origin.advancedAttributes != null ? new AdvancedProperties(origin.advancedAttributes) : new AdvancedProperties("__APCluster", false);
        if (origin.edgeAttributeHandler != null) {
            this.edgeAttributeHandler = new EdgeAttributeHandler(origin.edgeAttributeHandler);
        }
        this.lambda = origin.lambda;
        this.preference = origin.preference;
        this.rNumber = origin.rNumber;
    }

    public void setNetwork(CyNetwork network) {
        if (this.network != null && this.network.equals(network)) {
            return;
        }
        this.network = network;
        if (this.edgeAttributeHandler == null) {
            this.edgeAttributeHandler = new EdgeAttributeHandler(network);
        } else {
            this.edgeAttributeHandler.setNetwork(network);
        }
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public String getClusterAttribute() {
        return this.advancedAttributes.clusterAttribute;
    }

    public void setUIHelper(TunableUIHelper helper) {
        this.edgeAttributeHandler.setUIHelper(helper);
    }
}

