/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AP;

import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.matrix.tdouble.DoubleFactory1D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AP.APMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AP.AvailabilityMatrix;

public class ResponsibilityMatrix
extends APMatrix {
    private DoubleMatrix1D evidenceVector = null;

    public ResponsibilityMatrix(DoubleMatrix2D s_matrix, double lambda) {
        super(s_matrix, lambda);
    }

    public double getEvidence(int col) {
        if (this.evidenceVector == null) {
            this.updateEvidence();
        }
        return this.evidenceVector.get(col);
    }

    public void updateEvidence() {
        this.evidenceVector = DoubleFactory1D.dense.make(this.s_matrix.columns());
        this.s_matrix.forEachNonZero((IntIntDoubleFunction)new CalculateEvidence(this.evidenceVector));
    }

    public void update(AvailabilityMatrix a_matrix) {
        this.s_matrix.forEachNonZero((IntIntDoubleFunction)new UpdateResponsibility(a_matrix));
    }

    class CalculateEvidence
    implements IntIntDoubleFunction {
        DoubleMatrix1D maxVector;

        public CalculateEvidence(DoubleMatrix1D maxMat) {
            this.maxVector = maxMat;
        }

        public double apply(int row, int col, double value) {
            if (row != col) {
                this.maxVector.set(col, this.maxVector.get(col) + Math.max(0.0, ResponsibilityMatrix.this.get(row, col)));
            }
            return value;
        }
    }

    class UpdateResponsibility
    implements IntIntDoubleFunction {
        AvailabilityMatrix a_matrix;

        public UpdateResponsibility(AvailabilityMatrix a_matrix) {
            this.a_matrix = a_matrix;
        }

        public double apply(int row, int col, double value) {
            double newValue = row != col ? value - this.a_matrix.getEvidence(row) : ResponsibilityMatrix.this.s_matrix.get(row, col) - this.a_matrix.getEvidence(row);
            ResponsibilityMatrix.this.setDamped(row, col, newValue);
            return value;
        }
    }
}

