/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.ConnectedComponents;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AbstractClusterResults;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.DistanceMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AbstractNetworkClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.ConnectedComponents.ConnectedComponentsContext;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.NewNetworkView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.TunableUIHelper;

public class ConnectedComponentsCluster
extends AbstractNetworkClusterer {
    public static String SHORTNAME = "connectedcomponents";
    public static String NAME = "ConnectedComponents Cluster";
    public static final String GROUP_ATTRIBUTE = "__CCGroups.SUID";
    @Tunable(description="Network to cluster", context="nogui")
    public CyNetwork network = null;
    @ContainsTunables
    public ConnectedComponentsContext context = null;

    public ConnectedComponentsCluster(ConnectedComponentsContext context, ClusterManager manager) {
        super(manager);
        this.context = context;
        if (this.network == null) {
            this.network = this.clusterManager.getNetwork();
        }
        context.setNetwork(this.network);
    }

    public String getShortName() {
        return SHORTNAME;
    }

    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    public void run(TaskMonitor monitor) {
        DistanceMatrix matrix;
        monitor.setTitle("Performing ConnectedComponents cluster");
        this.monitor = monitor;
        if (this.network == null) {
            this.network = this.clusterManager.getNetwork();
        }
        if ((matrix = this.context.edgeAttributeHandler.getMatrix()) == null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Can't get distance matrix: no attribute value?");
            return;
        }
        this.clusterAttributeName = this.context.getClusterAttribute();
        this.createGroups = this.context.advancedAttributes.createGroups;
        if (this.canceled) {
            return;
        }
        Map<Integer, List<CyNode>> components = matrix.findConnectedComponents();
        HashMap<Integer, NodeCluster> clusterMap = new HashMap<Integer, NodeCluster>();
        for (Integer cluster2 : components.keySet()) {
            clusterMap.put(cluster2, new NodeCluster((Collection<CyNode>)components.get(cluster2)));
        }
        int clusterNumber = 1;
        HashMap<NodeCluster, NodeCluster> cMap = new HashMap<NodeCluster, NodeCluster>();
        for (NodeCluster cluster3 : NodeCluster.sortMap(clusterMap)) {
            if (cMap.containsKey(cluster3)) continue;
            cMap.put(cluster3, cluster3);
            cluster3.setClusterNumber(clusterNumber);
            ++clusterNumber;
        }
        ArrayList<NodeCluster> clusters = new ArrayList<NodeCluster>(cMap.keySet());
        monitor.showMessage(TaskMonitor.Level.INFO, "Removing groups");
        this.removeGroups(this.network, GROUP_ATTRIBUTE);
        monitor.showMessage(TaskMonitor.Level.INFO, "Creating groups");
        this.params = new ArrayList();
        this.context.edgeAttributeHandler.setParams(this.params);
        List<List<CyNode>> nodeClusters = this.createGroups(this.network, clusters, GROUP_ATTRIBUTE);
        this.results = new AbstractClusterResults(this.network, nodeClusters);
        monitor.showMessage(TaskMonitor.Level.INFO, "ConnectedComponent results:\n" + this.results);
        if (this.context.vizProperties.showUI) {
            monitor.showMessage(TaskMonitor.Level.INFO, "Creating network");
            this.insertTasksAfterCurrentTask(new Task[]{new NewNetworkView(this.network, this.clusterManager, true, this.context.vizProperties.restoreEdges)});
        }
    }

    public void cancel() {
    }

    public void setUIHelper(TunableUIHelper helper) {
        this.context.setUIHelper(helper);
    }
}

