/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.FCM;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AdvancedProperties;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.edgeConverters.EdgeAttributeHandler;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.NetworkVizProperties;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterAlgorithmContext;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.TunableUIHelper;
import org.cytoscape.work.util.BoundedDouble;

public class FCMContext
implements ClusterAlgorithmContext {
    CyNetwork network;
    @ContainsTunables
    public EdgeAttributeHandler edgeAttributeHandler;
    @Tunable(description="Number of clusters", gravity=19.0)
    public int cNumber = -1;
    @Tunable(description="Threshold for Fuzzy Membership in a Cluster", groups={"FCM Advanced Settings"}, params="displayState=collapsed, slider=true", gravity=20.0)
    public BoundedDouble membershipThreshold = new BoundedDouble(Double.valueOf(0.0), Double.valueOf(0.2), Double.valueOf(1.0), false, false);
    @Tunable(description="Number of iterations", groups={"FCM Advanced Settings"}, gravity=21.0)
    public int iterations = 16;
    @Tunable(description="Maximum number of threads", groups={"FCM Advanced Settings"}, gravity=23.0)
    public int maxThreads = 0;
    @Tunable(description="Maximum Number of clusters", groups={"FCM Advanced Settings"}, gravity=24.0)
    public int cMax = 10;
    @Tunable(description="Estimate the number of clusters", groups={"FCM Advanced Settings"}, gravity=25.0)
    public boolean estimateClusterNumber = true;
    @Tunable(description="Fuzziness Index", groups={"FCM Advanced Settings"}, gravity=26.0)
    public double fIndex = 1.5;
    @Tunable(description="Margin allowed for change in fuzzy memberships, to act as end criterion ", groups={"FCM Advanced Settings"}, gravity=27.0)
    public double beta = 0.01;
    @ContainsTunables
    public AdvancedProperties advancedAttributes;
    @ContainsTunables
    public NetworkVizProperties vizProperties = new NetworkVizProperties();

    public FCMContext() {
        this.advancedAttributes = new AdvancedProperties("__fcmCluster", false);
    }

    public FCMContext(FCMContext origin) {
        this.advancedAttributes = origin.advancedAttributes != null ? new AdvancedProperties(origin.advancedAttributes) : new AdvancedProperties("__fcmCluster", false);
        if (origin.edgeAttributeHandler != null) {
            this.edgeAttributeHandler = new EdgeAttributeHandler(origin.edgeAttributeHandler);
        }
        this.membershipThreshold = origin.membershipThreshold;
        this.iterations = origin.iterations;
        this.maxThreads = origin.maxThreads;
        this.cMax = origin.cMax;
        this.cNumber = origin.cNumber;
        this.fIndex = origin.fIndex;
        this.beta = origin.beta;
    }

    public void setNetwork(CyNetwork network) {
        if (this.network != null && this.network.equals(network)) {
            return;
        }
        this.network = network;
        if (this.edgeAttributeHandler == null) {
            this.edgeAttributeHandler = new EdgeAttributeHandler(network);
        } else {
            this.edgeAttributeHandler.setNetwork(network);
        }
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public String getClusterAttribute() {
        return this.advancedAttributes.clusterAttribute;
    }

    public void setUIHelper(TunableUIHelper helper) {
        this.edgeAttributeHandler.setUIHelper(helper);
    }
}

