/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.FCM;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.DistanceMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.FuzzyNodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunFCM {
    Random random = null;
    HashMap<String, List<CyNode>> groupMap = null;
    private int number_iterations;
    private int number_clusters;
    private double findex;
    private double beta;
    private boolean canceled = false;
    private TaskMonitor monitor;
    protected int clusterCount = 0;
    private boolean createMetaNodes = false;
    private DistanceMatrix distanceMatrix = null;
    double[][] clusterMemberships = null;
    double membershipThreshold = 0.0;
    private boolean debug = false;
    private int nThreads = Runtime.getRuntime().availableProcessors() - 1;

    public RunFCM(DistanceMatrix distanceMatrix, int num_iterations, int cClusters, double findex, double beta, double membershipThreshold, int maxThreads, TaskMonitor monitor) {
        this.distanceMatrix = distanceMatrix;
        this.number_iterations = num_iterations;
        this.number_clusters = cClusters;
        this.findex = findex;
        this.beta = beta;
        this.monitor = monitor;
        this.membershipThreshold = membershipThreshold;
        this.nThreads = maxThreads > 0 ? maxThreads : Runtime.getRuntime().availableProcessors() - 1;
        monitor.showMessage(TaskMonitor.Level.INFO, "Iterations = " + num_iterations);
        monitor.showMessage(TaskMonitor.Level.INFO, "Membership Threshold = " + membershipThreshold);
        monitor.showMessage(TaskMonitor.Level.INFO, "Threads = " + this.nThreads);
        monitor.showMessage(TaskMonitor.Level.INFO, "Number of Clusters = " + this.number_clusters);
        monitor.showMessage(TaskMonitor.Level.INFO, "Margin allowed for Change = " + beta);
        monitor.showMessage(TaskMonitor.Level.INFO, "Fuzziness Index = " + findex);
    }

    public void cancel() {
        this.canceled = true;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public List<FuzzyNodeCluster> run(CyNetwork network, TaskMonitor monitor, int[] mostRelevantCluster) {
        int i;
        Long networkID = network.getSUID();
        CyTable netAttributes = network.getDefaultNetworkTable();
        CyTable nodeAttributes = network.getDefaultNodeTable();
        long startTime = System.currentTimeMillis();
        this.random = null;
        int nelements = this.distanceMatrix.getNodes().size();
        double[][] tClusterMemberships = new double[nelements][this.number_clusters];
        for (int i2 = 0; i2 < nelements; ++i2) {
            for (int j = 0; j < this.number_clusters; ++j) {
                tClusterMemberships[i2][j] = 0.0;
            }
        }
        double[][] prevClusterMemberships = new double[nelements][this.number_clusters];
        Matrix cData = new Matrix(network, this.number_clusters, nelements);
        int iteration = 0;
        boolean end = false;
        do {
            if (monitor != null) {
                monitor.setProgress((double)iteration / (double)this.number_iterations);
            }
            if (iteration == 0 && this.number_iterations != 0) {
                this.randomAssign(tClusterMemberships);
                prevClusterMemberships = tClusterMemberships;
                this.getFuzzyCenters(cData, tClusterMemberships);
            }
            this.getClusterMemberships(cData, tClusterMemberships);
            this.getFuzzyCenters(cData, tClusterMemberships);
        } while (!(end = this.checkEndCriterion(tClusterMemberships, prevClusterMemberships)) && ++iteration < this.number_iterations);
        HashMap<CyNode, double[]> membershipMap = this.createMembershipMap(tClusterMemberships);
        ArrayList<FuzzyNodeCluster> fuzzyClusters = new ArrayList<FuzzyNodeCluster>();
        List<CyNode> clusterNodes = this.distanceMatrix.getNodes();
        for (i = 0; i < this.number_clusters; ++i) {
            ArrayList<CyNode> fuzzyNodeList = new ArrayList<CyNode>();
            HashMap<CyNode, Double> clusterMembershipMap = new HashMap<CyNode, Double>();
            for (CyNode node : clusterNodes) {
                if (!(membershipMap.get(node)[i] > this.membershipThreshold)) continue;
                fuzzyNodeList.add(node);
                clusterMembershipMap.put(node, membershipMap.get(node)[i]);
            }
            fuzzyClusters.add(new FuzzyNodeCluster(fuzzyNodeList, clusterMembershipMap));
        }
        for (i = 0; i < nelements; ++i) {
            int maxIndex = 0;
            for (int j = 1; j < this.number_clusters; ++j) {
                if (!(tClusterMemberships[i][j] > tClusterMemberships[i][maxIndex])) continue;
                maxIndex = j;
            }
            mostRelevantCluster[i] = maxIndex + 1;
        }
        this.clusterMemberships = tClusterMemberships;
        return fuzzyClusters;
    }

    public void getFuzzyCenters(Matrix cData, double[][] tClusterMemberships) {
        double[] totalMemberships = new double[this.number_clusters];
        int nelements = this.distanceMatrix.getNodes().size();
        for (int i = 0; i < this.number_clusters; ++i) {
            totalMemberships[i] = 0.0;
            for (int j = 0; j < nelements; ++j) {
                int n = i;
                totalMemberships[n] = totalMemberships[n] + Math.pow(tClusterMemberships[j][i], this.findex);
            }
        }
        for (int c = 0; c < this.number_clusters; ++c) {
            for (int d = 0; d < nelements; ++d) {
                double numerator = 0.0;
                Double distance = 0.0;
                for (int e = 0; e < nelements; ++e) {
                    distance = this.distanceMatrix.getEdgeValueFromMatrix(e, d);
                    numerator += Math.pow(tClusterMemberships[e][c], this.findex) * distance;
                }
                cData.setValue(c, d, numerator / totalMemberships[c]);
            }
        }
    }

    public void getClusterMemberships(Matrix cData, double[][] tClusterMemberships) {
        int nelements = this.distanceMatrix.getNodes().size();
        double fpower = 2.0 / (this.findex - 1.0);
        for (int i = 0; i < nelements; ++i) {
            for (int c = 0; c < this.number_clusters; ++c) {
                double sumDistanceRatios = 0.0;
                for (int k = 0; k < this.number_clusters; ++k) {
                    sumDistanceRatios += Math.pow(cData.getValue(c, i) / cData.getValue(k, i), fpower);
                }
                tClusterMemberships[i][c] = 1.0 / sumDistanceRatios;
            }
        }
    }

    public boolean checkEndCriterion(double[][] tClusterMemberships, double[][] prevClusterMemberships) {
        boolean endCheck = false;
        double[][] differences = new double[this.distanceMatrix.getNodes().size()][this.number_clusters];
        double maxdiff = -1.0;
        for (int i = 0; i < this.distanceMatrix.getNodes().size(); ++i) {
            for (int j = 0; j < this.number_clusters; ++j) {
                differences[i][j] = Math.abs(tClusterMemberships[i][j] - prevClusterMemberships[i][j]);
                if (!(differences[i][j] > maxdiff)) continue;
                maxdiff = differences[i][j];
            }
        }
        if (maxdiff != -1.0 && maxdiff < this.beta) {
            endCheck = true;
        }
        return endCheck;
    }

    private void randomAssign(double[][] tClusterMemberships) {
        Random randomGenerator = new Random();
        for (int i = 0; i < tClusterMemberships.length; ++i) {
            double sum = 0.0;
            for (int j = 0; j < this.number_clusters; ++j) {
                double temp = randomGenerator.nextInt(100);
                sum += temp;
                tClusterMemberships[i][j] = temp;
            }
            int k = 0;
            while (k < this.number_clusters) {
                double[] dArray = tClusterMemberships[i];
                int n = k++;
                dArray[n] = dArray[n] / sum;
            }
        }
    }

    public HashMap<CyNode, double[]> createMembershipMap(double[][] membershipArray) {
        HashMap<CyNode, double[]> membershipHM = new HashMap<CyNode, double[]>();
        List<CyNode> nodeList = this.distanceMatrix.getNodes();
        for (int i = 0; i < this.distanceMatrix.getNodes().size(); ++i) {
            membershipHM.put(nodeList.get(i), membershipArray[i]);
        }
        return membershipHM;
    }
}

