/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.GLay;

import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.GLay.GAlgorithm;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.GLay.GSimpleGraphData;
import java.util.HashMap;
import org.cytoscape.work.TaskMonitor;

public class FastGreedyAlgorithm
implements GAlgorithm {
    private double modularity;
    private int[] membership;
    private int clusterNumber;
    private double progress;
    private boolean halt = false;

    public FastGreedyAlgorithm() {
        this.reset();
    }

    public void reset() {
        this.modularity = 0.0;
        this.membership = new int[0];
        this.clusterNumber = 0;
        this.progress = 0.0;
    }

    public double getModularity() {
        return this.modularity;
    }

    public int[] getMembership() {
        return this.membership;
    }

    public int getClusterNumber() {
        return this.clusterNumber;
    }

    public double getProgress() {
        return this.progress;
    }

    public void cancel() {
        this.halt = true;
    }

    public void execute(GSimpleGraphData g, TaskMonitor monitor) {
        int i;
        double[] ai = new double[g.nodeCount];
        double qInitial = 0.0;
        this.membership = new int[g.nodeCount];
        for (int i2 = 0; i2 < g.nodeCount; ++i2) {
            this.membership[i2] = i2;
            ai[i2] = (double)g.degree[i2] / (2.0 * (double)g.edgeCount);
            qInitial -= ai[i2] * ai[i2];
        }
        DoubleMatrix2D deltaQMx = DoubleFactory2D.sparse.make(g.nodeCount, g.nodeCount);
        MaxFun func = new MaxFun();
        double maxDeltaQ = 0.0;
        double q = 0.0;
        int maxI = 0;
        int maxJ = 0;
        double deltaQ = 0.0;
        boolean itojDirectedEdgecount = false;
        boolean jtoiDirectedEdgecount = false;
        boolean ijUndirectedEdgeCount = false;
        boolean ijTotalEdgeCount = false;
        for (int i3 = 0; i3 < g.nodeCount; ++i3) {
            for (int j = 0; j < g.nodeCount; ++j) {
                if (i3 == j) continue;
                if (g.hasEdge(i3, j) && i3 < j) {
                    deltaQ = (1.0 / (double)(2 * g.edgeCount) - (double)(g.degree[i3] * g.degree[j]) / (4.0 * Math.pow(g.edgeCount, 2.0))) * 2.0;
                    deltaQMx.setQuick(i3, j, deltaQ);
                    if (!(maxDeltaQ <= deltaQ)) continue;
                    maxDeltaQ = deltaQ;
                    maxI = i3;
                    maxJ = j;
                    continue;
                }
                if (!g.hasEdge(i3, j) || i3 <= j) continue;
                deltaQMx.setQuick(i3, j, deltaQMx.getQuick(j, i3));
            }
        }
        if (maxI > maxJ) {
            int temp = maxI;
            maxI = maxJ;
            maxJ = temp;
        }
        q = qInitial;
        int counter = 0;
        this.progress = (double)counter / (double)g.nodeCount;
        if (monitor != null) {
            monitor.setProgress(this.progress);
        }
        if (this.halt) {
            return;
        }
        while (maxDeltaQ > 0.0) {
            ++counter;
            q += maxDeltaQ;
            for (int k = 0; k < g.nodeCount; ++k) {
                if (this.halt) {
                    return;
                }
                if (k == maxJ || k == maxI) continue;
                if (deltaQMx.getQuick(maxI, k) != 0.0 && deltaQMx.getQuick(maxJ, k) != 0.0) {
                    deltaQMx.setQuick(maxJ, k, deltaQMx.getQuick(maxJ, k) + deltaQMx.getQuick(maxI, k));
                    continue;
                }
                if (deltaQMx.getQuick(maxI, k) == 0.0 && deltaQMx.getQuick(maxJ, k) != 0.0) {
                    deltaQMx.setQuick(maxJ, k, deltaQMx.getQuick(maxJ, k) - 2.0 * ai[maxI] * ai[k]);
                    continue;
                }
                if (deltaQMx.getQuick(maxJ, k) != 0.0 || deltaQMx.getQuick(maxI, k) == 0.0) continue;
                deltaQMx.setQuick(maxJ, k, deltaQMx.getQuick(maxI, k) - 2.0 * ai[maxJ] * ai[k]);
            }
            int membershipI = this.membership[maxI];
            int membershipJ = this.membership[maxJ];
            for (int k = 0; k < g.nodeCount; ++k) {
                deltaQMx.setQuick(k, maxJ, deltaQMx.getQuick(maxJ, k));
                deltaQMx.setQuick(maxI, k, 0.0);
                deltaQMx.setQuick(k, maxI, 0.0);
                if (this.membership[k] != membershipI) continue;
                this.membership[k] = membershipJ;
            }
            ai[maxJ] = ai[maxI] + ai[maxJ];
            ai[maxI] = 0.0;
            deltaQMx.trimToSize();
            maxDeltaQ = 0.0;
            maxI = 0;
            maxJ = 0;
            func.reset();
            deltaQMx.forEachNonZero((IntIntDoubleFunction)func);
            maxDeltaQ = func.max;
            maxI = func.row;
            maxJ = func.column;
            if (maxI <= maxJ) continue;
            int temp = maxI;
            maxI = maxJ;
            maxJ = temp;
        }
        HashMap<Integer, Integer> membershipMapping = new HashMap<Integer, Integer>();
        int index = 0;
        for (i = 0; i < this.membership.length; ++i) {
            if (membershipMapping.containsKey(new Integer(this.membership[i]))) continue;
            membershipMapping.put(new Integer(this.membership[i]), new Integer(index));
            ++index;
        }
        this.clusterNumber = membershipMapping.keySet().size();
        for (i = 0; i < this.membership.length; ++i) {
            this.membership[i] = (Integer)membershipMapping.get(new Integer(this.membership[i]));
        }
        this.modularity = q;
        this.progress = 100.0;
        if (monitor != null) {
            monitor.setProgress(this.progress);
        }
    }

    private class MaxFun
    implements IntIntDoubleFunction {
        public double max = -1.7976931348623157E308;
        public int row = 0;
        public int column = 0;

        public void reset() {
            this.max = -1.7976931348623157E308;
            this.row = 0;
            this.column = 0;
        }

        public double apply(int row, int col, double value) {
            if (this.max < value) {
                this.max = value;
                this.row = row;
                this.column = col;
            }
            return value;
        }
    }
}

