/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.GLay;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AdvancedProperties;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.NetworkVizProperties;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterAlgorithmContext;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.TunableUIHelper;

public class GLayContext
implements ClusterAlgorithmContext {
    CyNetwork network;
    @Tunable(description="Cluster only selected nodes", groups={"Basic GLay Tuning"}, gravity=1.0)
    public boolean selectedOnly = false;
    @Tunable(description="Assume edges are undirected", groups={"Basic GLay Tuning"}, gravity=2.0)
    public boolean undirectedEdges = true;
    @ContainsTunables
    public AdvancedProperties advancedAttributes;
    @ContainsTunables
    public NetworkVizProperties vizProperties = new NetworkVizProperties();

    public GLayContext() {
        this.advancedAttributes = new AdvancedProperties("__glayCluster", false);
    }

    public GLayContext(GLayContext origin) {
        this.advancedAttributes = origin.advancedAttributes != null ? new AdvancedProperties(origin.advancedAttributes) : new AdvancedProperties("__glayCluster", false);
        this.selectedOnly = origin.selectedOnly;
        this.undirectedEdges = origin.undirectedEdges;
    }

    public void setNetwork(CyNetwork network) {
        if (this.network != null && this.network.equals(network)) {
            return;
        }
        this.network = network;
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public String getClusterAttribute() {
        return this.advancedAttributes.clusterAttribute;
    }

    public void setUIHelper(TunableUIHelper helper) {
    }
}

