/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.GLay;

import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;

public class GSimpleGraphData {
    public int nodeCount;
    public int edgeCount;
    public CyNetwork network;
    public CyNode[] graphIndices;
    public int[] degree;
    public DoubleMatrix2D edgeMatrix;
    private boolean selectedOnly;
    private boolean undirectedEdges;
    private List<CyNode> nodeList;
    private List<CyEdge> connectingEdges;

    public GSimpleGraphData(CyNetwork network, boolean selectedOnly, boolean undirectedEdges) {
        this.network = network;
        this.selectedOnly = selectedOnly;
        this.undirectedEdges = undirectedEdges;
        this.nodeList = !selectedOnly ? network.getNodeList() : new ArrayList<CyNode>(CyTableUtil.getNodesInState((CyNetwork)network, (String)"selected", (boolean)true));
        this.nodeCount = this.nodeList.size();
        this.connectingEdges = ModelUtils.getConnectingEdges(network, this.nodeList);
        this.edgeCount = this.connectingEdges.size();
        this.graphIndices = new CyNode[this.nodeCount];
        this.degree = new int[this.nodeCount];
        this.edgeMatrix = DoubleFactory2D.sparse.make(this.nodeCount, this.nodeCount);
        this.simplify();
    }

    private void simplify() {
        for (int i = 0; i < this.nodeList.size(); ++i) {
            this.graphIndices[i] = this.nodeList.get(i);
            this.degree[i] = this.network.getNeighborList(this.graphIndices[i], CyEdge.Type.ANY).size();
        }
        int ijEdge = 0;
        int jiEdge = 0;
        boolean ijUEdge = false;
        int totalEdge = 0;
        for (int i = 0; i < this.graphIndices.length - 1; ++i) {
            for (int j = i + 1; j < this.graphIndices.length; ++j) {
                if (this.undirectedEdges) {
                    jiEdge = this.network.getConnectingEdgeList(this.graphIndices[j], this.graphIndices[i], CyEdge.Type.ANY).size();
                } else {
                    ijEdge = this.network.getConnectingEdgeList(this.graphIndices[i], this.graphIndices[j], CyEdge.Type.DIRECTED).size();
                    jiEdge = this.network.getConnectingEdgeList(this.graphIndices[j], this.graphIndices[i], CyEdge.Type.DIRECTED).size();
                }
                totalEdge = ijEdge + jiEdge;
                this.edgeMatrix.setQuick(i, j, (double)totalEdge);
                if (totalEdge <= 1) continue;
                this.edgeCount = this.edgeCount - totalEdge + 1;
                this.degree[i] = this.degree[i] - totalEdge + 1;
                this.degree[j] = this.degree[j] - totalEdge + 1;
            }
        }
    }

    public boolean hasEdge(int i, int j) {
        if (i == j) {
            return false;
        }
        if (i > j) {
            int temp = i;
            i = j;
            j = temp;
        }
        return this.edgeMatrix.getQuick(i, j) != 0.0;
    }

    public void simplificationCheck() {
        System.out.println("---------------");
        System.out.println("Simplify check:");
        System.out.println("NodeCount:" + this.nodeCount);
        System.out.println("EdgeCount: O:" + this.network.getEdgeCount());
        System.out.println("EdgeCount: S:" + this.edgeCount);
        int totalDegree = 0;
        int totalDegreeBefore = 0;
        for (int i = 0; i < this.graphIndices.length; ++i) {
            totalDegree += this.degree[i];
            totalDegreeBefore += this.network.getNeighborList(this.graphIndices[i], CyEdge.Type.ANY).size();
        }
        System.out.println("TotalDegree O:" + totalDegreeBefore);
        System.out.println("TotalDegree S:" + totalDegree);
    }
}

