/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.SCPS;

import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleEigenvalueDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleSingularValueDecomposition;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.DistanceMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.SCPS.KCluster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunSCPS {
    private List<CyNode> nodes;
    private List<CyEdge> edges;
    private boolean canceled = false;
    public static final String GROUP_ATTRIBUTE = "__SCPSGroups";
    protected int clusterCount = 0;
    private boolean createMetaNodes = false;
    private DistanceMatrix distanceMatrix = null;
    private DoubleMatrix2D matrix = null;
    private boolean debug = false;
    private double epsilon;
    private int kvalue;
    private int rnumber;
    private DoubleMatrix2D LMat;
    private int numComponents;
    private HashMap<Integer, NodeCluster> clusterMap;
    private HashMap<Integer, Integer> new2oldMap;
    private HashMap<Integer, Integer> old2newMap;
    private TaskMonitor monitor;

    public RunSCPS(DistanceMatrix dMat, double epsilon, int kvalue, int rnumber, TaskMonitor monitor) {
        this.distanceMatrix = dMat;
        this.epsilon = epsilon;
        this.kvalue = kvalue;
        this.rnumber = rnumber;
        this.monitor = monitor;
        this.clusterMap = new HashMap();
        this.clusterCount = 0;
        this.nodes = this.distanceMatrix.getNodes();
        this.edges = this.distanceMatrix.getEdges();
        this.matrix = this.distanceMatrix.getDistanceMatrix();
        this.old2newMap = new HashMap();
        this.new2oldMap = new HashMap();
    }

    public void cancel() {
        this.canceled = true;
    }

    public List<NodeCluster> run(CyNetwork network, TaskMonitor monitor) {
        monitor.showMessage(TaskMonitor.Level.INFO, "Formatting Matrix Data");
        DoubleMatrix2D sMat = this.getSMat(this.distanceMatrix);
        DoubleMatrix2D LMat = this.getLMat(sMat);
        monitor.showMessage(TaskMonitor.Level.INFO, "Calculating Eigenvalues");
        DenseDoubleEigenvalueDecomposition decomp = new DenseDoubleEigenvalueDecomposition(LMat);
        DoubleMatrix2D eigenVect = decomp.getV();
        DoubleMatrix1D eigenVal = decomp.getRealEigenvalues();
        monitor.showMessage(TaskMonitor.Level.INFO, "Calculating K value");
        int k = this.kvalue > -1 ? this.kvalue : this.getK(eigenVal, 0.3);
        System.out.println("K is " + k);
        if (this.numComponents > k) {
            this.doComponentClustering();
            return new ArrayList<NodeCluster>(this.clusterMap.values());
        }
        monitor.showMessage(TaskMonitor.Level.INFO, "Creating uMatrix for kMeans");
        DoubleMatrix2D uMat = this.getUMat(eigenVect, k);
        monitor.showMessage(TaskMonitor.Level.INFO, "Running kmeans clustering");
        this.doKMeansClustering(uMat, sMat);
        return new ArrayList<NodeCluster>(this.clusterMap.values());
    }

    public void setMap(int old_index, int new_index) {
        this.new2oldMap.put(new Integer(new_index), new Integer(old_index));
        this.old2newMap.put(new Integer(old_index), new Integer(new_index));
    }

    public int getMap_old(int new_index) {
        return this.new2oldMap.get(new Integer(new_index));
    }

    public int getMap_new(int old_index) {
        try {
            return this.old2newMap.get(new Integer(old_index));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public DoubleMatrix2D getSMat(DistanceMatrix distanceMatrix) {
        int i;
        DoubleMatrix2D unfiltered_mat = distanceMatrix.getDistanceMatrix();
        int sMat_rows = 0;
        HashMap filtered_cmap = new HashMap();
        Map<Integer, List<CyNode>> cMap = distanceMatrix.findConnectedComponents();
        IntArrayList rowList = new IntArrayList();
        IntArrayList columnList = new IntArrayList();
        DoubleArrayList valueList = new DoubleArrayList();
        Iterator<List<CyNode>> it = cMap.values().iterator();
        int component_size_sum = 0;
        while (it.hasNext()) {
            List<CyNode> component = it.next();
            ++this.numComponents;
            if (component.size() <= 5) {
                NodeCluster iCluster = new NodeCluster((Collection<CyNode>)component);
                iCluster.setClusterNumber(this.clusterCount);
                this.clusterMap.put(new Integer(this.clusterCount), iCluster);
                ++this.clusterCount;
                continue;
            }
            System.out.println("Normal Component size " + component.size() + " Total Sum " + (component_size_sum += component.size()));
            for (int i2 = 0; i2 < component.size(); ++i2) {
                CyNode n = component.get(i2);
                int node_id = this.nodes.indexOf(n);
                this.setMap(node_id, sMat_rows);
                ++sMat_rows;
            }
        }
        DoubleMatrix2D sMat = DoubleFactory2D.sparse.make(sMat_rows, sMat_rows);
        for (i = 0; i < sMat_rows; ++i) {
            sMat.set(i, i, 1.0);
        }
        unfiltered_mat.getNonZeros(rowList, columnList, valueList);
        for (i = 0; i < rowList.size(); ++i) {
            int row_id = rowList.get(i);
            int column_id = columnList.get(i);
            int new_row_id = this.getMap_new(row_id);
            int new_column_id = this.getMap_new(column_id);
            double value = valueList.get(i);
            if (new_row_id <= -1 || new_column_id <= -1) continue;
            sMat.set(new_row_id, new_column_id, value);
            sMat.set(new_column_id, new_row_id, value);
        }
        return sMat;
    }

    public DoubleMatrix2D getNegSqrRoot(DoubleMatrix2D A) {
        DenseDoubleSingularValueDecomposition decomp = new DenseDoubleSingularValueDecomposition(A, true, true);
        DoubleMatrix2D U = decomp.getU();
        DoubleMatrix2D S = decomp.getS();
        DoubleMatrix2D V = decomp.getV();
        for (int i = 0; i < S.rows(); ++i) {
            S.set(i, i, Math.pow(S.get(i, i), 0.5));
        }
        DenseDoubleAlgebra alg = new DenseDoubleAlgebra();
        DoubleMatrix2D sqrtA = alg.mult(alg.mult(V, S), U);
        return alg.inverse(sqrtA);
    }

    public DoubleMatrix2D getNegSqrRootDMat(DoubleMatrix2D dMat) {
        for (int i = 0; i < dMat.rows(); ++i) {
            dMat.set(i, i, Math.pow(dMat.get(i, i), -0.5));
        }
        return dMat;
    }

    public DoubleMatrix2D getLMat(DoubleMatrix2D sMat) {
        DenseDoubleAlgebra alg = new DenseDoubleAlgebra();
        DoubleMatrix2D dMat = this.getDMat(sMat);
        DoubleMatrix2D transDMat = this.getNegSqrRootDMat(dMat);
        return alg.mult(transDMat, alg.mult(sMat, transDMat));
    }

    public DoubleMatrix2D getDMat(DoubleMatrix2D sMat) {
        DoubleMatrix2D dMat = sMat.like();
        for (int i = 0; i < sMat.rows(); ++i) {
            dMat.set(i, i, sMat.viewRow(i).zSum());
        }
        return dMat;
    }

    public int getK(DoubleMatrix1D eigenVal, double minLambda) {
        double prevLamb = this.round(eigenVal.get((int)eigenVal.size() - 1));
        int k = 1;
        while ((long)k < eigenVal.size()) {
            double nextLamb = this.round(eigenVal.get((int)eigenVal.size() - k - 1));
            System.out.println("k " + k + " PrevLamb " + prevLamb + " nextLamb " + nextLamb + " prevLamb/nextLamb " + prevLamb / nextLamb);
            if (nextLamb < minLambda || prevLamb / nextLamb > this.epsilon) break;
            prevLamb = nextLamb;
            ++k;
        }
        return k;
    }

    public DoubleMatrix2D getUMat(DoubleMatrix2D eigenVect, int k) {
        IntArrayList indexList = new IntArrayList();
        DoubleArrayList valueList = new DoubleArrayList();
        DoubleMatrix2D uMat = eigenVect.viewPart(0, eigenVect.columns() - k, eigenVect.rows(), k);
        for (int i = 0; i < uMat.columns(); ++i) {
            DoubleMatrix1D row = uMat.viewRow(i);
            double rowLength = Math.pow(row.zDotProduct(row), 0.5);
            row.getNonZeros(indexList, valueList);
            for (int j = 0; j < indexList.size(); ++j) {
                int index = indexList.get(j);
                double value = valueList.get(j) / rowLength;
                uMat.set(i, index, value);
            }
        }
        return uMat;
    }

    public void doKMeansClustering(DoubleMatrix2D uMat, DoubleMatrix2D sMat) {
        int k = uMat.columns();
        int[] clusterArray = new int[uMat.rows()];
        KCluster.kmeans(k, this.rnumber, uMat, clusterArray);
        clusterArray = this.redistributeMaxCluster(clusterArray, sMat, k);
        for (int cluster_id = 0; cluster_id < k; ++cluster_id) {
            NodeCluster iCluster = new NodeCluster();
            ArrayList<CyNode> node_list = new ArrayList<CyNode>();
            for (int j = 0; j < clusterArray.length; ++j) {
                if (clusterArray[j] != cluster_id) continue;
                node_list.add(this.nodes.get(this.getMap_old(j)));
            }
            iCluster = new NodeCluster((Collection<CyNode>)node_list);
            iCluster.setClusterNumber(this.clusterCount);
            this.clusterMap.put(new Integer(this.clusterCount), iCluster);
            System.out.println("Clustercount " + this.clusterCount + " cluster_id " + cluster_id + " node_list_length " + node_list.size());
            ++this.clusterCount;
        }
    }

    public int[] redistributeMaxCluster(int[] clusters, DoubleMatrix2D sMat, int k) {
        int i;
        int maxClusterID = -1;
        int maxClusterSize = -1;
        int maxClusterConnection = -1;
        double maxClusterConnectionSize = -1.0;
        IntArrayList indexList = new IntArrayList();
        DoubleArrayList valueList = new DoubleArrayList();
        int[] clusterSizeArray = new int[k];
        int[] redistribClusters = new int[clusters.length];
        double[] clusterConnectionCount = new double[k];
        for (i = 0; i < clusterSizeArray.length; ++i) {
            clusterSizeArray[i] = 0;
        }
        for (i = 0; i < clusters.length; ++i) {
            int clusterID;
            int n = clusterID = clusters[i];
            clusterSizeArray[n] = clusterSizeArray[n] + 1;
        }
        for (i = 0; i < clusterSizeArray.length; ++i) {
            int clusterSize = clusterSizeArray[i];
            if (clusterSize <= maxClusterSize) continue;
            maxClusterSize = clusterSize;
            maxClusterID = i;
        }
        while (true) {
            int i2;
            int transfer_count = 0;
            for (i2 = 0; i2 < clusters.length; ++i2) {
                int j;
                if (clusters[i2] != maxClusterID) {
                    redistribClusters[i2] = clusters[i2];
                    continue;
                }
                for (int j2 = 0; j2 < k; ++j2) {
                    clusterConnectionCount[j2] = 0.0;
                }
                maxClusterConnection = -1;
                maxClusterConnectionSize = -1.0;
                DoubleMatrix1D row = sMat.viewRow(i2);
                row.getNonZeros(indexList, valueList);
                for (j = 0; j < indexList.size(); ++j) {
                    int connectingNodeCluster;
                    int connectingNode = indexList.get(j);
                    int n = connectingNodeCluster = clusters[connectingNode];
                    clusterConnectionCount[n] = clusterConnectionCount[n] + valueList.get(j);
                }
                for (j = 0; j < k; ++j) {
                    double avgConnectionSize = clusterConnectionCount[j] / (double)(clusterSizeArray[j] + 1);
                    if (!(maxClusterConnectionSize < avgConnectionSize)) continue;
                    maxClusterConnectionSize = avgConnectionSize;
                    maxClusterConnection = j;
                }
                redistribClusters[i2] = maxClusterConnection;
                if (clusters[i2] == redistribClusters[i2]) continue;
                ++transfer_count;
                System.out.println("Node " + i2 + " moved from " + clusters[i2] + " to " + redistribClusters[i2]);
            }
            if (transfer_count <= 0) break;
            for (i2 = 0; i2 < clusters.length; ++i2) {
                if (clusters[i2] == redistribClusters[i2]) continue;
                int clusterID = redistribClusters[i2];
                int n = maxClusterID;
                clusterSizeArray[n] = clusterSizeArray[n] - 1;
                int n2 = clusterID;
                clusterSizeArray[n2] = clusterSizeArray[n2] + 1;
                clusters[i2] = redistribClusters[i2];
            }
            System.out.println("Transfer Count " + transfer_count + " MaxClusterSize " + clusterSizeArray[maxClusterID]);
        }
        return redistribClusters;
    }

    public void doComponentClustering() {
        Map<Integer, List<CyNode>> cMap = this.distanceMatrix.findConnectedComponents();
        Iterator<List<CyNode>> it = cMap.values().iterator();
        boolean component_size_sum = false;
        while (it.hasNext()) {
            List<CyNode> component = it.next();
            if (component.size() <= 5) continue;
            NodeCluster iCluster = new NodeCluster((Collection<CyNode>)component);
            iCluster.setClusterNumber(this.clusterCount);
            this.clusterMap.put(new Integer(this.clusterCount), iCluster);
            ++this.clusterCount;
        }
    }

    public double round(double d) {
        int precision = 100;
        return Math.floor(d * (double)precision + 0.5) / (double)precision;
    }

    private class Normalize
    implements IntIntDoubleFunction {
        private double maxValue;
        private double minValue;
        private double span;
        private double factor;
        private double minWeight = Double.MAX_VALUE;

        public Normalize(double minValue, double maxValue, double factor) {
            this.maxValue = maxValue;
            this.minValue = minValue;
            this.factor = factor;
            this.span = maxValue - minValue;
        }

        public double apply(int row, int column, double value) {
            return (value - this.minWeight) / this.span * this.factor;
        }
    }
}

