/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.DistanceMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.dataTypes.Edges;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.iterativeclustering.IteratorThread;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunTransClust {
    private List<CyNode> nodes;
    private boolean canceled = false;
    protected int clusterCount = 0;
    private DistanceMatrix distanceMatrix = null;
    private double threshold;

    public RunTransClust(DistanceMatrix dMat, double threshold, TaskMonitor monitor) {
        this.distanceMatrix = dMat;
        this.threshold = threshold;
    }

    public void cancel() {
        this.canceled = true;
    }

    public List<NodeCluster> run(TaskMonitor monitor, CyNetwork network) {
        DoubleMatrix2D matrix = this.distanceMatrix.getDistanceMatrix(this.threshold, true);
        this.nodes = this.distanceMatrix.getNodes();
        HashMap<String, CyNode> nodeHash = new HashMap<String, CyNode>();
        for (CyNode node : this.nodes) {
            nodeHash.put(ModelUtils.getNodeName(network, node), node);
        }
        HashMap<String, Integer> integers2proteins = new HashMap<String, Integer>();
        HashMap<Integer, String> proteins2integers = new HashMap<Integer, String>();
        int count = 0;
        for (CyNode node : this.nodes) {
            integers2proteins.put(ModelUtils.getNodeName(network, node), count);
            proteins2integers.put(count, ModelUtils.getNodeName(network, node));
            ++count;
        }
        Edges es = new Edges(this.nodes.size() * this.nodes.size(), this.nodes.size());
        count = 0;
        for (int i = 0; i < this.nodes.size(); ++i) {
            CyNode cyNodeI = this.nodes.get(i);
            es.startPositions[((Integer)integers2proteins.get((Object)cyNodeI.getSUID())).intValue()] = count;
            for (int j = 0; j < this.nodes.size(); ++j) {
                CyNode cyNodeJ = this.nodes.get(j);
                es.sources[count] = i;
                es.targets[count] = j;
                es.values[count] = (float)this.distanceMatrix.getEdgeValueFromMatrix(i, j);
                ++count;
            }
            es.endPositions[integers2proteins.get((Object)cyNodeI.getSUID()).intValue()] = count - 1;
        }
        Semaphore s = new Semaphore(1);
        TaskConfig.mode = 2;
        TaskConfig.monitor = monitor;
        IteratorThread it = new IteratorThread(es, integers2proteins, proteins2integers, s);
        TaskConfig.minThreshold = this.threshold;
        TaskConfig.maxThreshold = this.threshold;
        try {
            s.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        it.start();
        monitor.showMessage(TaskMonitor.Level.INFO, "Executing TransClust Clustering...");
        try {
            s.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        monitor.showMessage(TaskMonitor.Level.INFO, "Assigning nodes to clusters");
        String result = it.resultsStringBuffer.toString();
        String[] clusters = result.split("\t")[2].split(";");
        Map<Integer, NodeCluster> clusterMap = this.getClusterMap(clusters, nodeHash);
        monitor.showMessage(TaskMonitor.Level.INFO, "Created " + clusterMap.size() + " clusters");
        if (this.clusterCount == 0) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Created 0 clusters!!!!");
            return null;
        }
        int clusterNumber = 1;
        HashMap<NodeCluster, NodeCluster> cMap = new HashMap<NodeCluster, NodeCluster>();
        for (NodeCluster cluster2 : NodeCluster.sortMap(clusterMap)) {
            if (cMap.containsKey(cluster2)) continue;
            cMap.put(cluster2, cluster2);
            cluster2.setClusterNumber(clusterNumber);
            ++clusterNumber;
        }
        Set clusters2 = cMap.keySet();
        return new ArrayList<NodeCluster>(clusters2);
    }

    private Map<Integer, NodeCluster> getClusterMap(String[] clusters, HashMap<String, CyNode> nodeHash) {
        HashMap<Integer, NodeCluster> clusterMap = new HashMap<Integer, NodeCluster>();
        for (int i = 0; i < clusters.length; ++i) {
            String[] elements = clusters[i].split(",");
            NodeCluster nc = new NodeCluster();
            for (int j = 0; j < elements.length; ++j) {
                if (!nodeHash.containsKey(elements[j].trim())) continue;
                nc.add(nodeHash.get(elements[j].trim()));
            }
            ++this.clusterCount;
            this.updateClusters(nc, clusterMap);
        }
        return clusterMap;
    }

    private void updateClusters(NodeCluster cluster2, Map<Integer, NodeCluster> clusterMap) {
        for (CyNode node : cluster2) {
            clusterMap.put(this.nodes.indexOf(node), cluster2);
        }
    }
}

