/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AbstractClusterResults;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.DistanceMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AbstractNetworkClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.RunTransClust;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.TransClusterContext;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterViz;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.NewNetworkView;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.TunableUIHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransClustCluster
extends AbstractNetworkClusterer {
    private List<CyNode> nodes;
    public static String SHORTNAME = "transclust";
    public static String NAME = "Transitivity Clustering";
    public static final String GROUP_ATTRIBUTE = "__TransClustGroups.SUID";
    private static final long serialVersionUID = 1L;
    private RunTransClust runTransClust;
    @Tunable(description="Network to cluster", context="nogui")
    public CyNetwork network = null;
    @ContainsTunables
    public TransClusterContext context = null;

    public TransClustCluster(TransClusterContext context, ClusterManager manager) {
        super(manager);
        this.context = context;
        if (this.network == null) {
            this.network = this.clusterManager.getNetwork();
        }
        context.setNetwork(this.network);
    }

    @Override
    public String getShortName() {
        return SHORTNAME;
    }

    @Override
    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    public ClusterViz getVisualizer() {
        return null;
    }

    public void updateSettings() {
        try {
            TaskConfig.fixedParameterMax = new Integer(this.context.maxSubclusterSize);
        }
        catch (Exception e) {
            TaskConfig.fixedParameterMax = 20;
        }
        try {
            TaskConfig.fpMaxTimeMillis = new Integer(this.context.maxTime) * 1000;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!this.context.mergeSimilar) {
            TaskConfig.upperBound = Float.MAX_VALUE;
        }
        try {
            TaskConfig.upperBound = this.context.mergeSimilar ? new Float(this.context.mergeThreshold).floatValue() : Float.MAX_VALUE;
        }
        catch (Exception e) {
            TaskConfig.upperBound = Float.MAX_VALUE;
        }
        TaskConfig.maxNoThreads = this.context.processors;
    }

    public void run(TaskMonitor monitor) {
        DistanceMatrix matrix;
        monitor.setTitle("Performing Transitivity clustering");
        this.monitor = monitor;
        if (this.network == null) {
            this.network = this.clusterManager.getNetwork();
        }
        if ((matrix = this.context.edgeAttributeHandler.getMatrix()) == null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Can't get distance matrix: no attribute value?");
            return;
        }
        this.updateSettings();
        this.runTransClust = new RunTransClust(matrix, (Double)this.context.edgeAttributeHandler.edgeCutOff.getValue(), monitor);
        if (this.canceled) {
            return;
        }
        monitor.showMessage(TaskMonitor.Level.INFO, "Clustering...");
        this.createGroups = this.context.advancedAttributes.createGroups;
        List<NodeCluster> clusters = this.runTransClust.run(monitor, this.network);
        if (clusters == null) {
            return;
        }
        monitor.showMessage(TaskMonitor.Level.INFO, "Removing groups");
        this.removeGroups(this.network, GROUP_ATTRIBUTE);
        monitor.showMessage(TaskMonitor.Level.INFO, "Creating groups");
        this.params = new ArrayList();
        this.context.edgeAttributeHandler.setParams(this.params);
        List<List<CyNode>> nodeClusters = this.createGroups(this.network, clusters, GROUP_ATTRIBUTE);
        this.results = new AbstractClusterResults(this.network, nodeClusters);
        monitor.setStatusMessage("Done.  TransClust results:\n" + this.results);
        if (this.context.vizProperties.showUI) {
            monitor.showMessage(TaskMonitor.Level.INFO, "Creating network");
            this.insertTasksAfterCurrentTask(new Task[]{new NewNetworkView(this.network, this.clusterManager, true, this.context.vizProperties.restoreEdges)});
        }
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.runTransClust.cancel();
    }

    public void setParams(List<String> params) {
        params.add("mergeSimilar=" + this.context.mergeSimilar);
        params.add("mergeThreshold=" + this.context.mergeThreshold);
        params.add("maxSubclusterSize=" + this.context.maxSubclusterSize);
        params.add("maxTime=" + this.context.maxTime);
    }

    @Override
    public void setUIHelper(TunableUIHelper helper) {
        this.context.setUIHelper(helper);
    }
}

