/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.main;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.main.ArgsParseException;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Args {
    String[] args;
    String optionIndicator = "-";
    Hashtable<String, String> options = new Hashtable();

    public Args(String[] args) {
        this.args = args;
    }

    public Args(String[] args, String optionIndicator) throws ArgsParseException {
        this(args);
        this.optionIndicator = optionIndicator;
        this.makeOptionsHash();
    }

    public void makeOptionsHash() throws ArgsParseException {
        for (int i = 0; i < this.args.length; ++i) {
            if (!this.args[i].startsWith(this.optionIndicator)) continue;
            String key = this.args[i].substring(this.optionIndicator.length());
            try {
                String value = this.args[i + 1];
                if (value.startsWith(this.optionIndicator)) {
                    throw new ArgsParseException("Value " + value + " invalid for parameter " + key + ".");
                }
                this.options.put(key, this.args[i + 1]);
                ++i;
                continue;
            }
            catch (Exception e) {
                this.options.put(key, "");
            }
        }
    }

    public String getStringValue(String key) throws ArgsParseException {
        String value = this.options.get(key);
        if (value == null) {
            throw new ArgsParseException("Key " + key + " unknown.");
        }
        return value;
    }

    public int getIntValue(String key) throws ArgsParseException {
        String value = this.options.get(key);
        if (value == null) {
            throw new ArgsParseException("Key " + key + " unknown.");
        }
        return Integer.parseInt(value);
    }

    public double getDoubleValue(String key) throws ArgsParseException {
        String value = this.options.get(key);
        if (value == null) {
            throw new ArgsParseException("Key " + key + " unknown.");
        }
        return Double.parseDouble(value);
    }

    public float getFloatValue(String key) throws ArgsParseException {
        String value = this.options.get(key);
        if (value == null) {
            throw new ArgsParseException("Key " + key + " unknown.");
        }
        return Float.parseFloat(value);
    }

    public boolean getBoolValue(String key) throws ArgsParseException {
        String value = this.options.get(key);
        if (value == null) {
            throw new ArgsParseException("Key " + key + " unknown.");
        }
        return Boolean.parseBoolean(value);
    }

    public Hashtable<String, String> getOptions() {
        return this.options;
    }
}

