/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ICCEdges;

public class CC2DArray
implements ICCEdges {
    private float[][] edgeCostArray;
    private float maxFromNormalisation;
    private float minFromNormalisation;
    private double l;
    private double r;
    private double minFromNormalisationWithThreshold;
    private double maxFromNormalisationWithThreshold;

    public CC2DArray(int size) {
        this.initCCEdges(size);
    }

    public CC2DArray clone() {
        CC2DArray clone = new CC2DArray(this.edgeCostArray.length);
        clone.l = this.l;
        clone.r = this.r;
        clone.minFromNormalisation = this.minFromNormalisation;
        clone.maxFromNormalisation = this.maxFromNormalisation;
        clone.minFromNormalisationWithThreshold = this.minFromNormalisationWithThreshold;
        clone.maxFromNormalisationWithThreshold = this.maxFromNormalisationWithThreshold;
        clone.edgeCostArray = (float[][])this.edgeCostArray.clone();
        return clone;
    }

    public void initCCEdges(int size) {
        this.edgeCostArray = new float[size][size];
    }

    public void setEdgeCost(int node_i, int node_j, float cost) {
        this.edgeCostArray[node_i][node_j] = cost;
        this.edgeCostArray[node_j][node_i] = cost;
    }

    public float getEdgeCost(int node_i, int node_j) {
        return this.edgeCostArray[node_i][node_j];
    }

    public void normalise() {
        int j;
        int i;
        if (this.edgeCostArray.length < 2) {
            return;
        }
        float min = this.edgeCostArray[0][1];
        float max = this.edgeCostArray[0][1];
        for (i = 0; i < this.edgeCostArray.length; ++i) {
            for (j = i + 1; j < this.edgeCostArray[i].length; ++j) {
                if (Math.abs(this.edgeCostArray[i][j]) > max) {
                    max = Math.abs(this.edgeCostArray[i][j]);
                }
                if (!(this.edgeCostArray[i][j] < min)) continue;
                min = this.edgeCostArray[i][j];
            }
        }
        this.maxFromNormalisation = max;
        this.minFromNormalisation = min;
        if (max == 0.0f) {
            return;
        }
        for (i = 0; i < this.edgeCostArray.length; ++i) {
            for (j = i + 1; j < this.edgeCostArray[i].length; ++j) {
                if (this.edgeCostArray[i][j] > 0.0f) {
                    float f = this.edgeCostArray[i][j] / max;
                    this.edgeCostArray[j][i] = f;
                    this.edgeCostArray[i][j] = f;
                    continue;
                }
                float f = this.edgeCostArray[i][j] / max;
                this.edgeCostArray[j][i] = f;
                this.edgeCostArray[i][j] = f;
            }
        }
    }

    public void normaliseWithThreshold(double alpha) {
        int j;
        int i;
        if (this.edgeCostArray.length < 2) {
            return;
        }
        float min = this.edgeCostArray[0][1];
        float max = this.edgeCostArray[0][1];
        for (i = 0; i < this.edgeCostArray.length; ++i) {
            for (j = 0; j < this.edgeCostArray[i].length; ++j) {
                if (i == j) continue;
                if (this.edgeCostArray[i][j] > max) {
                    max = this.edgeCostArray[i][j];
                }
                if (!(this.edgeCostArray[i][j] < min)) continue;
                min = this.edgeCostArray[i][j];
            }
        }
        this.maxFromNormalisationWithThreshold = max;
        this.minFromNormalisationWithThreshold = min;
        if (Math.abs(min) < Math.abs(max)) {
            this.l = -alpha * (double)Math.abs(min) / (double)max;
            this.r = 1.0;
        } else {
            this.l = -1.0;
            this.r = alpha * (double)max / (double)Math.abs(min);
        }
        for (i = 0; i < this.edgeCostArray.length; ++i) {
            for (j = 0; j < this.edgeCostArray[i].length; ++j) {
                this.edgeCostArray[i][j] = this.edgeCostArray[i][j] > 0.0f ? (float)this.r * this.edgeCostArray[i][j] / max : (float)this.l * this.edgeCostArray[i][j] / min;
            }
        }
    }

    public void denormalise() {
        for (int i = 0; i < this.edgeCostArray.length; ++i) {
            for (int j = i + 1; j < this.edgeCostArray[i].length; ++j) {
                if (this.edgeCostArray[i][j] > 0.0f) {
                    float f = this.edgeCostArray[i][j] * this.maxFromNormalisation;
                    this.edgeCostArray[j][i] = f;
                    this.edgeCostArray[i][j] = f;
                    continue;
                }
                float f = this.edgeCostArray[i][j] * this.maxFromNormalisation;
                this.edgeCostArray[j][i] = f;
                this.edgeCostArray[i][j] = f;
            }
        }
    }

    public void denormaliseWithThreshold() {
        for (int i = 0; i < this.edgeCostArray.length; ++i) {
            for (int j = 0; j < this.edgeCostArray[i].length; ++j) {
                this.edgeCostArray[i][j] = this.edgeCostArray[i][j] > 0.0f ? (float)((double)this.edgeCostArray[i][j] / this.r * this.maxFromNormalisationWithThreshold) : (float)((double)this.edgeCostArray[i][j] / this.l * this.minFromNormalisationWithThreshold);
            }
        }
    }
}

