/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.geometric_clustering;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ICCEdges;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.geometric_clustering.GeometricClusteringConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.geometric_clustering.IGeometricClusterer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KmeansClusterer
implements IGeometricClusterer {
    private ConnectedComponent cc;
    private int maxK;
    private int bestK;
    private double bestCosts;
    private int[] bestCluster;
    private double[] center;
    private double span;
    private int maxRuns;
    private int initMethod = 3;
    private int[] listOfElementsSortedByCosts;

    @Override
    public void initGeometricClusterer(ConnectedComponent cc) {
        this.cc = cc;
        this.maxK = cc.getNodeNumber();
        if (this.maxK > GeometricClusteringConfig.kLimit) {
            this.maxK = GeometricClusteringConfig.kLimit;
        }
        this.bestCosts = Double.MAX_VALUE;
        this.center = new double[cc.getCCPostions(0).length];
        this.span = this.calculateCenterAndSpan(cc.getCCPositions(), this.center);
        this.maxRuns = GeometricClusteringConfig.maxInitStartConfigs;
        this.listOfElementsSortedByCosts = new int[this.cc.getNodeNumber()];
    }

    @Override
    public void run() {
        int[] clusters = new int[this.cc.getNodeNumber()];
        for (int i = 1; i <= this.maxK; ++i) {
            double costs;
            this.kmeans(i, clusters);
            double bestCostWithK = costs = this.cc.calculateClusteringScore(clusters);
            for (int run = 0; run < this.maxRuns; ++run) {
                if (costs < this.bestCosts) {
                    this.bestCosts = costs;
                    this.bestK = i;
                    this.bestCluster = this.copyClusters(clusters);
                }
                this.kmeans(i, clusters);
                costs = this.cc.calculateClusteringScore(clusters);
                if (!(costs < bestCostWithK)) continue;
                bestCostWithK = costs;
            }
            if (bestCostWithK > this.bestCosts * this.bestCosts) break;
        }
        int numberOfCluster = this.bestK;
        this.cc.initialiseClusterInfo(numberOfCluster);
        this.cc.setClusteringScore(this.bestCosts);
        this.cc.setClusters(this.bestCluster);
        this.cc.calculateClusterDistribution();
    }

    private void kmeans(int k, int[] clusters) {
        double[][] nodePositions = this.cc.getCCPositions();
        double[][] seedPositions = new double[k][nodePositions[0].length];
        int[] clustersOld = this.copyClusters(clusters);
        clustersOld[0] = -1;
        if (this.initMethod == 0) {
            this.initializeSeedpositions(seedPositions, nodePositions);
        } else if (this.initMethod == 1) {
            this.initializeSeedpositionsInCenter(seedPositions, nodePositions);
        } else if (this.initMethod == 2) {
            this.initializeRandomSeedpositions(seedPositions, nodePositions);
        } else if (this.initMethod == 3) {
            this.initializeFixedSeedpositions(seedPositions, nodePositions);
        }
        while (!this.isClusterEqual(clusters, clustersOld)) {
            clustersOld = this.copyClusters(clusters);
            this.calculateClusters(seedPositions, clusters, nodePositions);
            this.calculateNewSeedPositions(seedPositions, clusters, nodePositions);
        }
    }

    private void generateSortedList() {
        ICCEdges icce = this.cc.getCCEdges();
        double[] costs = new double[this.cc.getNodeNumber()];
        for (int i = 0; i < this.cc.getNodeNumber(); ++i) {
            double cost = 0.0;
            for (int j = 0; j < this.cc.getNodeNumber(); ++j) {
                if (i == j) continue;
                cost += (double)icce.getEdgeCost(i, j);
            }
            costs[i] = cost;
        }
        double[] costsClone = Arrays.copyOf(costs, costs.length);
        Arrays.sort(costs);
        boolean[] already = new boolean[costs.length];
        for (int i = costs.length - 1; i >= 0; --i) {
            int position = 0;
            for (int j = 0; j < costsClone.length; ++j) {
                if (costs[i] != costsClone[j] || already[j]) continue;
                position = j;
                already[j] = true;
                break;
            }
            this.listOfElementsSortedByCosts[costs.length - 1 - i] = position;
        }
    }

    private void initializeFixedSeedpositions(double[][] seedPositions, double[][] nodePositions) {
        this.generateSortedList();
        seedPositions[0] = (double[])this.cc.getCCPostions(this.listOfElementsSortedByCosts[0]).clone();
        HashSet<Integer> already = new HashSet<Integer>();
        already.add(this.listOfElementsSortedByCosts[0]);
        for (int i = 1; i < seedPositions.length; ++i) {
            int next = this.findFarestElement(already);
            already.add(next);
            seedPositions[i] = (double[])this.cc.getCCPostions(next).clone();
        }
    }

    private int findFarestElement(HashSet<Integer> already) {
        float bestcosts = Float.MAX_VALUE;
        int best = -1;
        for (int i = 0; i < this.cc.getNodeNumber(); ++i) {
            if (already.contains(i)) continue;
            float costs = 0.0f;
            for (Integer j : already) {
                costs += this.cc.getCCEdges().getEdgeCost(i, j);
            }
            if (!(costs < bestcosts)) continue;
            bestcosts = costs;
            best = i;
        }
        return best;
    }

    private void initializeSeedpositions(double[][] seedPositions, double[][] nodePositions) {
        Hashtable<Integer, Boolean> h = new Hashtable<Integer, Boolean>();
        h.put(-1, true);
        Random r = new Random();
        for (int i = 0; i < seedPositions.length; ++i) {
            int number = -1;
            while (h.containsKey(number)) {
                number = r.nextInt(nodePositions.length);
            }
            h.put(number, true);
            seedPositions[i] = (double[])this.cc.getCCPostions(number).clone();
        }
    }

    private void initializeSeedpositionsInCenter(double[][] seedPositions, double[][] nodePositions) {
        Random r = new Random();
        for (int i = 0; i < seedPositions.length; ++i) {
            for (int j = 0; j < seedPositions[i].length; ++j) {
                double epsilon = r.nextDouble() / this.span;
                epsilon = r.nextDouble();
                boolean sigma = r.nextBoolean();
                seedPositions[i][j] = sigma ? this.center[j] + epsilon : this.center[j] - epsilon;
            }
        }
    }

    private void initializeRandomSeedpositions(double[][] seedPositions, double[][] nodePositions) {
        Random r = new Random();
        for (int i = 0; i < seedPositions.length; ++i) {
            for (int j = 0; j < seedPositions[i].length; ++j) {
                double epsilon = r.nextDouble() * (this.span / 2.0);
                epsilon = r.nextDouble();
                boolean sigma = r.nextBoolean();
                seedPositions[i][j] = sigma ? this.center[j] + epsilon : this.center[j] - epsilon;
            }
        }
    }

    private double calculateCenterAndSpan(double[][] nodePositions, double[] center) {
        int i;
        double span = 0.0;
        double[] min = new double[nodePositions[0].length];
        double[] max = new double[nodePositions[0].length];
        for (i = 0; i < max.length; ++i) {
            min[i] = Double.POSITIVE_INFINITY;
            max[i] = Double.NEGATIVE_INFINITY;
        }
        for (i = 0; i < nodePositions.length; ++i) {
            double[] position = nodePositions[i];
            for (int j = 0; j < position.length; ++j) {
                if (position[j] < min[j]) {
                    min[j] = position[j];
                }
                if (!(position[j] > max[j])) continue;
                max[j] = position[j];
            }
        }
        for (i = 0; i < center.length; ++i) {
            center[i] = (min[i] + max[i]) / 2.0;
        }
        span = Math.sqrt(this.calculateEuclidianDistance(min, max));
        return span;
    }

    private void calculateClusters(double[][] seedPositions, int[] clusters, double[][] nodePositions) {
        for (int i = 0; i < clusters.length; ++i) {
            double[] position = nodePositions[i];
            int bestSeed = -1;
            double bestDistance = Double.MAX_VALUE;
            for (int j = 0; j < seedPositions.length; ++j) {
                double[] seedPosition = seedPositions[j];
                double distance = this.calculateEuclidianDistance(position, seedPosition);
                if (!(distance < bestDistance)) continue;
                bestDistance = distance;
                bestSeed = j;
            }
            clusters[i] = bestSeed;
        }
    }

    private void calculateNewSeedPositions(double[][] seedPositions, int[] clusters, double[][] nodePositions) {
        int i;
        int[] clusterSizes = new int[seedPositions.length];
        for (i = 0; i < seedPositions.length; ++i) {
            seedPositions[i] = new double[nodePositions[0].length];
            for (int j = 0; j < seedPositions[i].length; ++j) {
                seedPositions[i][j] = 0.0;
            }
        }
        for (i = 0; i < clusters.length; ++i) {
            double[] position = nodePositions[i];
            int n = clusters[i];
            clusterSizes[n] = clusterSizes[n] + 1;
            seedPositions[clusters[i]] = this.positionAdd(position, seedPositions[clusters[i]]);
        }
        for (i = 0; i < seedPositions.length; ++i) {
            seedPositions[i] = this.dividePosition(seedPositions[i], clusterSizes[i]);
        }
    }

    private double[] dividePosition(double[] position, int divisor) {
        double[] resultingPosition = new double[position.length];
        for (int i = 0; i < resultingPosition.length; ++i) {
            resultingPosition[i] = position[i] / (double)divisor;
        }
        return resultingPosition;
    }

    private double[] positionAdd(double[] position1, double[] position2) {
        double[] resultingPosition = new double[position1.length];
        for (int i = 0; i < resultingPosition.length; ++i) {
            resultingPosition[i] = position1[i] + position2[i];
        }
        return resultingPosition;
    }

    private boolean isClusterEqual(int[] clusters1, int[] clusters2) {
        for (int i = 0; i < clusters2.length; ++i) {
            if (clusters1[i] == clusters2[i]) continue;
            return false;
        }
        return true;
    }

    private int[] copyClusters(int[] clusters) {
        int[] clustersCopy = new int[clusters.length];
        for (int i = 0; i < clustersCopy.length; ++i) {
            clustersCopy[i] = clusters[i];
        }
        return clustersCopy;
    }

    private double calculateEuclidianDistance(double[] node1, double[] node2) {
        double euclidianDistance = 0.0;
        for (int i = 0; i < node1.length; ++i) {
            euclidianDistance += (node1[i] - node2[i]) * (node1[i] - node2[i]);
        }
        return euclidianDistance;
    }
}

