/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.iterativeclustering;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.clusteranalysis.Fmeassure;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.dataTypes.Edges;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.main.ArgsParseException;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.main.InOut;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.costmatrixcreation.main.Splitter;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ICCEdges;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.ClusteringManager;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.InvalidInputFileException;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.InvalidTypeException;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorThread
extends Thread {
    private float upperBound;
    private Edges es;
    private HashMap<Integer, String> proteins2integers;
    private HashMap<String, Integer> integers2proteins;
    public StringBuffer resultsStringBuffer;
    public double dummyCosts = 0.0;
    private Semaphore s;

    public IteratorThread(float upperBound) {
        this.upperBound = upperBound;
    }

    public IteratorThread() {
        this.upperBound = TaskConfig.upperBound;
    }

    public IteratorThread(Edges es, HashMap<String, Integer> integers2proteins, HashMap<Integer, String> proteins2integers, Semaphore s) {
        this.upperBound = TaskConfig.upperBound;
        this.es = es;
        this.proteins2integers = proteins2integers;
        this.integers2proteins = integers2proteins;
        this.s = s;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void rearrange(Hashtable<String, Hashtable<String, Boolean>> clusters, Edges es, HashMap<String, Integer> integers2proteins) {
        for (String key1 : clusters.keySet()) {
            Hashtable<String, Boolean> cluster1 = clusters.get(key1);
            for (String id : cluster1.keySet()) {
                double costs = 0.0;
                for (String id2 : cluster1.keySet()) {
                    if (id.equals(id2)) continue;
                    costs += (double)InOut.getEdgeValue(integers2proteins.get(id), integers2proteins.get(id2), es);
                }
                for (String key2 : clusters.keySet()) {
                    if (key1.equals(key2)) continue;
                    Hashtable<String, Boolean> cluster2 = clusters.get(key2);
                    double sum = costs;
                    for (String id2 : cluster2.keySet()) {
                        sum -= (double)InOut.getEdgeValue(integers2proteins.get(id), integers2proteins.get(id2), es);
                    }
                    if (!(sum < 0.0)) continue;
                    this.dummyCosts += sum;
                    cluster1.remove(id);
                    cluster2.put(id, true);
                    this.rearrange(clusters, es, integers2proteins);
                    return;
                }
            }
        }
    }

    private void merge(Hashtable<String, Hashtable<String, Boolean>> clusters, Edges es, HashMap<String, Integer> integers2proteins, double threshold) {
        while (clusters.size() > TaskConfig.limitK) {
            int i = 0;
            double bestCosts = Double.NEGATIVE_INFINITY;
            Hashtable<Object, Object> bestcluster1 = new Hashtable();
            Hashtable<Object, Object> bestcluster2 = new Hashtable();
            String deleteKey = "";
            for (String key : clusters.keySet()) {
                Hashtable<String, Boolean> cluster1 = clusters.get(key);
                int j = 0;
                Iterator<String> iterator2 = clusters.keySet().iterator();
                while (iterator2.hasNext()) {
                    if (i >= j) {
                        ++j;
                        continue;
                    }
                    String key2 = iterator2.next();
                    if (key.equals(key2)) continue;
                    Hashtable<String, Boolean> cluster2 = clusters.get(key2);
                    double costs = this.calculateCosts(cluster1, cluster2, es, integers2proteins, threshold);
                    if (costs > bestCosts) {
                        bestCosts = costs;
                        bestcluster1 = cluster1;
                        bestcluster2 = cluster2;
                        deleteKey = key2;
                    }
                    ++j;
                }
                ++i;
            }
            this.dummyCosts -= bestCosts;
            bestcluster1.putAll(bestcluster2);
            clusters.remove(deleteKey);
        }
    }

    private double calculateCosts(Hashtable<String, Boolean> cluster1, Hashtable<String, Boolean> cluster2, Edges es, HashMap<String, Integer> integers2proteins, double threshold) {
        double costs = 0.0;
        for (String id1 : cluster1.keySet()) {
            for (String id2 : cluster2.keySet()) {
                costs += (double)InOut.getEdgeValue(integers2proteins.get(id1), integers2proteins.get(id2), es) - threshold;
            }
        }
        return costs;
    }

    private Hashtable<String, Hashtable<String, Boolean>> calculateHierarichal2(double threshold, BufferedWriter bw, Edges es, HashMap<Integer, String> proteins2integers, HashMap<String, Integer> integers2proteins, Hashtable<String, Hashtable<String, Boolean>> clusterReference, Hashtable<String, Hashtable<String, Boolean>> clusters, Hashtable<Integer, Vector<Integer>> mergedNodes, HashMap<String, String> referenceHash) throws IOException, InvalidInputFileException {
        Vector<ConnectedComponent> connectedComponents = new Vector<ConnectedComponent>();
        if (threshold == TaskConfig.maxThreshold) {
            Vector<Vector<Integer>> v = Splitter.splitIntoConnectedComponents(es, proteins2integers, (float)threshold, false);
            boolean[] already = new boolean[proteins2integers.size()];
            for (Vector<Integer> vector : v) {
                int count = 0;
                Vector<Integer> representants = new Vector<Integer>();
                for (int i = 0; i < vector.size(); ++i) {
                    if (already[vector.get(i)]) continue;
                    representants.add(vector.get(i));
                    Vector<Integer> v2 = mergedNodes.get(vector.get(i));
                    for (int j = 0; j < v2.size(); ++j) {
                        already[v2.get((int)j).intValue()] = true;
                    }
                    ++count;
                }
                ICCEdges cc2d2 = TaskConfig.ccEdgesEnum.createCCEdges(count);
                Object[] ids = new String[count];
                Arrays.fill(ids, "");
                for (int i = 0; i < representants.size(); ++i) {
                    int j;
                    Vector<Integer> merged1 = mergedNodes.get(representants.get(i));
                    for (j = 0; j < merged1.size(); ++j) {
                        if (j == 0) {
                            int n = i;
                            ids[n] = (String)ids[n] + proteins2integers.get(merged1.get(j));
                            continue;
                        }
                        int n = i;
                        ids[n] = (String)ids[n] + "," + proteins2integers.get(merged1.get(j));
                    }
                    for (j = i + 1; j < representants.size(); ++j) {
                        Vector<Integer> merged2 = mergedNodes.get(representants.get(j));
                        float costs = 0.0f;
                        for (int k = 0; k < merged1.size(); ++k) {
                            for (int k2 = 0; k2 < merged2.size(); ++k2) {
                                costs += (float)((double)InOut.getEdgeValue(merged1.get(k), merged2.get(k2), es) - threshold);
                            }
                        }
                        cc2d2.setEdgeCost(i, j, costs);
                    }
                }
                ConnectedComponent cc = new ConnectedComponent(cc2d2, (String[])ids, null);
                connectedComponents.add(cc);
            }
        } else {
            Vector mergableNodes = new Vector();
            for (String key : clusters.keySet()) {
                Hashtable<String, Boolean> h = clusters.get(key);
                Vector<Integer> v = new Vector<Integer>();
                for (String id : h.keySet()) {
                    v.add(integers2proteins.get(id));
                }
                mergableNodes.add(v);
            }
            mergedNodes = new Hashtable();
            for (int i = 0; i < mergableNodes.size(); ++i) {
                Vector v2 = (Vector)mergableNodes.get(i);
                for (int j = 0; j < v2.size(); ++j) {
                    mergedNodes.put((Integer)v2.get(j), v2);
                }
            }
            Vector<Vector<Integer>> v = Splitter.splitIntoConnectedComponents(es, proteins2integers, (float)threshold, false);
            boolean[] already = new boolean[proteins2integers.size()];
            for (Vector<Integer> vector : v) {
                int count = 0;
                Vector<Integer> representants = new Vector<Integer>();
                for (int i = 0; i < vector.size(); ++i) {
                    if (already[vector.get(i)]) continue;
                    representants.add(vector.get(i));
                    Vector<Integer> v2 = mergedNodes.get(vector.get(i));
                    for (int j = 0; j < v2.size(); ++j) {
                        already[v2.get((int)j).intValue()] = true;
                    }
                    ++count;
                }
                ICCEdges cc2d2 = TaskConfig.ccEdgesEnum.createCCEdges(count);
                Object[] ids = new String[count];
                Arrays.fill(ids, "");
                for (int i = 0; i < representants.size(); ++i) {
                    int j;
                    Vector<Integer> merged1 = mergedNodes.get(representants.get(i));
                    for (j = 0; j < merged1.size(); ++j) {
                        if (j == 0) {
                            int n = i;
                            ids[n] = (String)ids[n] + proteins2integers.get(merged1.get(j));
                            continue;
                        }
                        int n = i;
                        ids[n] = (String)ids[n] + "," + proteins2integers.get(merged1.get(j));
                    }
                    for (j = i + 1; j < representants.size(); ++j) {
                        Vector<Integer> merged2 = mergedNodes.get(representants.get(j));
                        float costs = 0.0f;
                        for (int k = 0; k < merged1.size(); ++k) {
                            for (int k2 = 0; k2 < merged2.size(); ++k2) {
                                costs += (float)((double)InOut.getEdgeValue(merged1.get(k), merged2.get(k2), es) - threshold);
                            }
                        }
                        cc2d2.setEdgeCost(i, j, costs);
                    }
                }
                ConnectedComponent cc = new ConnectedComponent(cc2d2, (String[])ids, null);
                connectedComponents.add(cc);
            }
        }
        clusters = new Hashtable();
        ClusteringManager cm = new ClusteringManager(null);
        ArrayList<Semaphore> allSemaphores = new ArrayList<Semaphore>();
        Semaphore maxThreadSemaphore = new Semaphore(TaskConfig.maxNoThreads, true);
        for (int i = 0; i < connectedComponents.size(); ++i) {
            Semaphore semaphore = new Semaphore(1);
            allSemaphores.add(semaphore);
            cm.runClusteringForOneConnectedComponent((ConnectedComponent)connectedComponents.get(i), null, semaphore, maxThreadSemaphore, System.currentTimeMillis());
            int[] elements2cluster = ((ConnectedComponent)connectedComponents.get(i)).getClusters();
            for (int j = 0; j < ((ConnectedComponent)connectedComponents.get(i)).getNumberOfClusters(); ++j) {
                Hashtable<String, Boolean> cluster2 = new Hashtable<String, Boolean>();
                for (int k = 0; k < elements2cluster.length; ++k) {
                    if (elements2cluster[k] != j) continue;
                    String[] ids = ((ConnectedComponent)connectedComponents.get(i)).getObjectID(k).split(",");
                    for (int l = 0; l < ids.length; ++l) {
                        cluster2.put(ids[l], true);
                    }
                }
                clusters.put(new Random().nextDouble() + "", cluster2);
            }
        }
        for (Semaphore s : allSemaphores) {
            try {
                s.acquire();
            }
            catch (InterruptedException e) {
                TaskConfig.monitor.showMessage(TaskMonitor.Level.ERROR, e.getMessage());
            }
        }
        Hashtable clustersCopy = (Hashtable)clusters.clone();
        if (TaskConfig.goldstandardPath != null) {
            ArrayList<String> dummyRemove2 = new ArrayList<String>();
            for (String key : clusters.keySet()) {
                Hashtable<String, Boolean> h = clusters.get(key);
                ArrayList<String> dummyRemove = new ArrayList<String>();
                for (String string : h.keySet()) {
                    if (referenceHash.containsKey(string)) continue;
                    dummyRemove.add(string);
                }
                for (String string : dummyRemove) {
                    h.remove(string);
                }
                if (!h.isEmpty()) continue;
                dummyRemove2.add(key);
            }
            for (String string : dummyRemove2) {
                clustersCopy.remove(string);
            }
        }
        bw.write(threshold + "\t");
        if (clusterReference != null) {
            double fmeasure = Fmeassure.fMeassure(clusterReference, clustersCopy);
            bw.write(fmeasure + "\t");
            TaskConfig.monitor.setStatusMessage("fmeasure: " + fmeasure);
        } else {
            bw.write("-\t");
        }
        int[] distribution = new int[1000000];
        int max = 1;
        boolean first = true;
        Vector keysToRemove = new Vector();
        for (String key : clusters.keySet()) {
            Hashtable<String, Boolean> h = clusters.get(key);
            if (!first) {
                bw.write(";");
            }
            first = true;
            for (String id : h.keySet()) {
                if (first) {
                    first = false;
                    bw.write(id);
                    continue;
                }
                bw.write("," + id);
            }
            int n = h.size();
            distribution[n] = distribution[n] + 1;
            if (h.size() <= max) continue;
            max = h.size();
        }
        StringBuffer sb = new StringBuffer("cluster distribution: ");
        for (int i = max; i >= 0; --i) {
            if (distribution[i] <= 0) continue;
            sb.append(i + ":" + distribution[i] + ", ");
        }
        TaskConfig.monitor.setStatusMessage(sb.toString());
        TaskConfig.monitor.setStatusMessage("");
        bw.newLine();
        mergedNodes.clear();
        for (String key : clusters.keySet()) {
            Hashtable<String, Boolean> currentCluster = clusters.get(key);
            Vector<Integer> currentClusterVector = new Vector<Integer>();
            for (String id : currentCluster.keySet()) {
                currentClusterVector.add(integers2proteins.get(id));
            }
            for (Integer integer : currentClusterVector) {
                mergedNodes.put(integer, currentClusterVector);
            }
        }
        return clusters;
    }

    public static Hashtable<String, Hashtable<String, Boolean>> readGoldStandardFile() throws IOException {
        String line;
        Hashtable<String, Hashtable<String, Boolean>> clusters = new Hashtable<String, Hashtable<String, Boolean>>();
        BufferedReader br = new BufferedReader(new FileReader(TaskConfig.goldstandardPath));
        String currentCluster = null;
        while ((line = br.readLine()) != null) {
            Hashtable<String, Boolean> h;
            if (line.trim().equals("")) continue;
            String[] tabs = line.split("\t");
            if (currentCluster == null) {
                h = new Hashtable<String, Boolean>();
                h.put(tabs[0], true);
                currentCluster = tabs[1];
                clusters.put(tabs[1], h);
                continue;
            }
            if (clusters.containsKey(tabs[1])) {
                clusters.get(tabs[1]).put(tabs[0], true);
                continue;
            }
            h = new Hashtable();
            h.put(tabs[0], true);
            currentCluster = tabs[1];
            clusters.put(tabs[1], h);
        }
        return clusters;
    }

    private Hashtable<String, Hashtable<String, Boolean>> readGoldStandardFile(String file) throws IOException {
        String line;
        Hashtable<String, Hashtable<String, Boolean>> clusters = new Hashtable<String, Hashtable<String, Boolean>>();
        BufferedReader br = new BufferedReader(new FileReader(file));
        String currentCluster = null;
        while ((line = br.readLine()) != null) {
            Hashtable<String, Boolean> h;
            if (line.trim().equals("")) continue;
            String[] tabs = line.split("\t");
            if (currentCluster == null) {
                h = new Hashtable<String, Boolean>();
                h.put(tabs[0], true);
                currentCluster = tabs[1];
                clusters.put(tabs[1], h);
                continue;
            }
            if (clusters.containsKey(tabs[1])) {
                clusters.get(tabs[1]).put(tabs[0], true);
                continue;
            }
            h = new Hashtable();
            h.put(tabs[0], true);
            currentCluster = tabs[1];
            clusters.put(tabs[1], h);
        }
        return clusters;
    }

    private Hashtable<String, Hashtable<String, Boolean>> calculateHierarichal(double threshold, BufferedWriter bw, Edges es, HashMap<Integer, String> proteins2integers, HashMap<String, Integer> integers2proteins, Hashtable<String, Hashtable<String, Boolean>> clusterReference, Hashtable<String, Hashtable<String, Boolean>> clusters, Vector<String> singletons, Hashtable<Integer, Vector<Integer>> mergedNodes) throws IOException, ArgsParseException, InvalidInputFileException, InvalidTypeException {
        Vector<ConnectedComponent> connectedComponents = new Vector<ConnectedComponent>();
        if (threshold == TaskConfig.minThreshold) {
            Vector<Vector<Integer>> v = Splitter.splitIntoConnectedComponents(es, proteins2integers, (float)threshold, false);
            boolean[] already = new boolean[proteins2integers.size()];
            for (Vector<Integer> vector : v) {
                int count = 0;
                Vector<Integer> representants = new Vector<Integer>();
                for (int i = 0; i < vector.size(); ++i) {
                    if (already[vector.get(i)]) continue;
                    representants.add(vector.get(i));
                    Vector<Integer> v2 = mergedNodes.get(vector.get(i));
                    for (int j = 0; j < v2.size(); ++j) {
                        already[v2.get((int)j).intValue()] = true;
                    }
                    ++count;
                }
                ICCEdges cc2d2 = TaskConfig.ccEdgesEnum.createCCEdges(count);
                Object[] ids = new String[count];
                Arrays.fill(ids, "");
                for (int i = 0; i < representants.size(); ++i) {
                    int j;
                    Vector<Integer> merged1 = mergedNodes.get(representants.get(i));
                    for (j = 0; j < merged1.size(); ++j) {
                        if (j == 0) {
                            int n = i;
                            ids[n] = (String)ids[n] + proteins2integers.get(merged1.get(j));
                            continue;
                        }
                        int n = i;
                        ids[n] = (String)ids[n] + "," + proteins2integers.get(merged1.get(j));
                    }
                    for (j = i + 1; j < representants.size(); ++j) {
                        Vector<Integer> merged2 = mergedNodes.get(representants.get(j));
                        float costs = 0.0f;
                        for (int k = 0; k < merged1.size(); ++k) {
                            for (int k2 = 0; k2 < merged2.size(); ++k2) {
                                costs += (float)((double)InOut.getEdgeValue(merged1.get(k), merged2.get(k2), es) - threshold);
                            }
                        }
                        cc2d2.setEdgeCost(i, j, costs);
                    }
                }
                ConnectedComponent cc = new ConnectedComponent(cc2d2, (String[])ids, null);
                connectedComponents.add(cc);
            }
        } else {
            boolean[] already = new boolean[proteins2integers.size()];
            for (String key : clusters.keySet()) {
                Hashtable<String, Boolean> cluster2 = clusters.get(key);
                Vector<Integer> vector = new Vector<Integer>();
                for (String element : cluster2.keySet()) {
                    vector.add(integers2proteins.get(element));
                }
                int count = 0;
                Vector representants = new Vector();
                for (int i = 0; i < vector.size(); ++i) {
                    if (already[(Integer)vector.get(i)]) continue;
                    representants.add(vector.get(i));
                    Vector<Integer> v2 = mergedNodes.get(vector.get(i));
                    for (int j = 0; j < v2.size(); ++j) {
                        already[v2.get((int)j).intValue()] = true;
                    }
                    ++count;
                }
                ICCEdges cc2d2 = TaskConfig.ccEdgesEnum.createCCEdges(count);
                Object[] ids = new String[count];
                Arrays.fill(ids, "");
                for (int i = 0; i < representants.size(); ++i) {
                    int j;
                    Vector<Integer> merged1 = mergedNodes.get(representants.get(i));
                    for (j = 0; j < merged1.size(); ++j) {
                        if (j == 0) {
                            int n = i;
                            ids[n] = (String)ids[n] + proteins2integers.get(merged1.get(j));
                            continue;
                        }
                        int n = i;
                        ids[n] = (String)ids[n] + "," + proteins2integers.get(merged1.get(j));
                    }
                    for (j = i + 1; j < representants.size(); ++j) {
                        Vector<Integer> merged2 = mergedNodes.get(representants.get(j));
                        float costs = 0.0f;
                        for (int k = 0; k < merged1.size(); ++k) {
                            for (int k2 = 0; k2 < merged2.size(); ++k2) {
                                costs += (float)((double)InOut.getEdgeValue(merged1.get(k), merged2.get(k2), es) - threshold);
                            }
                        }
                        cc2d2.setEdgeCost(i, j, costs);
                    }
                }
                ConnectedComponent cc = new ConnectedComponent(cc2d2, (String[])ids, null);
                connectedComponents.add(cc);
            }
        }
        clusters = new Hashtable();
        ClusteringManager cm = new ClusteringManager(null);
        ArrayList<Semaphore> allSemaphores = new ArrayList<Semaphore>();
        Semaphore maxThreadSemaphore = new Semaphore(TaskConfig.maxNoThreads, true);
        for (int i = 0; i < connectedComponents.size(); ++i) {
            Semaphore semaphore = new Semaphore(1);
            allSemaphores.add(semaphore);
            cm.runClusteringForOneConnectedComponent((ConnectedComponent)connectedComponents.get(i), null, semaphore, maxThreadSemaphore, System.currentTimeMillis());
            int[] elements2cluster = ((ConnectedComponent)connectedComponents.get(i)).getClusters();
            for (int j = 0; j < ((ConnectedComponent)connectedComponents.get(i)).getNumberOfClusters(); ++j) {
                Hashtable<String, Boolean> cluster3 = new Hashtable<String, Boolean>();
                for (int k = 0; k < elements2cluster.length; ++k) {
                    if (elements2cluster[k] != j) continue;
                    String[] ids = ((ConnectedComponent)connectedComponents.get(i)).getObjectID(k).split(",");
                    for (int l = 0; l < ids.length; ++l) {
                        cluster3.put(ids[l], true);
                    }
                }
                clusters.put(new Random().nextDouble() + "", cluster3);
            }
        }
        for (Semaphore s : allSemaphores) {
            try {
                s.acquire();
            }
            catch (InterruptedException e) {
                TaskConfig.monitor.showMessage(TaskMonitor.Level.ERROR, e.getMessage());
            }
        }
        bw.write(threshold + "\t");
        if (clusterReference != null) {
            double fmeasure = Fmeassure.fMeassure(clusterReference, clusters);
            bw.write(fmeasure + "\t");
            TaskConfig.monitor.setStatusMessage("fmeasure: " + fmeasure);
        } else {
            bw.write("-\t");
        }
        int[] distribution = new int[1000000];
        int max = 1;
        boolean first = true;
        Vector<String> keysToRemove = new Vector<String>();
        for (String key : clusters.keySet()) {
            Hashtable<String, Boolean> h = clusters.get(key);
            if (!first) {
                bw.write(";");
            }
            if (h.size() == 1) {
                singletons.add(h.keySet().iterator().next());
                keysToRemove.add(key);
                continue;
            }
            first = true;
            for (String id : h.keySet()) {
                if (first) {
                    first = false;
                    bw.write(id);
                    continue;
                }
                bw.write("," + id);
            }
            int n = h.size();
            distribution[n] = distribution[n] + 1;
            if (h.size() <= max) continue;
            max = h.size();
        }
        for (String key : keysToRemove) {
            clusters.remove(key);
        }
        for (String id : singletons) {
            bw.write(";" + id);
        }
        distribution[1] = singletons.size();
        StringBuffer sb = new StringBuffer("cluster distribution: ");
        for (int i = max; i >= 0; --i) {
            if (distribution[i] <= 0) continue;
            sb.append(i + ":" + distribution[i] + ", ");
        }
        TaskConfig.monitor.setStatusMessage(sb.toString());
        TaskConfig.monitor.setStatusMessage("");
        bw.newLine();
        return clusters;
    }

    private void calculateOverlapping(Vector<Vector<Integer>> clustersVector, Edges es, double threshold, int[] overlaps) {
        for (Vector<Integer> cluster2 : clustersVector) {
            for (Integer id : cluster2) {
                if (overlaps[id] > 2) continue;
                for (Vector<Integer> cluster22 : clustersVector) {
                    if (cluster22.size() < 2 || cluster2 == cluster22 || cluster22.contains(id) || cluster2.size() == 1 || cluster22.size() == 1) continue;
                    double costs = 0.0;
                    for (Integer id2 : cluster22) {
                        if (id.equals(id2)) continue;
                        costs -= (double)InOut.getEdgeValue(id, id2, es) - threshold;
                    }
                    if (!(costs <= 0.0)) continue;
                    cluster22.add(id);
                    int n = id;
                    overlaps[n] = overlaps[n] + 1;
                    this.calculateOverlapping(clustersVector, es, threshold, overlaps);
                    return;
                }
            }
        }
    }
}

