/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.CC1DArray;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.CC2DArray;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.CCHash;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.CCSymmetricArray;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ICCEdges;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.ILayoutInitialiser;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.ILayouter;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.IParameters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.forcend.FORCEnDLayouter;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.forcend.FORCEnDParameters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.forcend.LayoutInitCirclesInPlanes;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.InvalidTypeException;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;

public class LayoutFactory {
    public static EnumLayouterClass[] getEnumArrayFromLayoutersString() throws InvalidTypeException {
        String[] inputLayouting = TaskConfig.layouterClasses.split("\\s*,\\s*");
        EnumLayouterClass[] allPossLayouters = EnumLayouterClass.values();
        EnumLayouterClass[] layouterEnumsInProcessingOrder = new EnumLayouterClass[inputLayouting.length];
        for (int i = 0; i < inputLayouting.length; ++i) {
            boolean layouterexists = false;
            for (EnumLayouterClass layclass : allPossLayouters) {
                if (!inputLayouting[i].equals(layclass.getClassname())) continue;
                layouterEnumsInProcessingOrder[i] = layclass;
                layouterexists = true;
            }
            if (layouterexists) continue;
            throw new InvalidTypeException("LayoutFactory: This layouting algorithm has not been implemented: " + inputLayouting[i]);
        }
        return layouterEnumsInProcessingOrder;
    }

    public static EnumCCEdgesStructure getCCEdgesEnumByClass(String className) throws InvalidTypeException {
        EnumCCEdgesStructure[] allPossStructureEnums;
        for (EnumCCEdgesStructure structure : allPossStructureEnums = EnumCCEdgesStructure.values()) {
            if (!className.equals(structure.getClassname())) continue;
            return structure;
        }
        throw new InvalidTypeException("LayoutFactory: This edges class has not yet been implemented: " + className + ".\nOr it has not been correctly bound into the program.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumCCEdgesStructure {
        CC2DARRAY("CC2DArray", 0),
        CCSYMMETRICARRAY("CCSymmetricArray", 1),
        CCHASH("CCHash", 2),
        CC1DARRAY("CC1DArray", 3);

        private final String classname;
        private final int intvalue;

        private EnumCCEdgesStructure(String classname, int intvalue) {
            this.classname = classname;
            this.intvalue = intvalue;
        }

        public String getClassname() {
            return this.classname;
        }

        public int getIntvalue() {
            return this.intvalue;
        }

        public ICCEdges createCCEdges(int size) {
            if (this.intvalue == 0) {
                return new CC2DArray(size);
            }
            if (this.intvalue == 1) {
                return new CCSymmetricArray(size);
            }
            if (this.intvalue == 2) {
                return new CCHash(size);
            }
            if (this.intvalue == 3) {
                return new CC1DArray(size);
            }
            return null;
        }

        public static String[] getClassnames() {
            EnumLayouterClass[] values = EnumLayouterClass.values();
            String[] classnames = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                classnames[i] = values[i].getClassname();
            }
            return classnames;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumLayouterClass {
        FORCEND("FORCEnDLayouter", 0),
        ACC("ACCLayouter", 1);

        private final String classname;
        private final int intvalue;

        private EnumLayouterClass(String classname, int intvalue) {
            this.classname = classname;
            this.intvalue = intvalue;
        }

        public String getClassname() {
            return this.classname;
        }

        public int getIntvalue() {
            return this.intvalue;
        }

        public ILayouter createLayouter() {
            if (this.intvalue == 0) {
                return new FORCEnDLayouter();
            }
            return null;
        }

        public IParameters createIParameters() {
            if (this.intvalue == 0) {
                return new FORCEnDParameters();
            }
            return null;
        }

        public ILayoutInitialiser createLayoutInitialiser() {
            if (this.intvalue == 0) {
                return new LayoutInitCirclesInPlanes();
            }
            return null;
        }

        public static String[] getClassnames() {
            EnumLayouterClass[] values = EnumLayouterClass.values();
            String[] classnames = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                classnames[i] = values[i].getClassname();
            }
            return classnames;
        }
    }
}

