/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.forcend;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;

public class DisplacementCalculator
implements Runnable {
    private static final long serialVersionUID = 1L;
    private double[][] allDisplacements;
    private ConnectedComponent cc;
    private int dim;
    private int[] list;
    private double attraction;
    private double repulsion;
    private int start;
    private int end;

    public DisplacementCalculator(double attraction, double repulsion, double[][] allDisplacements, ConnectedComponent cc, int dim, int[] list, int start, int end) {
        this.allDisplacements = allDisplacements;
        this.cc = cc;
        this.dim = dim;
        this.attraction = attraction;
        this.repulsion = repulsion;
        this.list = list;
        this.start = start;
        this.end = end;
    }

    public void run() {
        double distance = 0.0;
        for (int i = this.start; i <= this.end; ++i) {
            for (int j = 0; j < this.cc.getNodeNumber(); ++j) {
                double displacement;
                double force;
                int d;
                for (d = 0; d < this.dim; ++d) {
                    double dummy = this.cc.getCCPositions()[i][d] - this.cc.getCCPositions()[j][d];
                    distance += dummy * dummy;
                }
                if ((distance = Math.sqrt(distance)) < 1.0E-4) continue;
                if (this.cc.getCCEdges().getEdgeCost(i, j) > 0.0f) {
                    force = Math.log(distance + 1.0) * (double)this.cc.getCCEdges().getEdgeCost(i, j) * this.attraction / distance;
                    d = 0;
                    while (d < this.dim) {
                        displacement = (this.cc.getCCPositions()[j][d] - this.cc.getCCPositions()[i][d]) * force;
                        double[] dArray = this.allDisplacements[i];
                        int n = d++;
                        dArray[n] = dArray[n] + displacement;
                    }
                    continue;
                }
                force = (double)this.cc.getCCEdges().getEdgeCost(i, j) * this.repulsion / Math.log(distance + 1.0) / distance;
                d = 0;
                while (d < this.dim) {
                    displacement = (this.cc.getCCPositions()[j][d] - this.cc.getCCPositions()[i][d]) * force;
                    double[] dArray = this.allDisplacements[i];
                    int n = d++;
                    dArray[n] = dArray[n] + displacement;
                }
            }
        }
    }

    private static double calculateEuclideanDistance(double[][] node_pos, int dim, int node_i, int node_j) {
        double distance = 0.0;
        double dummy = 0.0;
        for (int d = 0; d < dim; ++d) {
            dummy = node_pos[node_i][d] - node_pos[node_j][d];
            distance += dummy * dummy;
        }
        distance = Math.sqrt(distance);
        return distance;
    }
}

