/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.forcend;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.forcend.DisplacementCalculator;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.forcend.FORCEnDParameters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class FORCEnDLayoutUtility {
    public static double calculateTemperature(int iteration, int node_no, FORCEnDParameters param) {
        int k = 2;
        double temp = Math.pow(1.0 / (double)(iteration + 1), k) * (double)param.getTemperature() * (double)node_no;
        return temp;
    }

    private static void setDisplacementsToZero(double[][] allDisplacements, int node_no, int dim) {
        for (int i = 0; i < node_no; ++i) {
            Arrays.fill(allDisplacements[i], 0.0);
        }
    }

    public static void calculateDisplacementVectors(double[][] allDisplacements, ConnectedComponent cc, int dim, FORCEnDParameters param, double temperature) {
        FORCEnDLayoutUtility.setDisplacementsToZero(allDisplacements, cc.getNodeNumber(), dim);
        double attraction = param.getAttractionFactor() / (double)cc.getNodeNumber();
        double repulsion = param.getRepulsionFactor() / (double)cc.getNodeNumber();
        int[] list = new int[cc.getNodeNumber()];
        if (TaskConfig.useThreads) {
            ExecutorService es = Executors.newFixedThreadPool(TaskConfig.maxNoThreads);
            for (int i = 0; i < TaskConfig.maxNoThreads; ++i) {
                DisplacementCalculator s = new DisplacementCalculator(attraction, repulsion, allDisplacements, cc, dim, list, (int)Math.rint((double)cc.getNodeNumber() / (double)TaskConfig.maxNoThreads) * i, Math.min((int)Math.rint((double)cc.getNodeNumber() / (double)TaskConfig.maxNoThreads) * (i + 1) - 1, cc.getNodeNumber() - 1));
                es.execute(s);
            }
            es.shutdown();
            try {
                es.awaitTermination(5L, TimeUnit.HOURS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int i = 0; i < cc.getNodeNumber(); ++i) {
                for (int j = i + 1; j < cc.getNodeNumber(); ++j) {
                    double displacement;
                    int d;
                    double force;
                    double distance = FORCEnDLayoutUtility.calculateEuclideanDistance(cc.getCCPositions(), dim, i, j);
                    if (distance < 1.0E-4) continue;
                    if (cc.getCCEdges().getEdgeCost(i, j) > 0.0f) {
                        force = Math.log(distance + 1.0) * (double)cc.getCCEdges().getEdgeCost(i, j) * attraction / distance;
                        d = 0;
                        while (d < dim) {
                            displacement = (cc.getCCPositions()[j][d] - cc.getCCPositions()[i][d]) * force;
                            double[] dArray = allDisplacements[i];
                            int n = d;
                            dArray[n] = dArray[n] + displacement;
                            double[] dArray2 = allDisplacements[j];
                            int n2 = d++;
                            dArray2[n2] = dArray2[n2] - displacement;
                        }
                        continue;
                    }
                    force = (double)cc.getCCEdges().getEdgeCost(i, j) * repulsion / Math.log(distance + 1.0) / distance;
                    d = 0;
                    while (d < dim) {
                        displacement = (cc.getCCPositions()[j][d] - cc.getCCPositions()[i][d]) * force;
                        double[] dArray = allDisplacements[i];
                        int n = d;
                        dArray[n] = dArray[n] + displacement;
                        double[] dArray3 = allDisplacements[j];
                        int n3 = d++;
                        dArray3[n3] = dArray3[n3] - displacement;
                    }
                }
            }
        }
    }

    private static double calculateEuclideanDistance(double[][] node_pos, int dim, int node_i, int node_j) {
        double distance = 0.0;
        double dummy = 0.0;
        for (int d = 0; d < dim; ++d) {
            dummy = node_pos[node_i][d] - node_pos[node_j][d];
            distance += dummy * dummy;
        }
        distance = Math.sqrt(distance);
        return distance;
    }

    public static void moveAllNodesByDisplacement(double[][] allDisplacements, double[][] node_pos, int node_no, int dim, double temp) {
        for (int i = 0; i < node_no; ++i) {
            double norm = FORCEnDLayoutUtility.calculateNorm(allDisplacements, i, dim);
            for (int d = 0; d < dim; ++d) {
                double newPos;
                if (norm > temp) {
                    allDisplacements[i][d] = allDisplacements[i][d] / norm * temp;
                }
                node_pos[i][d] = (newPos = node_pos[i][d] + allDisplacements[i][d]) > 2.147483647E9 ? 2.147483647E9 : (newPos < -2.147483648E9 ? -2.147483648E9 : newPos);
            }
        }
    }

    public static double calculateNorm(double[][] positions, int node, int dim) {
        double norm = 0.0;
        for (int d = 0; d < dim; ++d) {
            double pos_i = positions[node][d];
            norm += pos_i * pos_i;
        }
        norm = Math.sqrt(norm);
        return norm;
    }

    public class DisplacementTask
    implements Runnable {
        private static final long serialVersionUID = 1L;
        private double[][] allDisplacements;
        private ConnectedComponent cc;
        private int dim;
        private int[] list;
        private double attraction;
        private double repulsion;
        private int start;
        private int end;

        public DisplacementTask(double attraction, double repulsion, double[][] allDisplacements, ConnectedComponent cc, int dim, int[] list, int start, int end) {
            this.allDisplacements = allDisplacements;
            this.cc = cc;
            this.dim = dim;
            this.attraction = attraction;
            this.repulsion = repulsion;
            this.list = list;
            this.start = start;
            this.end = end;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            int i = this.start;
            while (i <= this.end) {
                for (int j = i + 1; j < this.cc.getNodeNumber(); ++j) {
                    double[][] dArray;
                    double displacement;
                    int d;
                    double distance = 0.0;
                    double dummy = 0.0;
                    for (int d2 = 0; d2 < this.dim; distance += dummy * dummy, ++d2) {
                        dummy = this.cc.getCCPositions()[i][d2] - this.cc.getCCPositions()[j][d2];
                    }
                    if ((distance = Math.sqrt(distance)) < 1.0E-4) continue;
                    if (this.cc.getCCEdges().getEdgeCost(i, j) > 0.0f) {
                        double force = Math.log(distance + 1.0) * (double)this.cc.getCCEdges().getEdgeCost(i, j) * this.attraction / distance;
                        d = 0;
                        while (d < this.dim) {
                            displacement = (this.cc.getCCPositions()[j][d] - this.cc.getCCPositions()[i][d]) * force;
                            dArray = this.allDisplacements;
                            // MONITORENTER : this.allDisplacements
                            double[] dArray2 = this.allDisplacements[i];
                            int n = d;
                            dArray2[n] = dArray2[n] + displacement;
                            double[] dArray3 = this.allDisplacements[j];
                            int n2 = d++;
                            dArray3[n2] = dArray3[n2] - displacement;
                            // MONITOREXIT : dArray
                        }
                        continue;
                    }
                    double force = (double)this.cc.getCCEdges().getEdgeCost(i, j) * this.repulsion / Math.log(distance + 1.0) / distance;
                    d = 0;
                    while (d < this.dim) {
                        displacement = (this.cc.getCCPositions()[j][d] - this.cc.getCCPositions()[i][d]) * force;
                        dArray = this.allDisplacements;
                        // MONITORENTER : this.allDisplacements
                        double[] dArray4 = this.allDisplacements[i];
                        int n = d;
                        dArray4[n] = dArray4[n] + displacement;
                        double[] dArray5 = this.allDisplacements[j];
                        int n3 = d++;
                        dArray5[n3] = dArray5[n3] - displacement;
                        // MONITOREXIT : dArray
                    }
                }
                ++i;
            }
        }
    }
}

