/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.forcend;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.ILayoutInitialiser;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.ILayouter;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.IParameters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.LayoutFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.forcend.FORCEnDLayoutUtility;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.forcend.FORCEnDParameters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.parameter_training.ParameterTraining_SE;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;
import java.util.logging.Logger;

public class FORCEnDLayouter
implements ILayouter {
    private static Logger log = Logger.getLogger(ParameterTraining_SE.class.getName());
    private ConnectedComponent cc = null;
    private int dim = -1;
    private FORCEnDParameters parameters = null;

    public void initLayouter(ConnectedComponent cc, ILayoutInitialiser li, IParameters parameters) {
        this.dim = TaskConfig.dimension;
        this.cc = cc;
        this.parameters = (FORCEnDParameters)parameters;
        li.run();
    }

    public void initLayouter(ConnectedComponent cc, ILayouter layouter, IParameters parameters) {
        this.dim = TaskConfig.dimension;
        this.cc = cc;
        this.parameters = (FORCEnDParameters)parameters;
        this.cc.setCCPositions(layouter.getNodePositions());
    }

    public void initLayouter(ConnectedComponent cc, IParameters parameters) {
        this.dim = TaskConfig.dimension;
        this.cc = cc;
        this.parameters = (FORCEnDParameters)parameters;
        if (cc.getCCPositions() == null) {
            log.warning("Positions have not been initialised, perhapswrong use of this constructor!");
            ILayoutInitialiser li = LayoutFactory.EnumLayouterClass.FORCEND.createLayoutInitialiser();
            li.initLayoutInitialiser(cc);
            li.run();
        }
    }

    public void run() {
        this.cc.getCCEdges().normalise();
        int node_no = this.cc.getNodeNumber();
        double[][] node_pos = this.cc.getCCPositions();
        double[][] allDisplacements = new double[node_no][this.dim];
        for (int it = 0; it < this.parameters.getIterations(); ++it) {
            double temperature = FORCEnDLayoutUtility.calculateTemperature(it, node_no, this.parameters);
            FORCEnDLayoutUtility.calculateDisplacementVectors(allDisplacements, this.cc, this.dim, this.parameters, temperature);
            FORCEnDLayoutUtility.moveAllNodesByDisplacement(allDisplacements, node_pos, node_no, this.dim, temperature);
        }
        this.cc.getCCEdges().denormalise();
    }

    public double[][] getNodePositions() {
        return this.cc.getCCPositions();
    }
}

