/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.forcend;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.ILayoutInitialiser;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;

public class LayoutInitCirclesInPlanes
implements ILayoutInitialiser {
    private ConnectedComponent cc = null;
    private double radius = 0.0;
    private int dim = 0;
    private int node_no = 0;
    public double[][] node_pos = null;

    public void initLayoutInitialiser(ConnectedComponent cc) {
        this.cc = cc;
        this.radius = 1.0;
        this.dim = TaskConfig.dimension;
        this.node_no = cc.getNodeNumber();
        this.node_pos = new double[this.node_no][this.dim];
    }

    public void run() {
        if (this.dim == 1) {
            for (int i = 0; i < this.cc.getNodeNumber(); ++i) {
                this.node_pos[i][0] = i;
            }
        } else {
            int planes = this.getNumberOfPlanes();
            int currentPlane = 1;
            int nodes_per_plane = this.node_no / planes;
            int startNode = 0;
            for (int d1 = 0; d1 < this.dim; ++d1) {
                for (int d2 = 0; d2 < d1; ++d2) {
                    if (currentPlane == planes) {
                        nodes_per_plane = this.node_no - nodes_per_plane * (planes - 1);
                    }
                    this.createCircleForPlane(d1, d2, startNode, nodes_per_plane);
                    startNode += nodes_per_plane;
                    ++currentPlane;
                }
            }
        }
        this.cc.setCCPositions(this.node_pos);
    }

    private void createCircleForPlane(int d1, int d2, int startNode, int nodes_per_plane) {
        double angle_step = Math.PI * 2 / (double)nodes_per_plane;
        double phi = 0.0;
        for (int i = startNode; i <= startNode + nodes_per_plane - 1; ++i) {
            double x = this.getXValue(phi);
            double y = this.getYValue(phi);
            for (int d = 0; d < this.dim; ++d) {
                if (d == d1) {
                    this.node_pos[i][d] = x;
                    continue;
                }
                if (d != d2) continue;
                this.node_pos[i][d] = y;
            }
            phi += angle_step;
        }
    }

    private void createCircleForPlaneForClusters(int d1, int d2, int startNode, int nodes_per_plane) {
        double angle_step = Math.PI * 2 / (double)nodes_per_plane;
        double phi = 0.0;
        for (int i = startNode; i <= startNode + nodes_per_plane - 1; ++i) {
            double x = this.getXValue(phi);
            double y = this.getYValue(phi);
            for (int d = 0; d < this.dim; ++d) {
                for (int j = 0; j < this.cc.getClusters().length; ++j) {
                    if (this.cc.getClusters()[j] != i) continue;
                    if (d == d1) {
                        this.node_pos[j][d] = x + (double)j * 1.0E-4;
                        continue;
                    }
                    if (d != d2) continue;
                    this.node_pos[j][d] = y + (double)j * 1.0E-4;
                }
            }
            phi += angle_step;
        }
    }

    private double getXValue(double phi) {
        return this.radius * Math.cos(phi);
    }

    private double getYValue(double phi) {
        return this.radius * Math.sin(phi);
    }

    private int getNumberOfPlanes() {
        int planes = 0;
        for (int i = 1; i < this.dim; ++i) {
            planes += i;
        }
        return planes;
    }
}

