/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.parameter_training;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.ILayoutInitialiser;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.IParameters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.LayoutFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.parameter_training.IParameterTraining;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.parameter_training.ParametersComparator;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.ClusterTrainingTask;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterTraining_SE
implements IParameterTraining {
    private static Logger log = Logger.getLogger(ParameterTraining_SE.class.getName());
    private LayoutFactory.EnumLayouterClass layouterEnum = null;
    private int generationSize = -1;
    private int noOfGenerations = -1;
    private ParametersComparator paramComparator = null;
    private int noOfThreads;
    private Semaphore maxThreadSemaphore;
    private ArrayList<Thread> allThreads;
    private IParameters bestPreviousIParameters = null;
    private Vector<IParameters> bestConfigs = null;

    @Override
    public void initialise(LayoutFactory.EnumLayouterClass layouterEnum, int generationSize, int noOfGenerations) {
        this.layouterEnum = layouterEnum;
        this.generationSize = generationSize;
        this.noOfGenerations = noOfGenerations;
        this.paramComparator = new ParametersComparator();
        this.bestConfigs = new Vector();
        this.noOfThreads = TaskConfig.maxNoThreads;
        if (this.noOfThreads == 0 || this.noOfThreads == 1) {
            TaskConfig.useThreads = false;
            this.noOfThreads = 1;
        }
    }

    @Override
    public IParameters run(ConnectedComponent cc) {
        boolean terminateTraining = false;
        ILayoutInitialiser li = this.layouterEnum.createLayoutInitialiser();
        li.initLayoutInitialiser(cc);
        li.run();
        IParameters[] initialGeneration = this.createInitialParameterGeneration();
        this.runOneGeneration(initialGeneration, cc, 0);
        terminateTraining = this.terminateTraining(initialGeneration);
        for (int i = 0; i < 10; ++i) {
            this.bestConfigs.add(initialGeneration[i]);
        }
        for (int i = 1; i <= this.noOfGenerations && !terminateTraining; ++i) {
            IParameters[] generation = this.createParameterGeneration();
            this.runOneGeneration(generation, cc, i);
            terminateTraining = this.terminateTraining(generation);
            for (int j = 0; j < this.generationSize / 2; ++j) {
                this.bestConfigs.add(generation[j]);
            }
        }
        IParameters[] bestConfigsArray = new IParameters[this.bestConfigs.size()];
        for (int i = 0; i < this.bestConfigs.size(); ++i) {
            bestConfigsArray[i] = this.bestConfigs.get(i);
        }
        Arrays.sort(bestConfigsArray, this.paramComparator);
        this.bestPreviousIParameters = bestConfigsArray[0];
        bestConfigsArray[0].setScore(0.0);
        return bestConfigsArray[0];
    }

    private IParameters[] createInitialParameterGeneration() {
        int initialSize = this.generationSize + 10;
        IParameters[] paramsGen = new IParameters[initialSize];
        IParameters param = this.layouterEnum.createIParameters();
        param.readParametersFromConfig();
        paramsGen[0] = param;
        if (this.bestPreviousIParameters != null) {
            paramsGen[1] = this.bestPreviousIParameters;
        } else {
            param = this.layouterEnum.createIParameters();
            param.createRandomConfiguration();
            paramsGen[1] = param;
        }
        for (int i = 2; i < initialSize; ++i) {
            param = this.layouterEnum.createIParameters();
            param.createRandomConfiguration();
            paramsGen[i] = param;
        }
        return paramsGen;
    }

    private IParameters[] createParameterGeneration() {
        int i;
        IParameters[] paramsGen = new IParameters[this.generationSize];
        IParameters[] bestConfigsArray = new IParameters[this.bestConfigs.size()];
        for (int i2 = 0; i2 < this.bestConfigs.size(); ++i2) {
            bestConfigsArray[i2] = this.bestConfigs.get(i2);
        }
        IParameters param = this.layouterEnum.createIParameters();
        param.combineConfigurationsRandomly(bestConfigsArray);
        paramsGen[0] = param;
        int currentPosition = 1;
        int third = (this.generationSize - 1) / 3;
        for (i = currentPosition; i < currentPosition + third; ++i) {
            param = this.layouterEnum.createIParameters();
            param.combineConfigurationsRandomly(bestConfigsArray);
            paramsGen[i] = param;
        }
        for (i = currentPosition += third; i < currentPosition + third; ++i) {
            param = this.layouterEnum.createIParameters();
            param.combineParametersRandomlyAndGetNewRandom(bestConfigsArray);
            paramsGen[i] = param;
        }
        for (i = currentPosition += third; i < this.generationSize; ++i) {
            param = this.layouterEnum.createIParameters();
            param.createRandomConfiguration();
            paramsGen[i] = param;
        }
        return paramsGen;
    }

    private boolean terminateTraining(IParameters[] params) {
        Arrays.sort(params, this.paramComparator);
        double bestScore = params[0].getScore();
        if (bestScore == 0.0) {
            return false;
        }
        for (int i = 1; i < params.length - 2; ++i) {
            if (!(params[i].getScore() > bestScore)) continue;
            return false;
        }
        return true;
    }

    private void runOneGeneration(IParameters[] generationParameterSet, ConnectedComponent cc, int gen) {
        int size = generationParameterSet.length;
        for (int i = 0; i < size; ++i) {
            ConnectedComponent newCC = cc.copy();
            newCC.setCCPositions(cc.copyCCPositions());
            ClusterTrainingTask clusteringTask = new ClusterTrainingTask(newCC, generationParameterSet[i], this.layouterEnum);
            clusteringTask.run();
        }
    }

    @Override
    public void setMaxThreadSemaphoreAndThreadsList(Semaphore semaphore, ArrayList<Thread> allThreads) {
        this.maxThreadSemaphore = semaphore;
        this.allThreads = allThreads;
    }
}

