/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ICCEdges;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.greedy.GreedyClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.IPostProcessing;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.PostProcessingUtility;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.ClusteringManager;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.InvalidInputFileException;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PP_RearrangeAndMergeBest
implements IPostProcessing {
    private ConnectedComponent cc = null;
    private double bestScore = 0.0;
    private ICCEdges icce;

    @Override
    public void initPostProcessing(ConnectedComponent cc) {
        this.cc = cc;
        this.bestScore = cc.getClusteringScore();
        this.icce = this.cc.getCCEdges();
    }

    @Override
    public void run() {
        int[] clusters = this.cc.getClusters();
        ArrayList<ArrayList<Integer>> clusterObject = PostProcessingUtility.createClusterObject(this.cc, false);
        boolean findBetterScore = true;
        while (findBetterScore) {
            double score = this.bestScore;
            findBetterScore = this.onePostProcessingRound(clusters, clusterObject, score);
        }
        this.cc.initialiseClusterInfo(clusterObject.size());
        this.cc.setClusters(clusters);
        this.cc.setClusteringScore(this.cc.calculateClusteringScore(clusters));
        this.cc.calculateClusterDistribution();
    }

    private boolean onePostProcessingRound(int[] clusters, ArrayList<ArrayList<Integer>> clusterObject, double oldScore) {
        this.rearrangeSingleNodes(clusterObject, clusters);
        this.updateClusters(clusters, clusterObject);
        HashSet<String> alreadyCompared = new HashSet<String>();
        this.mergeBest(clusterObject, alreadyCompared);
        this.updateClusters(clusters, clusterObject);
        return this.bestScore < oldScore;
    }

    protected void updateClusters(int[] clusters, ArrayList<ArrayList<Integer>> clusterObject) {
        for (int i = 0; i < clusterObject.size(); ++i) {
            ArrayList<Integer> oneCluster = clusterObject.get(i);
            if (oneCluster.size() == 0) {
                clusterObject.remove(oneCluster);
                --i;
                continue;
            }
            for (int j = 0; j < oneCluster.size(); ++j) {
                clusters[oneCluster.get((int)j).intValue()] = i;
            }
        }
    }

    private void rearrangeSingleNodes(ArrayList<ArrayList<Integer>> clusterObject, int[] clusters) {
        boolean changed = false;
        for (int i = 0; i < clusters.length; ++i) {
            double bestCostDiff = 0.0;
            int oldCluster = clusters[i];
            int newCluster = clusters[i];
            double removeCost = 0.0;
            removeCost = this.calculateRemoveCost(i, clusterObject.get(oldCluster));
            double costDiff = 0.0;
            for (int j = 0; j < clusterObject.size(); ++j) {
                if (oldCluster == j || !((costDiff = this.calculateCostChange(i, clusterObject.get(j)) + removeCost) < bestCostDiff)) continue;
                bestCostDiff = costDiff;
                newCluster = j;
            }
            ArrayList newEmptyArrayList = new ArrayList();
            costDiff = removeCost;
            if (costDiff < bestCostDiff) {
                changed = true;
                bestCostDiff = costDiff;
                newCluster = clusterObject.size();
                clusterObject.add(newEmptyArrayList);
            }
            if (oldCluster != newCluster) {
                Integer node_i = i;
                clusterObject.get(oldCluster).remove(node_i);
                clusterObject.get(newCluster).add(node_i);
                this.bestScore += bestCostDiff;
            }
            if (!changed) continue;
            this.updateClusters(clusters, clusterObject);
            this.rearrangeSingleNodes(clusterObject, clusters);
            break;
        }
        if (!changed) {
            this.updateClusters(clusters, clusterObject);
        }
    }

    private double calculateCostChange(int node_i, ArrayList<Integer> newCluster) {
        double costChange = 0.0;
        for (int node_k : newCluster) {
            costChange -= (double)this.icce.getEdgeCost(node_i, node_k);
        }
        return costChange;
    }

    protected void mergeBest(ArrayList<ArrayList<Integer>> clusterObject) throws InvalidInputFileException {
        ICCEdges cc2d = TaskConfig.ccEdgesEnum.createCCEdges(clusterObject.size());
        String[] ids = new String[clusterObject.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = i + "";
            for (int j = i + 1; j < ids.length; ++j) {
                cc2d.setEdgeCost(i, j, -((float)this.calculateCostChange(clusterObject.get(i), clusterObject.get(j))));
            }
        }
        ConnectedComponent cc2 = new ConnectedComponent(cc2d, ids, null, false);
        ClusteringManager cm = new ClusteringManager(null);
        new GreedyClusterer(cc2);
        ArrayList clusterObjectNew = new ArrayList();
        for (int i = 0; i < cc2.getNumberOfClusters(); ++i) {
            ArrayList v = new ArrayList();
            clusterObjectNew.add(v);
        }
        int[] clustering = cc2.getClusters();
        for (int i = 0; i < clustering.length; ++i) {
            ((ArrayList)clusterObjectNew.get(clustering[i])).addAll((Collection)clusterObject.get(i));
        }
        clusterObject = clusterObjectNew;
        this.bestScore = cc2.calculateClusteringScore(clustering);
    }

    protected void mergeBest(ArrayList<ArrayList<Integer>> clusterObject, HashSet<String> alreadyCompared) {
        for (int i = 0; i < clusterObject.size(); ++i) {
            double bestCostChange = 0.0;
            Integer bestMergeCluster = i;
            ArrayList<Integer> best_merge = clusterObject.get(i);
            for (int j = i + 1; j < clusterObject.size(); ++j) {
                double costChange = this.calculateCostChange(clusterObject.get(i), clusterObject.get(j));
                if (!(costChange <= bestCostChange)) continue;
                bestCostChange = costChange;
                bestMergeCluster = j;
                best_merge = clusterObject.get(j);
            }
            if (bestMergeCluster == i) continue;
            clusterObject.get(i).addAll(best_merge);
            this.bestScore += bestCostChange;
            clusterObject.remove(best_merge);
            this.mergeBest(clusterObject, alreadyCompared);
            break;
        }
    }

    private double calculateCostChange(ArrayList<Integer> cluster1, ArrayList<Integer> cluster2) {
        double costChange = 0.0;
        for (int node_i : cluster1) {
            for (int node_j : cluster2) {
                costChange -= (double)this.icce.getEdgeCost(node_i, node_j);
            }
        }
        return costChange;
    }

    protected double getBestScore() {
        return this.bestScore;
    }

    private double calculateRemoveCost(int node_i, ArrayList<Integer> get) {
        double removeCost = 0.0;
        for (int node_k : get) {
            if (node_i == node_k) continue;
            removeCost += (double)this.icce.getEdgeCost(node_i, node_k);
        }
        return removeCost;
    }
}

