/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.ClusterObjectComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostProcessingUtility {
    protected static void sortedMerge(ArrayList<ArrayList<Integer>> clusterObject, ClusterObjectComparator comparator, HashSet<String> alreadyCompared, ConnectedComponent cc, boolean sort) {
        if (sort) {
            Collections.sort(clusterObject, comparator);
        }
        boolean merge = false;
        for (int i = 0; i < clusterObject.size(); ++i) {
            ArrayList<Integer> v1 = clusterObject.get(i);
            for (int j = i + 1; j < clusterObject.size(); ++j) {
                ArrayList<Integer> v2 = clusterObject.get(j);
                StringBuffer combinationBuffer = new StringBuffer();
                combinationBuffer.append(v1.hashCode());
                combinationBuffer.append(v2.hashCode());
                String combination = combinationBuffer.toString();
                if (alreadyCompared.contains(combination)) continue;
                alreadyCompared.add(combination);
                double costChange = PostProcessingUtility.calculateCostChange(v1, v2, cc);
                if (!(costChange <= 0.0)) continue;
                v1.addAll(v2);
                clusterObject.remove(v2);
                PostProcessingUtility.sortedMerge(clusterObject, comparator, alreadyCompared, cc, sort);
                break;
            }
            if (merge) break;
        }
    }

    protected static double calculateCostChange(ArrayList<Integer> cluster1, ArrayList<Integer> cluster2, ConnectedComponent cc) {
        double costChange = 0.0;
        for (int i = 0; i < cluster1.size(); ++i) {
            int node_i = cluster1.get(i);
            for (int j = 0; j < cluster2.size(); ++j) {
                int node_j = cluster2.get(j);
                double cost = cc.getCCEdges().getEdgeCost(node_i, node_j);
                costChange -= cost;
            }
        }
        return costChange;
    }

    protected static double calculateCostChange(HashSet<Integer> moveNodes, ArrayList<Integer> oldCluster, ArrayList<Integer> newCluster, ConnectedComponent cc) {
        double cost;
        int node_k;
        int n;
        double costChange = 0.0;
        for (n = 0; n < oldCluster.size(); ++n) {
            node_k = oldCluster.get(n);
            if (moveNodes.contains(node_k)) continue;
            for (int node_x : moveNodes) {
                cost = cc.getCCEdges().getEdgeCost(node_x, node_k);
                costChange += cost;
            }
        }
        for (n = 0; n < newCluster.size(); ++n) {
            node_k = newCluster.get(n);
            for (int node_x : moveNodes) {
                cost = cc.getCCEdges().getEdgeCost(node_x, node_k);
                costChange -= cost;
            }
        }
        return costChange;
    }

    protected static double calculateCostChange(int node_i, int node_j, ArrayList<Integer> oldCluster, ArrayList<Integer> newCluster, ConnectedComponent cc) {
        double cost_j;
        double cost_i;
        int node_k;
        int n;
        double costChange = 0.0;
        for (n = 0; n < oldCluster.size(); ++n) {
            node_k = oldCluster.get(n);
            if (node_k == node_i || node_k == node_j) continue;
            cost_i = cc.getCCEdges().getEdgeCost(node_i, node_k);
            costChange += cost_i;
            cost_j = cc.getCCEdges().getEdgeCost(node_j, node_k);
            costChange += cost_j;
        }
        for (n = 0; n < newCluster.size(); ++n) {
            node_k = newCluster.get(n);
            cost_i = cc.getCCEdges().getEdgeCost(node_i, node_k);
            costChange -= cost_i;
            cost_j = cc.getCCEdges().getEdgeCost(node_j, node_k);
            costChange -= cost_j;
        }
        return costChange;
    }

    protected static double calculateCostChange(int node_i, ArrayList<Integer> oldCluster, ArrayList<Integer> newCluster, ConnectedComponent cc) {
        double cost;
        int node_k;
        int j;
        double costChange = 0.0;
        for (j = 0; j < oldCluster.size(); ++j) {
            node_k = oldCluster.get(j);
            if (node_k == node_i) continue;
            cost = cc.getCCEdges().getEdgeCost(node_i, node_k);
            costChange += cost;
        }
        for (j = 0; j < newCluster.size(); ++j) {
            node_k = newCluster.get(j);
            cost = cc.getCCEdges().getEdgeCost(node_i, node_k);
            costChange -= cost;
        }
        return costChange;
    }

    public static double updateClusterInfoInCC(ArrayList<ArrayList<Integer>> clusterObject, ConnectedComponent cc) {
        int[] clusters = cc.getClusters();
        for (int i = 0; i < clusterObject.size(); ++i) {
            ArrayList<Integer> oneCluster = clusterObject.get(i);
            if (oneCluster.size() == 0) {
                clusterObject.remove(oneCluster);
                --i;
                continue;
            }
            for (int j = 0; j < oneCluster.size(); ++j) {
                clusters[oneCluster.get((int)j).intValue()] = i;
            }
        }
        cc.initialiseClusterInfo(clusterObject.size());
        cc.setClusters(clusters);
        double score = cc.calculateClusteringScore(clusters);
        cc.setClusteringScore(score);
        cc.calculateClusterDistribution();
        return score;
    }

    protected static ArrayList<ArrayList<Integer>> createClusterObject(ConnectedComponent cc, boolean isSubConnectedComponent) {
        int i;
        int noOfClusters = cc.getNumberOfClusters();
        int[] clusters = cc.getClusters();
        ArrayList<ArrayList<Integer>> clusterObject = new ArrayList<ArrayList<Integer>>(noOfClusters);
        int[] clusterDistribution = cc.getClusterInfo();
        for (i = 0; i < clusterDistribution.length; ++i) {
            clusterObject.add(new ArrayList(clusterDistribution[i]));
        }
        for (i = 0; i < clusters.length; ++i) {
            ArrayList<Integer> cluster2 = clusterObject.get(clusters[i]);
            if (isSubConnectedComponent) {
                int objectInitialNo = Integer.parseInt(cc.getObjectID(i));
                cluster2.add(objectInitialNo);
                continue;
            }
            cluster2.add(i);
        }
        return clusterObject;
    }

    protected static void mergeCluster(ArrayList<ArrayList<Integer>> h, HashSet<String> alreadyCompared, ConnectedComponent cc, ClusterObjectComparator comparator, boolean sort) {
        if (sort) {
            Collections.sort(h, comparator);
        }
        int[] test = cc.getClusters();
        boolean isbreak = false;
        for (int i = 0; i < h.size(); ++i) {
            ArrayList<Integer> v1 = h.get(i);
            for (int j = i + 1; j < h.size(); ++j) {
                ArrayList<Integer> v2 = h.get(j);
                StringBuffer combinationBuffer = new StringBuffer();
                combinationBuffer.append(v1.hashCode());
                combinationBuffer.append(v2.hashCode());
                String combination = combinationBuffer.toString();
                if (alreadyCompared.contains(combination)) continue;
                alreadyCompared.add(combination);
                for (int k = 0; k < v2.size(); ++k) {
                    test[v2.get((int)k).intValue()] = i;
                }
                double costChange = PostProcessingUtility.calculateCostChange(v1, v2, cc);
                if (costChange <= 0.0) {
                    v1.addAll(v2);
                    h.remove(j);
                    PostProcessingUtility.mergeCluster(h, alreadyCompared, cc, comparator, sort);
                    isbreak = true;
                    break;
                }
                for (int k = 0; k < v2.size(); ++k) {
                    test[v2.get((int)k).intValue()] = j;
                }
            }
            if (isbreak) break;
        }
    }
}

