/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.geometric_clustering.IGeometricClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.ILayouter;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.IParameters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.LayoutFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.IPostProcessing;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.PP_DivideAndRecluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.PP_DivideAndReclusterRecursively;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.PostProcessingFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterTrainingTask
implements Runnable {
    private ConnectedComponent cc = null;
    private Semaphore semaphore = null;
    private IParameters parameters = null;
    private LayoutFactory.EnumLayouterClass layoutEnum = null;
    private Semaphore maxThreadSemaphore;
    private ArrayList<Thread> allThreads = null;
    private Thread runningThread = null;

    public ClusterTrainingTask(ConnectedComponent cc, IParameters parameters, LayoutFactory.EnumLayouterClass layoutEnum) {
        this.cc = cc;
        this.parameters = parameters;
        this.layoutEnum = layoutEnum;
    }

    @Override
    public void run() {
        if (this.allThreads != null) {
            this.allThreads.add(this.runningThread);
        }
        if (this.cc.getReducedConnectedComponent() != null) {
            this.runClustering(this.cc.getReducedConnectedComponent());
        } else {
            this.runClustering(this.cc);
        }
        if (this.cc.getReducedConnectedComponent() != null) {
            this.cc.rebuildCC();
        }
        this.parameters.setScore(this.cc.getClusteringScore());
        if (this.semaphore != null) {
            this.semaphore.release();
        }
        if (this.maxThreadSemaphore != null) {
            this.maxThreadSemaphore.release();
            this.allThreads.remove(this.runningThread);
        }
    }

    private void runClustering(ConnectedComponent cc) {
        ILayouter layouter = this.layoutEnum.createLayouter();
        layouter.initLayouter(cc, this.parameters);
        layouter.run();
        IGeometricClusterer geocluster = TaskConfig.geometricClusteringEnum.createGeometricClusterer();
        geocluster.initGeometricClusterer(cc);
        geocluster.run();
        if (TaskConfig.doPostProcessing) {
            PostProcessingFactory.EnumPostProcessingClass ppEnum = TaskConfig.postProcessingEnum;
            IPostProcessing pp = ppEnum.createPostProcessor();
            pp.initPostProcessing(cc);
            LayoutFactory.EnumLayouterClass[] layouterTypes = new LayoutFactory.EnumLayouterClass[]{this.layoutEnum};
            IParameters[] params = new IParameters[]{this.parameters};
            if (ppEnum == PostProcessingFactory.EnumPostProcessingClass.PP_DIVIDE_AND_RECLUSTER) {
                ((PP_DivideAndRecluster)pp).setLayoutingInfo(params, layouterTypes);
            } else if (ppEnum == PostProcessingFactory.EnumPostProcessingClass.PP_DIVIDE_AND_RECLUSTER_RECURSIVELY) {
                ((PP_DivideAndReclusterRecursively)pp).setLayoutingInfo(params, layouterTypes);
            }
            pp.run();
        }
    }

    public void setSemaphore(Semaphore semaphore) {
        this.semaphore = semaphore;
        if (semaphore != null) {
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void setMaxThreadSemaphore(Semaphore semaphore, ArrayList<Thread> allThreads, Thread t) {
        this.maxThreadSemaphore = semaphore;
        this.allThreads = allThreads;
        this.runningThread = t;
        if (semaphore != null) {
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

