/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.ConnectedComponent;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.datastructure.CostMatrixReader;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.IParameters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.parameter_training.IParameterTraining;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.ClusteringTask;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.InvalidInputFileException;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.InvalidTypeException;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskUtility;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.io.ClusterFile;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.io.InfoFile;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteringManager {
    private static Logger log = Logger.getLogger(ClusteringManager.class.getName());
    private String cmPath;
    private IParameters[] layouterParameters = null;
    private ArrayList<File> connectedComponents = null;
    private ArrayList<Thread> allThreads;
    private int noOfThreads;
    private static double totalScoreSum = 0.0;

    public ClusteringManager(String cmPath) {
        this.cmPath = cmPath;
        String configString = TaskConfig.printConfiguration().toString();
        if (TaskConfig.mode == 0 || TaskConfig.mode == 1) {
            log.info(configString);
            InfoFile.appendToProjectDetails(configString);
        }
        this.noOfThreads = TaskConfig.maxNoThreads;
        if (this.noOfThreads == 0 || this.noOfThreads == 1) {
            TaskConfig.useThreads = false;
            this.noOfThreads = 1;
        }
    }

    public void initParametersAndCCs() throws InvalidInputFileException {
        if (TaskConfig.mode == 0 || TaskConfig.mode == 1) {
            this.connectedComponents = new ArrayList();
            TaskConfig.transitiveConnectedComponents = null;
            File cmFile = new File(this.cmPath);
            if (cmFile.isDirectory()) {
                log.finer("Input is a directory!");
                File[] files = cmFile.listFiles();
                boolean noCostMatrices = true;
                boolean noTCCfile = true;
                for (int i = 0; i < files.length; ++i) {
                    String filePath = files[i].toString();
                    if (filePath.endsWith(".tcc") || filePath.endsWith(".rtcc")) {
                        noTCCfile = false;
                        TaskConfig.transitiveConnectedComponents = filePath;
                        log.info("Transitive connected components file: " + filePath);
                        InfoFile.appendToProjectDetails("Transitive connected component file: " + filePath);
                    }
                    if (!files[i].toString().endsWith(".cm") && !files[i].toString().endsWith(".rcm")) continue;
                    noCostMatrices = false;
                    this.connectedComponents.add(files[i]);
                }
                if (noCostMatrices && noTCCfile) {
                    throw new InvalidInputFileException("There are no cost matrix files in the input directory and also no transitive connected components file, or check whether the file extensions equal .cm, .rcm, or .tcc");
                }
            } else {
                log.finer("One cm file given");
                if (!cmFile.toString().endsWith(".tcc")) {
                    this.connectedComponents.add(cmFile);
                } else if (cmFile.toString().endsWith(".tcc")) {
                    TaskConfig.transitiveConnectedComponents = cmFile.toString();
                    log.info("Only a transitive connected component file is given: " + cmFile.toString());
                    InfoFile.appendToProjectDetails("Only a transitive connected component file is given: " + cmFile.toString() + ". Therefore NO CLUSTERING IS PERFORMED, just the the " + "clusters from the TCC file are written into the clusters file.");
                } else {
                    throw new InvalidInputFileException("Either the input cost matrix is of wrong file type. The file extension should be \".cm\" or \".rcm\",or in the given TCC file is of the wrong type and should be \".tcc\".");
                }
            }
        }
        this.layouterParameters = new IParameters[TaskConfig.layouterEnumTypes.length];
        for (int i = 0; i < TaskConfig.layouterEnumTypes.length; ++i) {
            IParameters param = TaskConfig.layouterEnumTypes[i].createIParameters();
            param.readParametersFromConfig();
            this.layouterParameters[i] = param;
        }
        if (this.connectedComponents == null) {
            // empty if block
        }
    }

    public void runClustering() throws InvalidInputFileException, InvalidTypeException {
        ClusterFile clusterFile = null;
        if (TaskConfig.mode == 0) {
            log.fine("Running clustering in clustering mode!");
            clusterFile = new ClusterFile();
            clusterFile.instantiateFile(TaskConfig.clustersPath);
            clusterFile.printPreProcessingClusters(TaskConfig.transitiveConnectedComponents);
            if (this.connectedComponents == null) {
                if (TaskConfig.transitiveConnectedComponents == null) {
                    log.warning("Incorrect use of the ClusteringManager, the connected components listhadn't been initialised. Called method to initialise this and the parameters from the config. Or only a TCC file was given and no connected components.");
                    this.initParametersAndCCs();
                } else {
                    log.info("No cost matrices were given, just a transitive connected components file, whichis converted to a clusters file. NO CLUSTERING IS PERFORMED!");
                    InfoFile.appendToProjectDetails("No cost matrices were given, just a transitive connected components file, whichis converted to a clusters file. NO CLUSTERING IS PERFORMED!");
                }
            }
        }
        if (this.connectedComponents != null) {
            ArrayList<Semaphore> allSemaphores = new ArrayList<Semaphore>();
            Semaphore maxThreadSemaphore = new Semaphore(TaskConfig.maxNoThreads, true);
            for (int i = 0; i < this.connectedComponents.size(); ++i) {
                Semaphore semaphore = new Semaphore(1);
                allSemaphores.add(semaphore);
                long time = System.currentTimeMillis();
                CostMatrixReader cmReader = new CostMatrixReader(this.connectedComponents.get(i));
                ConnectedComponent cc = cmReader.getConnectedComponent();
                this.runClusteringForOneConnectedComponent(cc, clusterFile, semaphore, maxThreadSemaphore, time);
            }
            for (Semaphore s : allSemaphores) {
                try {
                    s.acquire();
                }
                catch (InterruptedException e) {
                    log.severe(e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        if (clusterFile != null) {
            clusterFile.closeFile();
        }
        log.info("Clustering scores sum: " + totalScoreSum);
        if (TaskConfig.mode == 0) {
            InfoFile.appendLnProjectResults("Total sum of clustering scores for given input: " + TaskUtility.round(totalScoreSum, 2));
        }
        if (TaskConfig.mode == 1) {
            log.fine("Setting parameters score for training mode!");
            for (IParameters parameter : this.layouterParameters) {
                parameter.setScore(totalScoreSum);
            }
        }
        totalScoreSum = 0.0;
    }

    public void runClusteringForOneConnectedComponent(ConnectedComponent cc, ClusterFile clusterFile, Semaphore semaphore, Semaphore maxThreadSemaphore, long time) throws InvalidInputFileException {
        if (this.layouterParameters == null) {
            if (TaskConfig.mode == 0 || TaskConfig.mode == 1) {
                log.warning("Incorrect use of the ClusteringManager, the layouter parameters listhadn't been initialised. Called method to initialise this and the connected components from the config");
            }
            this.initParametersAndCCs();
        }
        if (TaskConfig.doLayoutParameterTraining && !TaskConfig.greedy) {
            for (int i = 0; i < this.layouterParameters.length; ++i) {
                IParameterTraining paramTrain = TaskConfig.parameterTrainingEnum.createParameterTrainer();
                paramTrain.initialise(TaskConfig.layouterEnumTypes[i], TaskConfig.noOfParameterConfigurationsPerGeneration, TaskConfig.noOfGenerations);
                paramTrain.setMaxThreadSemaphoreAndThreadsList(maxThreadSemaphore, this.allThreads);
                IParameters bestparam = paramTrain.run(cc);
                log.fine("PARAMETER TRAINING RESULT\n: " + cc.getCcPath() + "\n" + bestparam.toString());
                this.layouterParameters[i] = bestparam;
            }
        }
        ClusteringTask clusterTask = new ClusteringTask(cc, this.layouterParameters, TaskConfig.layouterEnumTypes, clusterFile);
        clusterTask.setTime(time);
        clusterTask.run();
    }

    public ArrayList<File> getConnectedComponents() {
        return this.connectedComponents;
    }

    public void setConnectedComponents(ArrayList<File> connectedComponents) {
        this.connectedComponents = connectedComponents;
    }

    public IParameters[] getLayouterParameters() {
        return this.layouterParameters;
    }

    public void setLayouterParameters(IParameters[] layouterParameters) {
        this.layouterParameters = layouterParameters;
    }

    public static synchronized void addClusteringScoreToSum(double score) {
        totalScoreSum += score;
    }

    public double getTotalScoreSum() {
        return totalScoreSum;
    }

    public void setTotalScoreSum(double totalScoreSum) {
        ClusteringManager.totalScoreSum = totalScoreSum;
    }

    public void stopAllRunningThreads() {
        if (this.allThreads != null) {
            for (Thread t : this.allThreads) {
                if (!t.isAlive()) continue;
                t.stop();
            }
        }
    }
}

