/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.geometric_clustering.GeometricClusteringFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.LayoutFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.forcend.FORCEnDLayoutConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.parameter_training.ParameterTrainingFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.PostProcessingFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.InvalidTypeException;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.io.ConfigFile;
import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import javax.swing.JFileChooser;
import org.cytoscape.work.TaskMonitor;

public class TaskConfig {
    public static final String NAME = "TransClust";
    public static final String NAME_EXTENDED = "Clustering by Weighted Transitive Graph Projection";
    public static final String VERSION = "1.0";
    public static final String[] AUTHORS = new String[]{"Tobias Wittkop: tobias.wittkop@cebitec.uni-bielefeld.de", " and Jan Baumbach: jan.baumbach@icsi.berkeley.edu"};
    public static final String[] DEVELOPERS = new String[]{"Tobias Wittkop: tobias.wittkop@cebitec.uni-bielefeld.de", "Jan Baumbach: jan.baumbach@icsi.berkeley.edu", "Sita Lange: sita.lange@cebitec.uni-bielefeld.de", "Nils Kleinboelting: nils.kleinboelting@cebitec.uni-bielefeld.de", "and Dorothea Emig: demig@mpi-inf.mpg.de"};
    public static final String JAR = "TransClust.jar";
    public static final String NL = System.getProperty("line.separator");
    public static final String TAB = "\t";
    public static final String FS = System.getProperty("file.separator");
    public static final String DEFAULTCONFIG = "Default.conf";
    public static final int CLUSTERING_MODE = 0;
    public static final int GENERAL_TRAINING_MODE = 1;
    public static final int COMPARISON_MODE = 2;
    public static final int HIERARICHAL_MODE = 3;
    public static final int SYSTEM_NO_AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    public static LayoutFactory.EnumCCEdgesStructure ccEdgesEnum = LayoutFactory.EnumCCEdgesStructure.CC2DARRAY;
    public static LayoutFactory.EnumLayouterClass[] layouterEnumTypes = new LayoutFactory.EnumLayouterClass[]{LayoutFactory.EnumLayouterClass.FORCEND};
    public static ParameterTrainingFactory.EnumParameterTrainingClass parameterTrainingEnum = ParameterTrainingFactory.EnumParameterTrainingClass.PARAMETERTRAINER_SE;
    public static GeometricClusteringFactory.EnumGeometricClusteringClass geometricClusteringEnum = GeometricClusteringFactory.EnumGeometricClusteringClass.SINGLE_LINKAGE_CLUSTERING;
    public static PostProcessingFactory.EnumPostProcessingClass postProcessingEnum = PostProcessingFactory.EnumPostProcessingClass.PP_DIVIDE_AND_RECLUSTER_RECURSIVELY;
    public static String currentDirectory = System.getProperty("user.dir");
    public static JFileChooser jfc = new JFileChooser();
    public static String outConfigPath;
    public static String inputConfigPath;
    public static String clustersPath;
    public static String transitiveConnectedComponents;
    public static String cmPath;
    public static String goldstandardPath;
    public static String infoPath;
    public static File tempDir;
    public static boolean useThreads;
    public static int maxNoThreads;
    public static String ccEdgesClass;
    public static boolean verbose;
    public static int mode;
    public static boolean info;
    public static boolean gui;
    public static boolean useConfigFile;
    public static String layouterClasses;
    public static int dimension;
    public static String parameterTrainingClass;
    public static boolean doLayoutParameterTraining;
    public static int noOfParameterConfigurationsPerGeneration;
    public static int noOfGenerations;
    public static String geometricClusteringClass;
    public static boolean doPostProcessing;
    public static String postProcessingClass;
    public static boolean setLogLevel;
    public static TaskMonitor monitor;
    public static double minThreshold;
    public static double thresholdStepSize;
    public static double maxThreshold;
    public static boolean clusterHierarchicalComplete;
    public static boolean greedy;
    public static boolean fixedParameter;
    public static int fixedParameterMax;
    public static long fpMaxTimeMillis;
    public static boolean fpStopped;
    public static float upperBound;
    public static boolean reducedMatrix;
    private static boolean debug;
    public static boolean developerMode;
    public static boolean fuzzy;
    public static boolean overlap;
    public static double fuzzyThreshold;
    public static double lowerBound;
    public static boolean UseLimitK;
    public static int limitK;
    public static String knownAssignmentsFile;

    public static void initFromConfigFile(PropertyResourceBundle rb) throws MissingResourceException, InvalidTypeException, IOException {
        useThreads = Boolean.parseBoolean(rb.getString("general.useThreads").trim());
        int configMax = Integer.parseInt(rb.getString("general.maxNoThreads").trim());
        if (configMax > SYSTEM_NO_AVAILABLE_PROCESSORS) {
            configMax = SYSTEM_NO_AVAILABLE_PROCESSORS;
        }
        maxNoThreads = configMax;
        ccEdgesClass = rb.getString("general.ccEdgesDataStructure").trim();
        ccEdgesEnum = LayoutFactory.getCCEdgesEnumByClass(ccEdgesClass);
        verbose = Boolean.parseBoolean(rb.getString("general.verbose"));
        dimension = Integer.parseInt(rb.getString("layout.dimension").trim());
        layouterClasses = rb.getString("general.layouters").trim();
        layouterEnumTypes = LayoutFactory.getEnumArrayFromLayoutersString();
        geometricClusteringClass = rb.getString("general.geometricClusterer").trim();
        geometricClusteringEnum = GeometricClusteringFactory.getClustererEnumByClass(geometricClusteringClass);
        postProcessingClass = rb.getString("general.postProcessor").trim();
        postProcessingEnum = PostProcessingFactory.getPostProcessorEnumByClass(postProcessingClass);
        parameterTrainingClass = rb.getString("layout.parameterTraining").trim();
        parameterTrainingEnum = ParameterTrainingFactory.getParameterTrainingEnumByClass(parameterTrainingClass);
        doLayoutParameterTraining = Boolean.parseBoolean(rb.getString("layout.doParameterTraining").trim());
        noOfParameterConfigurationsPerGeneration = Integer.parseInt(rb.getString("layout.generationSize").trim());
        noOfGenerations = Integer.parseInt(rb.getString("layout.noOfGenerations").trim());
        doPostProcessing = Boolean.parseBoolean(rb.getString("general.doPostProcessing").trim());
        postProcessingClass = rb.getString("general.postProcessor").trim();
        postProcessingEnum = PostProcessingFactory.getPostProcessorEnumByClass(postProcessingClass);
        minThreshold = Double.parseDouble(rb.getString("ic.minThreshold").trim());
        maxThreshold = Double.parseDouble(rb.getString("ic.maxThreshold").trim());
        thresholdStepSize = Double.parseDouble(rb.getString("ic.thresholdStepSize").trim());
        clusterHierarchicalComplete = Boolean.parseBoolean(rb.getString("ic.clusterHierarchicalComplete").trim());
    }

    public static void saveConfigurationsToConfigFile(String filepath) {
        ConfigFile confile = new ConfigFile();
        confile.instantiateFile(filepath);
        confile.printHeader();
        confile.printnewln();
        confile.printnewln();
        confile.printnewln();
        confile.printSubHeader("GENERAL");
        confile.printParameter("general.useThreads", Boolean.toString(useThreads));
        confile.printParameter("general.maxNoThreads", "" + maxNoThreads);
        confile.printParameter("general.ccEdgesDataStructure", ccEdgesClass);
        confile.printParameter("general.layouters", layouterClasses);
        confile.printParameter("general.geometricClusterer", geometricClusteringClass);
        confile.printParameter("general.doPostProcessing", Boolean.toString(doPostProcessing));
        confile.printParameter("general.postProcessor", postProcessingClass);
        confile.printParameter("general.verbose", Boolean.toString(verbose));
        confile.printnewln();
        confile.printnewln();
        confile.printnewln();
        confile.printSubHeader("LAYOUT");
        confile.printParameter("layout.dimension", "" + dimension);
        confile.printParameter("layout.doParameterTraining", Boolean.toString(doLayoutParameterTraining));
        confile.printParameter("layout.parameterTraining", parameterTrainingClass);
        confile.printParameter("layout.generationSize", "" + noOfParameterConfigurationsPerGeneration);
        confile.printParameter("layout.noOfGenerations", "" + noOfGenerations);
        confile.printnewln();
        confile.printnewln();
        confile.printnewln();
        FORCEnDLayoutConfig.printParametersToConfig(confile);
        confile.printnewln();
        confile.printnewln();
        confile.printnewln();
        GeometricClusteringFactory.printParametersToConfig(confile);
        confile.printSubHeader("Iterative Clustering");
        confile.printParameter("ic.minThreshold", minThreshold + "");
        confile.printParameter("ic.thresholdStepSize", "" + thresholdStepSize);
        confile.printParameter("ic.maxThreshold", "" + maxThreshold);
        confile.printParameter("ic.clusterHierarchicalComplete", "" + clusterHierarchicalComplete);
        confile.flushbw();
    }

    public static StringBuffer printConfiguration() {
        StringBuffer sb = new StringBuffer();
        sb.append("CONFIGURATION");
        sb.append(NL);
        sb.append("-------------------------");
        sb.append(NL);
        sb.append(NL);
        if (mode == 0) {
            sb.append("MODE: Clustering mode (");
        } else if (mode == 1) {
            sb.append("MODE: General training mode (");
        } else if (mode == 2) {
            sb.append("MODE: iterative clustering (");
        } else if (mode == 3) {
            sb.append("MODE: hierarchical clustering (");
        } else {
            monitor.showMessage(TaskMonitor.Level.ERROR, "This mode does not exist or needs to be added here: " + mode);
            System.exit(-1);
        }
        sb.append(mode);
        sb.append(")");
        sb.append(NL + NL);
        sb.append("FILE PATHS");
        sb.append(NL);
        TaskConfig.addConfigToSB(sb, "Cost matrices", cmPath);
        if (mode == 0) {
            TaskConfig.addConfigToSB(sb, "Clustering results", clustersPath);
        } else if (mode == 1) {
            TaskConfig.addConfigToSB(sb, "Output config file", outConfigPath);
        }
        if (info) {
            TaskConfig.addConfigToSB(sb, "Info file", infoPath);
        }
        if (useConfigFile) {
            TaskConfig.addConfigToSB(sb, "Config file", inputConfigPath);
        }
        sb.append(NL);
        if (gui) {
            // empty if block
        }
        if (debug) {
            sb.append("CLUSTERING");
            sb.append(NL);
            if (!greedy) {
                TaskConfig.addConfigToSB(sb, "Layouter classes in order of execution", layouterClasses);
                TaskConfig.addConfigToSB(sb, "Layout dimension", "" + dimension);
                if (mode == 0) {
                    if (doLayoutParameterTraining) {
                        TaskConfig.addConfigToSB(sb, "ParameterTraining class", parameterTrainingClass);
                        TaskConfig.addConfigToSB(sb, "Number of parameter configurations per generation", "" + noOfParameterConfigurationsPerGeneration);
                        TaskConfig.addConfigToSB(sb, "Number of generations", "" + noOfGenerations);
                    } else {
                        sb.append("Parameter training is turned off!");
                        sb.append(NL);
                    }
                } else if (mode == 1) {
                    sb.append(NL);
                    sb.append("Options For General Training Mode " + NL);
                    TaskConfig.addConfigToSB(sb, "Number of parameter configurations per generation", "" + noOfParameterConfigurationsPerGeneration);
                    TaskConfig.addConfigToSB(sb, "Number of generations", "" + noOfGenerations);
                    sb.append(NL);
                }
                TaskConfig.addConfigToSB(sb, "Geometric clustering class", geometricClusteringClass);
            } else {
                TaskConfig.addConfigToSB(sb, "using greedy approximation", "");
            }
            if (fixedParameter) {
                // empty if block
            }
            if (doPostProcessing) {
                TaskConfig.addConfigToSB(sb, "Post-processing class", postProcessingClass);
            } else {
                sb.append("Post-processing is turned off!");
            }
        }
        return sb;
    }

    private static void addConfigToSB(StringBuffer sb, String descr, String value) {
        sb.append(descr);
        sb.append(":  ");
        sb.append(value);
        sb.append(NL);
    }

    static {
        inputConfigPath = DEFAULTCONFIG;
        useThreads = true;
        maxNoThreads = Runtime.getRuntime().availableProcessors() - 1;
        ccEdgesClass = "CC2DArray";
        verbose = false;
        mode = 0;
        info = false;
        gui = false;
        useConfigFile = false;
        layouterClasses = "FORCEnDLayouter";
        dimension = 3;
        parameterTrainingClass = "ParameterTraining_SE";
        doLayoutParameterTraining = false;
        noOfParameterConfigurationsPerGeneration = 15;
        noOfGenerations = 3;
        geometricClusteringClass = "SingleLinkageClusterer";
        doPostProcessing = true;
        postProcessingClass = "PP_DivideAndReclusterRecursively";
        setLogLevel = false;
        monitor = null;
        minThreshold = 0.0;
        thresholdStepSize = 1.0;
        maxThreshold = 100.0;
        clusterHierarchicalComplete = false;
        greedy = false;
        fixedParameter = true;
        fixedParameterMax = 20;
        fpMaxTimeMillis = 1000L;
        fpStopped = false;
        upperBound = Float.MAX_VALUE;
        reducedMatrix = false;
        debug = false;
        developerMode = true;
        fuzzy = false;
        overlap = false;
        fuzzyThreshold = 0.5;
        lowerBound = 0.0;
        UseLimitK = false;
        limitK = 7;
    }
}

