/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.io;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.geometric_clustering.GeometricClusteringConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.geometric_clustering.GeometricClusteringFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.LayoutFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.forcend.FORCEnDLayoutConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.layout.parameter_training.ParameterTrainingFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.postprocessing.PostProcessingFactory;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.TaskConfig;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.TransClust.de.layclust.taskmanaging.io.ArgsParseException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgsUtility {
    private static final String NL = TaskConfig.NL;
    private static final String TAB = "\t";

    protected static HashMap<String, String> createOptionsHash(String[] args, String optionIndicator) throws ArgsParseException {
        if (args.length != 0 && args != null) {
            HashMap<String, String> options = new HashMap<String, String>();
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].startsWith(optionIndicator)) continue;
                if (args.length <= i + 1) {
                    throw new ArgsParseException("No value found for parameter " + args[i] + ".");
                }
                String key = args[i].substring(optionIndicator.length());
                String value = args[i + 1];
                if (value.startsWith(optionIndicator)) {
                    throw new ArgsParseException("No value found for parameter" + key + ".");
                }
                options.put(key, args[i + 1]);
                ++i;
            }
        }
        return null;
    }

    protected static String getStringValue(String key, HashMap<String, String> options) throws ArgsParseException {
        String value = options.get(key);
        if (value == null) {
            throw new ArgsParseException("Key " + key + " unknown.");
        }
        return value;
    }

    protected static int getIntValue(String key, HashMap<String, String> options) throws ArgsParseException {
        String value = options.get(key);
        if (value == null) {
            throw new ArgsParseException("Key " + key + " unknown.");
        }
        return Integer.parseInt(value);
    }

    protected static double getDoubleValue(String key, HashMap<String, String> options) throws ArgsParseException {
        String value = options.get(key);
        if (value == null) {
            throw new ArgsParseException("Key " + key + " unknown.");
        }
        return Double.parseDouble(value);
    }

    protected static float getFloatValue(String key, HashMap<String, String> options) throws ArgsParseException {
        String value = options.get(key);
        if (value == null) {
            throw new ArgsParseException("Key " + key + " unknown.");
        }
        return Float.parseFloat(value);
    }

    protected static boolean getBoolValue(String key, HashMap<String, String> options) throws ArgsParseException {
        String value = options.get(key);
        if (value == null) {
            throw new ArgsParseException("Key " + key + " unknown.");
        }
        return Boolean.parseBoolean(value);
    }

    public static StringBuffer createUsage() {
        StringBuffer sb = new StringBuffer(500);
        ArgsUtility.header("SUMMARY", "This program clusters objects into transitive groups according to the weighted graph cluster editing problem using the given cost matrices.", sb);
        ArgsUtility.header("ABOUT", "TransClust version 1.0", sb);
        ArgsUtility.tabLine("Copyright 2008 by", sb);
        for (int i = 0; i < TaskConfig.AUTHORS.length; ++i) {
            ArgsUtility.tabLine(TaskConfig.AUTHORS[i], sb);
        }
        ArgsUtility.header("USAGE", "java -jar [java virtual machine options] TransClust.jar [-key value]", sb);
        sb.append(NL);
        ArgsUtility.tabLine("e.g. java -jar -Xmx2G -Xss100MTransClust.jar -i cost_matrix_dir -o clusters.cls", sb);
        sb.append(NL);
        ArgsUtility.tabLine("Note: If the input is large and/or complex then the virtual machine options must be set.", sb);
        ArgsUtility.tabLine("Any values that inlude spaces must be surrounded by quotation marks '\"'.", sb);
        ArgsUtility.tabLine("{ } denotes the value choices, [ ] means that the value is a list, and ' ' surrounds a description of the value. ", sb);
        ArgsUtility.tabLine("Further note that the keys are not case sensitive, but the class names of the respective implementations are!", sb);
        sb.append(NL);
        ArgsUtility.header("COMPULSORY OPTIONS", "One of the following must be entered.", sb);
        sb.append(NL);
        ArgsUtility.tabLine("-key  value", sb);
        ArgsUtility.optionsLine("-i", "{'inputdir', 'costmatrixfile.cm'}", "", "Input file or directory.", sb);
        ArgsUtility.optionsLine("-o", "{'output.file', 'output.conf'}", "", "Output file for the clustering results or the generated config file.", sb);
        ArgsUtility.tabLine("OR", sb);
        ArgsUtility.optionsLine("-gui", "{[OTHER OPTIONS]}", "", "Start the program with the graphical user interface. It is also possible to initialise the gui with the OTHER OPTIONS defined below!", sb);
        ArgsUtility.tabLine("OR", sb);
        ArgsUtility.optionsLine("-help", "{}", "", "Show this help manual.", sb);
        sb.append(NL);
        ArgsUtility.header("OTHER OPTIONS", "These are optional. All parameters that are not specified here are first taken from the input config file if stated,otherwise from the default config file that comes with this program. IMPORTANT: The given input parameter values override any values written in the config files.", sb);
        sb.append(NL);
        ArgsUtility.tabLine("-key  value  (default value)", sb);
        ArgsUtility.subheader("EXTRA (not defined in the config file)", sb);
        ArgsUtility.optionsLine("-verbose", "{}", "()", "Write a short summary of the program results to the standard output (console).", sb);
        ArgsUtility.optionsLine("-cf", "{true, false}", "(" + TaskConfig.useConfigFile + ")", "Use config file (true) or hard coded standard options (false).", sb);
        ArgsUtility.optionsLine("-config", "{'config.conf'}", "", "A config file with the program parameters in the correct format (see documentation for details).", sb);
        ArgsUtility.optionsLine("-mode", "{0,1}", "(" + TaskConfig.mode + ")", "Determines the mode in which the program should be started", sb);
        ArgsUtility.optionsNote("0", "Default clustering mode: clustering of given input and writing the clusters to the output file.", sb);
        ArgsUtility.optionsNote("1", "General training mode: trains a set of data (cost matrices) and writes the generated parameters in the output file.", sb);
        ArgsUtility.optionsLine("-info", "{'file.info'}", "", "A summary of what functions the program carried out.", sb);
        ArgsUtility.optionsNote("", "This file includes information such the date, the input and output files, which mode the program was carried out in, and which processes were done using which implementations.", sb);
        ArgsUtility.optionsLine("-log", "{ALL,FINEST,FINER,FINE,CONFIG,INFO,WARNING,SEVERE,OFF}", "()", "Defines the level of logging from the most sensitive level to completely off.", sb);
        ArgsUtility.subheader("GENERAL", sb);
        ArgsUtility.optionsLine("-l", "['layouterClass']", "(" + TaskConfig.layouterClasses + ")", "A List of class names of layouter implementations. These implementations are then used for the layouting phase in the order they are given. Each name should be separated by a \",\" (comma). E.g. FORCEnDLayouter,ACCLayouter  or for just one layouter, then only e.g. FORCEnDLayouter.", sb);
        ArgsUtility.optionsNote("Implemented Classes", ArgsUtility.printArray(LayoutFactory.EnumLayouterClass.getClassnames()), sb);
        ArgsUtility.optionsLine("-g", "{'geometricClustererClass'}", "(" + TaskConfig.geometricClusteringClass + ")", "The class name of the geometric clustering implementation.", sb);
        ArgsUtility.optionsNote("Implemented Classes", ArgsUtility.printArray(GeometricClusteringFactory.EnumGeometricClusteringClass.getClassnames()), sb);
        ArgsUtility.optionsLine("-p", "{'postProcessorClass'}", "(" + TaskConfig.postProcessingClass + ")", "The class name of the post processing implementation. Write 'none' if post-processing should NOT be carried out.", sb);
        ArgsUtility.optionsNote("Implemented Classes", ArgsUtility.printArray(PostProcessingFactory.EnumPostProcessingClass.getClassnames()), sb);
        ArgsUtility.optionsLine("-e", "{ICCEdgesImplementation}", "(" + TaskConfig.ccEdgesClass + ")", "The class name of the implementation of the ICCEdges interface describing the datastructure for the costs between objects.", sb);
        ArgsUtility.optionsNote("Implemented Classes", ArgsUtility.printArray(LayoutFactory.EnumCCEdgesStructure.getClassnames()), sb);
        ArgsUtility.optionsLine("-t", "{1,...,max no. CPUs}", "(" + TaskConfig.maxNoThreads + ")", "Turn the use of multiple threads on and give the maximum no. of parallel threads (do not give a number greater than the number of CPUs your system has).", sb);
        ArgsUtility.subheader("GENERAL LAYOUT", sb);
        ArgsUtility.optionsLine("-ld", "{2,...,n}", "(" + TaskConfig.dimension + ")", "The dimension in which the layouters should run in. NOTE: Because of runtime reasons, ACCLayouter only makes sense for dimensions 2 and 3.", sb);
        ArgsUtility.optionsLine("-lp", "{'parameterTrainingClass'}", "(" + TaskConfig.parameterTrainingClass + ")", "The class name of the parameter training implementation. Write 'none' if parameter training should NOT be carried out.", sb);
        ArgsUtility.optionsNote("Implemented Classes", ArgsUtility.printArray(ParameterTrainingFactory.EnumParameterTrainingClass.getClassnames()), sb);
        ArgsUtility.optionsLine("-lps", "{2,...,n}", "(" + TaskConfig.noOfParameterConfigurationsPerGeneration + ")", "Number of parameter configurations for each generation in the parameter training.", sb);
        ArgsUtility.optionsLine("-lpn", "{1,...,n}", "(" + TaskConfig.noOfGenerations + ")", "The number of generations that should be used for parameter training.", sb);
        ArgsUtility.subheader("FORCEnDLayouter", sb);
        ArgsUtility.optionsLine("-fa", "{'double'}", "(" + FORCEnDLayoutConfig.attractionFactor + ")", "The value for the attraction factor.", sb);
        ArgsUtility.optionsLine("-fr", "{'double'}", "(" + FORCEnDLayoutConfig.repulsionFactor + ")", "The value for the repulsion factor.", sb);
        ArgsUtility.optionsLine("-fi", "{'integer'}", "(" + FORCEnDLayoutConfig.iterations + ")", "Number of iterations.", sb);
        ArgsUtility.optionsLine("-ft", "{'float'}", "(" + FORCEnDLayoutConfig.temperature + ")", "The cooling temperature value for the convergence of the layout.", sb);
        ArgsUtility.subheader("GEOMETRIC CLUSTERING", sb);
        ArgsUtility.subheader("SingleLinkageClusterer", sb);
        ArgsUtility.optionsLine("-sm", "{'double'}", "(" + GeometricClusteringConfig.minDistance + ")", "The minimum distance.", sb);
        ArgsUtility.optionsLine("-sx", "{'double'}", "(" + GeometricClusteringConfig.maxDistance + ")", "The maximum distance to look at.", sb);
        ArgsUtility.optionsLine("-ss", "{'double'}", "(" + GeometricClusteringConfig.stepsize + ")", "The step size.", sb);
        ArgsUtility.optionsLine("-sf", "{'double'}", "(" + GeometricClusteringConfig.stepsizeFactor + ")", "The step size factor.", sb);
        ArgsUtility.subheader("KmeansClusterer", sb);
        ArgsUtility.optionsLine("-km", "{'integer'}", "(" + GeometricClusteringConfig.kLimit + ")", "The maximum k value that is allowed. This means the maximum number of clusters that the input can be divided into.", sb);
        ArgsUtility.optionsLine("-ki", "{'integer'}", "(" + GeometricClusteringConfig.maxInitStartConfigs + ")", "Maximum number of different initial starting point combinations (for one k) that k-means uses.", sb);
        sb.append(NL);
        return sb;
    }

    private static void optionsLine(String key, String values, String defaultValue, String description, StringBuffer sb) {
        int space;
        sb.append(NL);
        sb.append(TAB);
        sb.append(key);
        sb.append("  ");
        sb.append(values);
        sb.append("  ");
        sb.append(defaultValue);
        sb.append(NL);
        sb.append(TAB);
        sb.append(TAB);
        int step = 60;
        int length = description.length();
        for (int i = 0; i < length; i += step + space) {
            if (i + step - 1 >= length) {
                sb.append(description.substring(i));
                sb.append(NL);
                break;
            }
            space = ArgsUtility.findClosestSpace(description, i + step - 1, length);
            sb.append(description.substring(i, i + step + space));
            sb.append(NL + TAB + TAB);
        }
    }

    private static void header(String header, String description, StringBuffer sb) {
        int space;
        sb.append(NL);
        sb.append(NL);
        sb.append(header);
        sb.append(NL);
        sb.append(TAB);
        int step = 65;
        int length = description.length();
        for (int i = 0; i < length; i += step + space) {
            if (i + step - 1 >= length) {
                sb.append(description.substring(i));
                sb.append(NL);
                break;
            }
            space = ArgsUtility.findClosestSpace(description, i + step - 1, length);
            sb.append(description.substring(i, i + step + space));
            sb.append(NL + TAB);
        }
    }

    private static void tabLine(String string, StringBuffer sb) {
        int space;
        sb.append(TAB);
        int step = 65;
        int length = string.length();
        for (int i = 0; i < length; i += step + space) {
            if (i + step - 1 >= length) {
                sb.append(string.substring(i));
                sb.append(NL);
                break;
            }
            space = ArgsUtility.findClosestSpace(string, i + step - 1, length);
            sb.append(string.substring(i, i + step + space));
            sb.append(NL + TAB);
        }
    }

    private static void optionsNote(String key, String string, StringBuffer sb) {
        int space;
        sb.append(TAB);
        sb.append(TAB);
        sb.append(key);
        sb.append(TAB);
        int step = 50;
        int length = string.length();
        for (int i = 0; i < length; i += step + space) {
            if (i + step - 1 >= length) {
                sb.append(string.substring(i));
                sb.append(NL);
                break;
            }
            space = ArgsUtility.findClosestSpace(string, i + step - 1, length);
            sb.append(string.substring(i, i + step + space));
            sb.append(NL + TAB + TAB + TAB);
        }
    }

    private static void subheader(String header, StringBuffer sb) {
        sb.append(NL);
        sb.append(TAB);
        sb.append(header);
        sb.append(NL);
    }

    private static int findClosestSpace(String string, int pos, int length) {
        for (int i = 0; i < 10; ++i) {
            if (pos + i < length && pos - i >= 0) {
                if (string.charAt(pos + i) == ' ') {
                    return i;
                }
                if (string.charAt(pos - i) != ' ') continue;
                return -i;
            }
            return length - 1 - pos;
        }
        return 0;
    }

    private static String printArray(String[] array) {
        StringBuffer stringbuff = new StringBuffer();
        stringbuff.append("{");
        for (int i = 0; i < array.length - 1; ++i) {
            stringbuff.append(array[i]);
            stringbuff.append(", ");
        }
        stringbuff.append(array[array.length - 1]);
        stringbuff.append("}");
        return stringbuff.toString();
    }
}

